# バッチ設計書 100-configure-toolset.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるツールセット設定スクリプト（configure-toolset.ps1）の設計仕様を定義するものである。このスクリプトは、ビルドツールチェーンのカスタム設定を行い、特にArcadeのデフォルトネイティブツールセットインストールを無効化する。

### 本バッチの処理概要

このバッチは、Arcadeビルドシステムにおけるネイティブツールセット（CMake、Ninja等）の自動インストールを無効化するための設定を行う。GitHub Issue #2673で報告された問題への回避策として、ネイティブツールインストールを無効にする変数を設定する。

**業務上の目的・背景**：Arcadeビルドシステムはデフォルトでネイティブビルドツール（CMake、Ninja等）の自動インストールを試みる。しかし、.NET Runtimeリポジトリでは独自のツールセット管理を行っており、Arcadeのデフォルト動作と競合する場合がある。特にGitHub Issue dotnet/arcade#2673で報告された問題を回避するため、このスクリプトでネイティブツールセットの自動インストールを無効化する。

**バッチの実行タイミング**：Arcadeのtools.ps1が読み込まれる前に、ドットソースとして読み込まれる。ビルド処理の最初期段階で実行される。

**主要な処理内容**：
1. $script:DisableNativeToolsetInstalls変数を$trueに設定
2. これによりArcadeのInitializeNativeTools関数がツールのインストールをスキップ

**前後の処理との関連**：eng/common/tools.ps1またはbuild.ps1から読み込まれ、後続のArcadeビルドスクリプトに影響を与える。ネイティブツールは別の方法（プリインストール、手動インストール、別スクリプト等）で提供される前提。

**影響範囲**：ビルドプロセス全体のネイティブツールセット管理に影響。この設定が有効な場合、CMakeやNinjaなどのネイティブツールは自動インストールされない。

## バッチ種別

設定ファイル / ビルドカスタマイズ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | N/A（直接実行されない） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Arcadeビルドスクリプトからの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| 呼び出し元 | Arcadeビルドスクリプト（eng/common/tools.ps1等） |

### 実行可否判定

常に実行される（変数設定のみのため）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 入力データソースなし |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $script:DisableNativeToolsetInstalls | bool | $trueに設定されるスクリプトスコープ変数 |

### 設定項目詳細

| 変数名 | 型 | 設定値 | 説明 |
|--------|-----|--------|------|
| $script:DisableNativeToolsetInstalls | bool | $true | Arcadeのネイティブツール自動インストールを無効化 |

## 処理フロー

### 処理シーケンス

```
1. スクリプト読み込み
   └─ 呼び出し元からドットソースで読み込み
2. 変数設定
   └─ $script:DisableNativeToolsetInstalls = $true
3. 効果
   └─ Arcadeのネイティブツールインストール処理がスキップされる
```

### フローチャート

```mermaid
flowchart TD
    A[Arcadeビルドスクリプト起動] --> B[configure-toolset.ps1読み込み]
    B --> C[$DisableNativeToolsetInstalls = $true]
    C --> D[Arcadeのtools.ps1継続]
    D --> E{ネイティブツール初期化?}
    E -->|$DisableNativeToolsetInstalls==$true| F[インストールスキップ]
    E -->|$DisableNativeToolsetInstalls==$false| G[ツール自動インストール]
    F --> H[ビルド継続]
    G --> H
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | N/A | エラー発生なし（変数設定のみ） | N/A |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

このスクリプト自体は単純な変数設定であり、失敗することはない。ただし、この設定の結果としてネイティブツールが見つからない場合、後続のビルド処理が失敗する可能性がある。その場合は手動でCMake、Ninja等をインストールする必要がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | N/A（変数設定のみ） |
| 目標処理時間 | 瞬時（ミリ秒以下） |
| メモリ使用量上限 | 最小限 |

## 排他制御

なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- このスクリプトはGitHub Issue dotnet/arcade#2673への回避策（Workaround）として実装されている
- コメントに記載: "Working around issue https://github.com/dotnet/arcade/issues/2673"
- $script:スコープ修飾子は、この変数がスクリプトスコープで定義されることを示す
- Arcadeのtools.ps1では、この変数がチェックされ、$trueの場合はネイティブツールの自動インストールがスキップされる
- .NET Runtimeリポジトリでは、ネイティブツールは別途管理されているため、この設定が必要
- 将来的にArcadeの問題が解決された場合、このスクリプトは不要になる可能性がある
