# バッチ設計書 11-dotnet-install.sh

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるdotnet SDKインストールスクリプト（Linux/macOS向け）`eng/common/dotnet-install.sh`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NET SDKおよびランタイムを指定されたバージョンとアーキテクチャでローカル環境にインストールする機能を提供する。クロスプラットフォーム開発において、プロジェクトで必要とされる特定バージョンのSDKを自動的に取得・配置することで、ビルド環境の一貫性を担保する。

**業務上の目的・背景**：.NETプロジェクトのビルドには特定バージョンのSDKが必要であり、開発者やCI環境で異なるバージョンが混在すると再現性の問題が発生する。本スクリプトはglobal.jsonで指定されたSDKバージョンを自動的にインストールすることで、チーム全体でのビルド環境統一を実現する。

**バッチの実行タイミング**：ビルド前の初期化フェーズ、または開発者が明示的にSDKをインストールする際に随時実行される。CI/CDパイプラインでは各ビルドジョブの開始時に自動実行される。

**主要な処理内容**：
1. コマンドライン引数の解析（バージョン、アーキテクチャ、ランタイム種別等）
2. 実行環境のCPUアーキテクチャ自動検出（arm64、x64、x86、arm、riscv64、loongarch64）
3. tools.shの共通関数を利用したSDKインストール実行
4. インストール結果の検証とエラーハンドリング

**前後の処理との関連**：本スクリプトは単独で実行可能だが、通常はbuild.shやCI パイプラインから呼び出される。インストール後のSDKはdotnet.shやその他のビルドスクリプトで利用される。

**影響範囲**：ローカルの.dotnetディレクトリにSDKがインストールされる。システムグローバルなdotnetインストールには影響しない。

## バッチ種別

SDK/ツールチェーンセットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/スクリプト呼び出し/CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| bash環境 | bash 3.x以上が利用可能であること |
| ネットワーク接続 | dotnet SDKダウンロード用のインターネット接続 |
| tools.sh | 同ディレクトリにtools.shが存在すること |
| 書き込み権限 | repo_root/.dotnetディレクトリへの書き込み権限 |

### 実行可否判定

- 引数が正しく指定されていること
- tools.shがソース読み込み可能であること
- InstallDotNet関数が利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -version / -v | string | No | Latest | インストールするSDK/ランタイムのバージョン |
| -architecture / -a | string | No | 自動検出 | ターゲットアーキテクチャ（x64, x86, arm, arm64等） |
| -runtime / -r | string | No | dotnet | ランタイム種別（dotnet, aspnetcore, windowsdesktop, sdk） |
| -runtimesourcefeed | string | No | 空 | カスタムソースフィードURL |
| -runtimesourcefeedkey | string | No | 空 | ソースフィード認証キー（Base64エンコード） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDKバージョン定義（tools.sh経由で参照） |
| dotnet-install.sh | Shell | Microsoft公式インストールスクリプト（ダウンロード） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${repo_root}/.dotnet/ | ディレクトリ | インストールされたSDK/ランタイム |
| ${repo_root}/.dotnet/${architecture}/ | ディレクトリ | 異なるアーキテクチャ用SDK（クロスビルド時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | dotnet実行ファイルおよび関連ライブラリ |
| 出力先 | ${repo_root}/.dotnet/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパス解決
   └─ シンボリックリンクを解決して実際のスクリプト位置を特定
2. tools.shの読み込み
   └─ 共通関数（InstallDotNet等）を利用可能にする
3. コマンドライン引数解析
   └─ version, architecture, runtime, sourcefeed等のパラメータ取得
4. CPUアーキテクチャ検出
   └─ uname -mコマンドでホストアーキテクチャを判定
5. dotnetルートディレクトリ決定
   └─ アーキテクチャに応じて.dotnetまたは.dotnet/${arch}を選択
6. InstallDotNet関数呼び出し
   └─ tools.shの関数でSDKインストールを実行
7. 終了コード処理
   └─ 成功時は0、失敗時はエラーコードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[tools.sh読み込み]
    C --> D[引数解析]
    D --> E{引数エラー?}
    E -->|エラー| F[エラー出力して終了]
    E -->|OK| G[CPUアーキテクチャ検出]
    G --> H[dotnetルート決定]
    H --> I[InstallDotNet実行]
    I --> J{インストール成功?}
    J -->|失敗| K[エラーログ出力]
    K --> L[エラーコードで終了]
    J -->|成功| M[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正なコマンドライン引数が指定された | 正しい引数形式を確認して再実行 |
| 非0 | インストール失敗 | ネットワークエラー、ディスク容量不足等 | ネットワーク接続確認、ディスク空き容量確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（tools.shのwith_retries関数経由） |
| リトライ間隔 | 指数バックオフ（3^n - 1 秒） |
| リトライ対象エラー | ネットワーク関連エラー |

### 障害時対応

1. ネットワーク接続を確認
2. プロキシ設定を確認（企業環境の場合）
3. 手動でdotnet-install.shをダウンロードして実行
4. 代替フィード（-runtimesourcefeed）を指定して再試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のインストールで1バージョン |
| 目標処理時間 | ネットワーク環境依存（通常1-5分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は許可されるが、同一ディレクトリへの並行インストールは競合の可能性がある。CI環境では通常、ジョブ単位で独立したワークスペースを使用する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | InstallDotNet関数呼び出し時 | インストール対象バージョン情報 |
| 進捗ログ | ダウンロード中 | ダウンロード元URL、試行回数 |
| 終了ログ | インストール完了時 | 成功/失敗ステータス |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによるエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 600秒 | CI/CDパイプライン |
| エラー件数 | 1件 | CI/CDパイプライン |

## 備考

- 本スクリプトはArcade SDKの共通インフラストラクチャの一部として提供される
- アーキテクチャ検出はuname -mコマンドに依存し、arm64/aarch64、amd64/x86_64、armv*l、i[3-6]86、riscv64、loongarch64に対応
- 32bit OSが64bit CPU上で動作している場合（例：Raspberry Pi OS）の検出ロジックも含む
