# バッチ設計書 12-dotnet-install.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるdotnet SDKインストールスクリプト（Windows向け）`eng/common/dotnet-install.ps1`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Windows環境において.NET SDKおよびランタイムを指定されたバージョンとアーキテクチャでローカル環境にインストールする機能を提供する。Linux/macOS向けの`dotnet-install.sh`のWindows版として、同等の機能をPowerShellで実装している。

**業務上の目的・背景**：Windows環境でのビルドにおいて、プロジェクトが要求する特定バージョンの.NET SDKを自動的にインストールする必要がある。CI/CD環境やローカル開発環境において、global.jsonで定義されたSDKバージョンを確実にインストールすることで、ビルドの再現性を保証する。Visual StudioがインストールされているマシンでもプロジェクトローカルのSDKを使用することで、システム全体への影響を回避する。

**バッチの実行タイミング**：Windowsでのビルド前の初期化フェーズ、または開発者が明示的にSDKをインストールする際に随時実行される。CI/CDパイプライン（Azure DevOps等）では各ビルドジョブの開始時に自動実行される。

**主要な処理内容**：
1. コマンドライン引数の解析（バージョン、アーキテクチャ、ランタイム種別等）
2. tools.ps1の共通関数を利用したSDKインストール実行
3. x86アーキテクチャ指定時の専用サブディレクトリ配置
4. インストール結果の検証とエラーハンドリング

**前後の処理との関連**：本スクリプトは単独で実行可能だが、通常はbuild.cmdやCIパイプラインから呼び出される。インストール後のSDKはdotnet.ps1やその他のビルドスクリプトで利用される。

**影響範囲**：ローカルの.dotnetディレクトリにSDKがインストールされる。システムグローバルなdotnetインストールには影響しない。

## バッチ種別

SDK/ツールチェーンセットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/スクリプト呼び出し/CI |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell 5.1以上またはPowerShell Core |
| ネットワーク接続 | dotnet SDKダウンロード用のインターネット接続 |
| tools.ps1 | 同ディレクトリにtools.ps1が存在すること |
| 書き込み権限 | RepoRoot\.dotnetディレクトリへの書き込み権限 |

### 実行可否判定

- 引数が正しく指定されていること
- tools.ps1がドットソース読み込み可能であること
- InstallDotNet関数が利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -verbosity | string | No | minimal | MSBuild詳細度レベル |
| -architecture | string | No | 空（自動検出） | ターゲットアーキテクチャ（x64, x86等） |
| -version | string | No | Latest | インストールするSDK/ランタイムのバージョン |
| -runtime | string | No | dotnet | ランタイム種別（dotnet, aspnetcore, windowsdesktop, sdk） |
| -RuntimeSourceFeed | string | No | 空 | カスタムソースフィードURL |
| -RuntimeSourceFeedKey | string | No | 空 | ソースフィード認証キー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDKバージョン定義（tools.ps1経由で参照） |
| dotnet-install.ps1 | PowerShell | Microsoft公式インストールスクリプト（ダウンロード） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ${RepoRoot}\.dotnet\ | ディレクトリ | インストールされたSDK/ランタイム |
| ${RepoRoot}\.dotnet\x86\ | ディレクトリ | x86アーキテクチャ用SDK |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | dotnet.exe実行ファイルおよび関連ライブラリ |
| 出力先 | ${RepoRoot}\.dotnet\ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. パラメータバインディング
   └─ CmdletBinding属性によりPowerShellパラメータ処理
2. tools.ps1の読み込み
   └─ ドットソースで共通関数を読み込み
3. dotnetルートディレクトリ決定
   └─ RepoRootから.dotnetパスを構築
4. アーキテクチャ判定
   └─ x86指定時は専用サブディレクトリを使用
5. InstallDotNet関数呼び出し
   └─ tools.ps1の関数でSDKインストールを実行
6. 例外処理
   └─ try-catchでエラーをキャッチしパイプラインエラーとして報告
7. 終了コード設定
   └─ ExitWithExitCodeで適切な終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ解析]
    B --> C[tools.ps1読み込み]
    C --> D[dotnetRoot決定]
    D --> E{x86アーキテクチャ?}
    E -->|Yes| F[x86サブディレクトリ設定]
    E -->|No| G[標準ディレクトリ使用]
    F --> H[InstallDotNet実行]
    G --> H
    H --> I{例外発生?}
    I -->|Yes| J[スタックトレース出力]
    J --> K[Write-PipelineTelemetryError]
    K --> L[ExitWithExitCode 1]
    I -->|No| M[ExitWithExitCode 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストール失敗 | ネットワークエラー、ディスク容量不足、権限エラー等 | ネットワーク接続確認、ディスク空き容量確認、管理者権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | tools.ps1のInstallDotNet関数に依存 |
| リトライ間隔 | tools.ps1の実装に依存 |
| リトライ対象エラー | ネットワーク関連エラー |

### 障害時対応

1. ネットワーク接続を確認
2. プロキシ設定を確認（企業環境の場合）
3. PowerShell実行ポリシーを確認（Set-ExecutionPolicy）
4. 手動でdotnet-install.ps1をダウンロードして実行
5. 代替フィード（-RuntimeSourceFeed）を指定して再試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のインストールで1バージョン |
| 目標処理時間 | ネットワーク環境依存（通常1-5分） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は許可されるが、同一ディレクトリへの並行インストールは競合の可能性がある。CI環境では通常、ジョブ単位で独立したワークスペースを使用する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | InstallDotNet関数呼び出し時 | インストール対象バージョン情報 |
| 進捗ログ | ダウンロード中 | ダウンロード元URL |
| 終了ログ | インストール完了時 | 成功/失敗ステータス |
| エラーログ | 例外発生時 | スタックトレース、Write-PipelineTelemetryErrorによるエラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 600秒 | CI/CDパイプライン |
| エラー件数 | 1件 | CI/CDパイプライン |

## 備考

- 本スクリプトはArcade SDKの共通インフラストラクチャの一部として提供される
- Linux/macOS版（dotnet-install.sh）と同等の機能をWindows環境で提供
- x86アーキテクチャ指定時のみサブディレクトリを使用し、その他のアーキテクチャは標準の.dotnetディレクトリを使用
- CmdletBinding属性によりPositionalBinding=$falseが設定され、名前付きパラメータのみ受け付ける
