# バッチ設計書 14-dotnet.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるdotnet実行ラッパースクリプト（Windows向け）`eng/common/dotnet.ps1`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Windows環境において.NET SDKの初期化を行い、オプションで追加の引数を指定してdotnetコマンドを実行するPowerShellラッパースクリプトである。Linux/macOS向けの`dotnet.sh`のWindows版として、同等の機能を提供する。

**業務上の目的・背景**：Windows開発環境やCI環境において、システムにグローバルにインストールされたdotnetではなく、プロジェクトで管理された特定バージョンのSDKを使用する必要がある。本スクリプトはtools.ps1の初期化関数を呼び出してプロジェクトローカルのSDKを準備し、そのSDKでdotnetコマンドを実行することで、ビルド環境の一貫性を保証する。

**バッチの実行タイミング**：開発者が手動でdotnetコマンドを実行する際、またはビルドスクリプトからdotnetを呼び出す際に随時使用される。他のスクリプトからユーティリティとして呼び出されることも多い。

**主要な処理内容**：
1. tools.ps1の読み込みによる共通関数の利用可能化
2. InitializeDotNetCli関数によるSDKの初期化（必要に応じてインストール）
3. 引数が提供された場合、初期化されたSDKでdotnetコマンドを実行
4. DOTNET_NOLOGO環境変数の設定によるバナー抑制

**前後の処理との関連**：本スクリプトは単独で使用可能だが、build.cmdや他のビルド関連スクリプトから間接的に使用されることがある。SDK初期化後はdotnetRootにdotnetパスが格納される。

**影響範囲**：SDK初期化により環境変数が設定される可能性がある。実行されたdotnetコマンドの結果に応じてファイルシステムに変更が発生する。

## バッチ種別

SDK/ツールチェーンユーティリティ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/スクリプト呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell 5.1以上またはPowerShell Core |
| tools.ps1 | 同ディレクトリにtools.ps1が存在すること |
| ネットワーク接続 | SDKが未インストールの場合、ダウンロード用に必要 |

### 実行可否判定

- tools.ps1がドットソース読み込み可能であること
- InitializeDotNetCli関数が利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $args | object[] | No | なし | dotnetコマンドに渡す任意の引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | SDKバージョン定義（tools.ps1経由で参照） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | dotnetコマンドの出力 |
| 標準エラー出力 | テキスト | dotnetコマンドのエラー出力 |

### 出力ファイル仕様

dotnetコマンドの引数に依存。スクリプト自体は直接ファイルを出力しない。

## 処理フロー

### 処理シーケンス

```
1. tools.ps1の読み込み
   └─ ドットソースで共通関数を読み込み
2. InitializeDotNetCli呼び出し
   └─ -install:$trueでSDK初期化（必要に応じてインストール）
3. 引数チェック
   └─ $args.countが0より大きいか確認
4. DOTNET_NOLOGO設定（引数がある場合）
   └─ 環境変数でバナー出力を抑制
5. dotnetコマンド実行（引数がある場合）
   └─ 初期化されたSDKのdotnet.exeで引数を実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[InitializeDotNetCli -install:$true]
    C --> D[dotnetRoot取得]
    D --> E{引数あり?}
    E -->|No| F[終了]
    E -->|Yes| G[DOTNET_NOLOGO=1 設定]
    G --> H[dotnet.exe 引数 実行]
    H --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | SDK初期化失敗 | SDKダウンロード失敗、global.json不正等 | ネットワーク確認、global.json確認 |
| 非0 | dotnetコマンドエラー | 渡された引数に対するdotnetの実行エラー | dotnetコマンドのエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | SDK初期化はtools.ps1に依存 |
| リトライ間隔 | SDK初期化はtools.ps1に依存 |
| リトライ対象エラー | ネットワーク関連エラー（SDK初期化時） |

### 障害時対応

1. tools.ps1の存在とパスを確認
2. global.jsonの内容を確認
3. ネットワーク接続を確認（SDK未インストール時）
4. dotnet-install.ps1を直接実行してSDKをインストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1コマンド |
| 目標処理時間 | SDK初期化済みの場合は即座、未初期化の場合は1-5分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は許可される。SDK初期化処理はtools.ps1の実装に依存。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | スクリプト自体はログを出力しない |
| 進捗ログ | SDK初期化時 | tools.ps1からの出力 |
| 終了ログ | なし | スクリプト自体はログを出力しない |
| エラーログ | SDK初期化失敗時 | tools.ps1からのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 用途依存 | 呼び出し元 |
| エラー件数 | 用途依存 | 呼び出し元 |

## 備考

- 本スクリプトは非常にシンプルなラッパーで、主な処理はtools.ps1に委譲している
- 引数なしで呼び出すとSDK初期化のみ行い、dotnetコマンドは実行しない
- DOTNET_NOLOGO=1を設定することで、dotnet実行時のバナー出力を抑制している
- &演算子でdotnet.exeを呼び出すため、パス内のスペースにも対応
- Linux/macOS版（dotnet.sh）と同等の機能をWindows環境で提供
