# バッチ設計書 15-RunnerTemplate.sh

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるテスト実行テンプレートスクリプト（Linux/macOS向け）`eng/testing/RunnerTemplate.sh`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Helix分散テスト環境でのテスト実行を管理するテンプレートスクリプトである。テストの実行、コアダンプの収集・処理、XUnitLogCheckerによるダンプ解析、および適切な終了コードの管理を行う。テンプレートとして設計されており、ビルド時にプレースホルダー（[[RunCommands]]等）が実際のコマンドに置換される。

**業務上の目的・背景**：.NET runtimeの品質保証には大規模なテストスイートの実行が必要であり、Helixインフラを使用した分散テスト実行が採用されている。本スクリプトはテスト実行の標準化、クラッシュダンプの自動収集、テスト結果の適切な報告を担い、CI/CDパイプラインでの信頼性の高いテスト実行を実現する。

**バッチの実行タイミング**：CI/CDパイプラインでのテストフェーズ、Helixワークアイテムとして各テストマシンで実行される。PRビルドやオフィシャルビルドのテストステップで使用。

**主要な処理内容**：
1. コマンドライン引数の解析（runtime-path、rsp-file）
2. コアダンプ設定の初期化（OS別の対応）
3. SuperPMIコレクション設定（オプション）
4. カスタム設定コマンドの実行（[[SetCommands]]）
5. テストコマンドの実行（[[RunCommands]]）
6. コアダンプファイルの収集と移動
7. XUnitLogCheckerによるダンプ解析
8. 終了コードの適切な管理

**前後の処理との関連**：Helixインフラによりテストマシンにペイロードとして配布され実行される。テスト結果はtestResults.xmlとして出力され、Helixによって収集される。

**影響範囲**：テスト実行ディレクトリ、HELIX_DUMP_FOLDER、コアダンプファイル。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガー時 |
| 実行時刻 | 随時（CI/CDパイプライン依存） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Helixワークアイテム |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| bash環境 | bash 3.x以上が利用可能であること |
| runtime-path | テスト実行に必要なランタイムパスが指定されていること |
| Helix環境 | HELIX_DUMP_FOLDER、HELIX_CORRELATION_PAYLOAD等の環境変数 |

### 実行可否判定

- --runtime-path/-rパラメータが必須
- 実行ディレクトリが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --runtime-path / -r | string | Yes | なし | テストランタイムを含むtesthostのパス |
| --rsp-file | string | No | なし | 追加引数を含むRSPファイルのパス |
| --help / -h | flag | No | なし | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストアセンブリ | DLL | 実行対象のテストアセンブリ |
| RSPファイル | テキスト | 追加のテスト引数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| testResults.xml | XML | テスト結果ファイル |
| HELIX_DUMP_FOLDER | ディレクトリ | コアダンプファイル保存先 |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | testResults.xml、*.dmp |
| 出力先 | 実行ディレクトリ、HELIX_DUMP_FOLDER |
| 文字コード | UTF-8（XML）、バイナリ（dmp） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ runtime-path（必須）、rsp-file（オプション）の取得
2. 終了コード定義
   └─ SIGINT、SIGQUIT、SIGILL等のシグナル番号と意味の定義
3. コアダンプ設定（Darwin/Linux）
   └─ ulimit設定、DOTNET_DbgEnableMiniDump環境変数設定
4. SuperPMI設定（オプション）
   └─ JITコレクション用の環境変数設定
5. カスタム設定実行
   └─ [[SetCommands]]プレースホルダーの展開・実行
6. テスト実行
   └─ [[RunCommands]]プレースホルダーの展開・実行
7. コアダンプ収集
   └─ Linux: core.*ファイルの検索と移動
8. XUnitLogChecker実行
   └─ ダンプファイルの解析
9. 終了コード判定
   └─ テスト結果に基づく適切な終了コード返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{runtime-path指定?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[コアダンプ設定]
    E --> F[SuperPMI設定]
    F --> G[SetCommands実行]
    G --> H[テスト実行]
    H --> I[終了コード取得]
    I --> J{テスト失敗?}
    J -->|Yes| K[コアダンプ収集]
    J -->|No| L[XUnitLogChecker]
    K --> L
    L --> M{結果判定}
    M -->|成功+結果あり| N[終了コード0]
    M -->|失敗| O[エラー終了コード]
    N --> P[終了]
    O --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -1 | 引数エラー | 必須引数未指定、不正な引数 | 正しい引数を指定して再実行 |
| 130 | SIGINT | Ctrl-C、タイムアウト | テストタイムアウト設定を確認 |
| 131 | SIGQUIT | Ctrl-\、コアダンプ | コアダンプを解析 |
| 132 | SIGILL | 不正命令 | コード生成問題を調査 |
| 134 | SIGABRT | abort()呼び出し | アサート失敗、ヒープ破損を調査 |
| 137 | SIGKILL | OOM、明示的kill | リソース不足を調査 |
| 139 | SIGSEGV | 不正メモリアクセス | スタックオーバーフロー、ポインタエラーを調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプトレベルではなし（Helix側で管理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. コアダンプファイルをHELIX_DUMP_FOLDERから取得
2. XUnitLogCheckerの出力を確認
3. dmesgログを確認（カーネルレベルのエラー）
4. テスト固有のログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークアイテムあたり1テストセット |
| 目標処理時間 | テストセット依存（Helixタイムアウト設定に従う） |
| メモリ使用量上限 | テスト依存 |

## 排他制御

同一マシン上での同時実行は許可されるが、各ワークアイテムは独立したディレクトリで実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト開始時 | 日時、再現コマンド |
| 進捗ログ | 処理中 | SetCommands、RunCommandsのエコー |
| 終了ログ | テスト終了時 | 日時、終了コード |
| エラーログ | エラー発生時 | シグナル説明、ulimit値、/proc情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | Helix設定依存 | Helixインフラ |
| エラー件数 | テスト失敗 | CI/CDパイプライン |

## 備考

- 本スクリプトはテンプレートであり、[[SetCommands]]、[[SetCommandsEcho]]、[[RunCommands]]、[[RunCommandsEcho]]プレースホルダーがビルド時に実際のコマンドに置換される
- macOSでは/coresディレクトリへのコアダンプ出力が無効化されている（CI環境保護のため）
- DOTNET_DbgEnableMiniDump=1、DOTNET_EnableCrashReport=1環境変数でミニダンプ生成を有効化
- XUnitLogCheckerは__IsXUnitLogCheckerSupported環境変数で有効/無効を制御
- Helixワークアイテムではテスト失敗（exit code 1）でもtestResults.xmlがあれば終了コード0を返す
