# バッチ設計書 16-RunnerTemplate.cmd

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるテスト実行テンプレートスクリプト（Windows向け）`eng/testing/RunnerTemplate.cmd`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Windows環境でのHelix分散テスト環境でのテスト実行を管理するテンプレートスクリプトである。Linux/macOS向けの`RunnerTemplate.sh`のWindows版として、テストの実行、SuperPMIコレクション、XUnitLogCheckerによるダンプ解析、および適切な終了コードの管理を行う。

**業務上の目的・背景**：Windows環境での.NET runtimeテストにおいて、Helixインフラを使用した分散テスト実行が必要である。本スクリプトはテスト実行の標準化、クラッシュダンプの解析、テスト結果の適切な報告を担い、Windows CI/CDパイプラインでの信頼性の高いテスト実行を実現する。

**バッチの実行タイミング**：CI/CDパイプラインでのテストフェーズ、Helixワークアイテムとして各Windowsテストマシンで実行される。PRビルドやオフィシャルビルドのテストステップで使用。

**主要な処理内容**：
1. コマンドライン引数の解析（runtime-path、rsp-file）
2. SuperPMIコレクション設定（オプション）
3. カスタム設定コマンドの実行（[[SetCommands]]）
4. テストコマンドの実行（[[RunCommands]]）
5. XUnitLogCheckerによるダンプ解析
6. 終了コードの適切な管理

**前後の処理との関連**：Helixインフラによりテストマシンにペイロードとして配布され実行される。テスト結果はtestResults.xmlとして出力され、Helixによって収集される。

**影響範囲**：テスト実行ディレクトリ、HELIX_DUMP_FOLDER。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガー時 |
| 実行時刻 | 随時（CI/CDパイプライン依存） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Helixワークアイテム |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境であること |
| runtime-path | テスト実行に必要なランタイムパスが指定されていること |
| Helix環境 | HELIX_DUMP_FOLDER、HELIX_CORRELATION_PAYLOAD等の環境変数 |

### 実行可否判定

- --runtime-path/-rパラメータが指定されていること
- 実行ディレクトリが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --runtime-path / -r | string | Yes | なし | テストランタイムを含むtesthostのパス |
| --rsp-file | string | No | なし | 追加引数を含むRSPファイルのパス（@プレフィックス付きで使用） |
| --help / -h | flag | No | なし | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストアセンブリ | DLL | 実行対象のテストアセンブリ |
| RSPファイル | テキスト | 追加のテスト引数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| testResults.xml | XML | テスト結果ファイル |
| HELIX_DUMP_FOLDER | ディレクトリ | ダンプファイル保存先 |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | testResults.xml、*.dmp |
| 出力先 | 実行ディレクトリ、HELIX_DUMP_FOLDER |
| 文字コード | UTF-8（XML）、バイナリ（dmp） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ ENABLEEXTENSIONS、ENABLEDELAYEDEXPANSION有効化
2. 引数解析ループ
   └─ runtime-path、rsp-file、helpの取得
3. SuperPMI設定（オプション）
   └─ 環境変数設定、ディレクトリ作成
4. カスタム設定実行
   └─ [[SetCommands]]プレースホルダーの展開・実行
5. テスト実行
   └─ [[RunCommands]]プレースホルダーの展開・実行
6. 終了コード取得
   └─ %ERRORLEVEL%の保存
7. testResults.xml確認
   └─ 存在する場合HAS_TEST_RESULTS=1
8. 終了コード判定（Helix環境）
   └─ テスト失敗(1)+結果ありの場合は終了コード0
9. XUnitLogChecker実行
   └─ ダンプファイルの解析
10. 終了
    └─ 適切な終了コードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ENABLEEXTENSIONS有効化]
    B --> C[引数解析ループ]
    C --> D{引数エラー?}
    D -->|Yes| E[usage表示して終了]
    D -->|No| F[SuperPMI設定]
    F --> G[SetCommands実行]
    G --> H[テスト実行]
    H --> I[終了コード保存]
    I --> J{testResults.xml存在?}
    J -->|Yes| K[HAS_TEST_RESULTS=1]
    J -->|No| L[HAS_TEST_RESULTS=0]
    K --> M{終了コード判定}
    L --> M
    M -->|1+結果あり+Helix| N[終了コード0で終了]
    M -->|その他| O[XUnitLogChecker実行]
    O --> P[終了コードで終了]
    N --> Q[終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -1 | 引数エラー | 必須引数未指定、不正な引数 | 正しい引数を指定して再実行 |
| 1 | テスト失敗 | テストアサーション失敗等 | テスト結果を確認 |
| 非0 | XUnitLogCheckerエラー | ダンプ解析エラー | ダンプファイルを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプトレベルではなし（Helix側で管理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ダンプファイルをHELIX_DUMP_FOLDERから取得
2. XUnitLogCheckerの出力を確認
3. テスト固有のログを確認
4. イベントログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークアイテムあたり1テストセット |
| 目標処理時間 | テストセット依存（Helixタイムアウト設定に従う） |
| メモリ使用量上限 | テスト依存 |

## 排他制御

同一マシン上での同時実行は許可されるが、各ワークアイテムは独立したディレクトリで実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト開始時 | 日時、再現コマンド |
| 進捗ログ | 処理中 | SetCommands、RunCommandsのエコー |
| 終了ログ | テスト終了時 | 日時、終了コード |
| エラーログ | エラー発生時 | XUnitLogChecker出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | Helix設定依存 | Helixインフラ |
| エラー件数 | テスト失敗 | CI/CDパイプライン |

## 備考

- 本スクリプトはテンプレートであり、[[SetCommands]]、[[SetCommandsEcho]]、[[RunCommands]]、[[RunCommandsEcho]]プレースホルダーがビルド時に実際のコマンドに置換される
- ENABLEDELAYEDEXPANSION有効化により!variable!形式の遅延展開が可能
- SuperPMI設定では、clrjit.dll、superpmi-shim-collector.dllのパスを設定
- XUnitLogCheckerはHELIX_CORRELATION_PAYLOAD内のXUnitLogChecker.exeを使用
- RUNTIME_PATH\dotnet.exeは参照されるが、現在のコードでは直接使用されていない
- Linux/macOS版（RunnerTemplate.sh）と比較して、コアダンプ収集ロジックは含まれていない（Windowsではミニダンプは別途管理）
