# バッチ設計書 18-AndroidRunnerTemplate.cmd

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるAndroidテスト実行テンプレートスクリプト（Windows向け）`eng/testing/AndroidRunnerTemplate.cmd`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Windows環境でのAndroidテスト実行を管理するスクリプトである。Linux/macOS向けの`AndroidRunnerTemplate.sh`のWindows版として、XHarnessツールを使用してAndroidデバイスまたはエミュレータ上でテストを実行し、結果を収集する。

**業務上の目的・背景**：Windows開発環境において、.NET MAUI、Xamarin、およびMonoベースのAndroidアプリケーションのテストを実行する必要がある。本スクリプトはXHarness CLIを活用してWindows環境からのAndroidテスト実行を標準化し、開発者がVisual Studio等のWindows開発環境でAndroidテストを実行できる環境を提供する。

**バッチの実行タイミング**：開発者がローカルでAndroidテストを実行する際に使用。CI環境からも呼び出される可能性がある。

**主要な処理内容**：
1. コマンドライン引数の解析（アセンブリ名、アーキテクチャ、OS、テスト名、リポジトリルート）
2. 排他制御用のロックディレクトリ取得
3. XHarness CLIの実行パス決定（XHARNESS_CLI_PATH経由またはdotnet xharness）
4. XHarness androidテストコマンドの実行
5. ロック解放と終了コードの返却

**前後の処理との関連**：テストビルド後にAPKファイルが生成されている必要がある。テスト結果はxharness-outputディレクトリに出力される。

**影響範囲**：Androidデバイス/エミュレータ、xharness-output出力ディレクトリ。

## バッチ種別

テスト実行（モバイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動/スクリプト呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境であること |
| XHarness | dotnet xharnessコマンドまたはXHARNESS_CLI_PATHが利用可能 |
| Android SDK | ADB等のAndroidツールが利用可能であること |
| APKファイル | テスト対象のAPKがbin\ディレクトリに存在すること |
| Androidデバイス/エミュレータ | 接続済みのデバイスまたは起動済みのエミュレータ |

### 実行可否判定

- ASSEMBLY_NAME、TARGET_ARCH、TARGET_OS、TEST_NAME、REPO_ROOTパラメータが指定されていること
- APKファイルが存在すること
- Androidデバイス/エミュレータが接続されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 (ASSEMBLY_NAME) | string | Yes | なし | テストアセンブリ名（パッケージ名のサフィックス） |
| %2 (TARGET_ARCH) | string | Yes | なし | ターゲットアーキテクチャ（arm64, x64等） |
| %3 (TARGET_OS) | string | Yes | なし | ターゲットOS（android） |
| %4 (TEST_NAME) | string | Yes | なし | テスト名（APKファイル名のベース） |
| %5 (REPO_ROOT) | string | Yes | なし | リポジトリルートパス |
| %6+ (__AdditionalArgs) | string | No | なし | XHarnessへの追加引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APKファイル | Android Package | テスト対象のAndroidアプリケーション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| xharness-output | ディレクトリ | XHarness出力ディレクトリ |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成するテスト結果ファイル |
| 出力先 | %EXECUTION_DIR%xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ ECHO OFF、enabledelayedexpansion有効化
2. 変数初期化
   └─ EXECUTION_DIR、引数の取得
3. 追加引数ループ
   └─ %6以降の引数を__AdditionalArgsに追加
4. 実行ディレクトリへ移動
   └─ cd %EXECUTION_DIR%
5. ロック取得ループ
   └─ androidtests.lockディレクトリの作成待ち（失敗時6秒待機）
6. XHarnessランナー決定
   └─ XHARNESS_CLI_PATH設定時はdotnet.cmd exec、未設定時はdotnet.cmd xharness
7. XHarness androidテスト実行
   └─ android test --instrumentation --package-name --app --output-directory --timeout
8. 終了コード保存
   └─ EXIT_CODEに%ERRORLEVEL%を保存
9. 出力パス表示
   └─ XHarness artifactsパスを出力
10. ロック解放・終了
    └─ androidtests.lockディレクトリ削除、終了コードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ECHO OFF、変数初期化]
    B --> C[引数取得ループ]
    C --> D[実行ディレクトリへ移動]
    D --> E{ロック取得可能?}
    E -->|No| F[6秒待機]
    F --> E
    E -->|Yes| G{XHARNESS_CLI_PATH設定?}
    G -->|Yes| H[dotnet.cmd exec XHARNESS_CLI_PATH]
    G -->|No| I[dotnet.cmd xharness]
    H --> J[android test実行]
    I --> J
    J --> K[EXIT_CODE保存]
    K --> L[XHarness artifacts表示]
    L --> M[ロックディレクトリ削除]
    M --> N[EXIT /B EXIT_CODE]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | XHarnessエラー | テスト失敗、デバイス接続エラー等 | XHarness出力を確認 |
| 非0 | APK不存在 | 指定されたAPKファイルが存在しない | APKビルドを確認 |
| 非0 | デバイス未接続 | Androidデバイス/エミュレータが接続されていない | adb devicesで確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプトレベルではなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. XHarness出力ディレクトリを確認
2. adb devicesでデバイス接続状態を確認
3. APKファイルの存在を確認
4. Androidエミュレータのログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1テストセット |
| 目標処理時間 | 1800秒（XHarnessタイムアウト） |
| メモリ使用量上限 | デバイス/エミュレータ依存 |

## 排他制御

androidtests.lockディレクトリによるセマフォ方式の排他制御を実装。並列テスト実行は現在サポートされていないため、ロック取得失敗時はping -n 6（約6秒）で待機してリトライする。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | スクリプト自体は開始ログを出力しない |
| 進捗ログ | なし | XHarnessからの出力に依存 |
| 終了ログ | 実行完了時 | XHarness artifactsパス |
| エラーログ | エラー発生時 | XHarnessからのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1800秒 | コンソール出力 |
| エラー件数 | 1件 | コンソール出力 |

## 備考

- Linux/macOS版（AndroidRunnerTemplate.sh）のWindows版
- XHarnessタイムアウトは1800秒（30分）に設定
- instrumentation引数は"net.dot.MonoRunner"固定
- package-name引数は"net.dot.%ASSEMBLY_NAME%"形式
- XHARNESS_CLI_PATH環境変数でXHarness CLIのパスをオーバーライド可能
- REPO_ROOT引数でdotnet.cmdへのパスを指定（%REPO_ROOT%dotnet.cmd）
- ロック解放はRMDIR /Q androidtests.lockで実行（2>NULでエラー抑制）
- NORMALIZEPATH関数が定義されているが、現在のコードでは未使用
- enabledelayedexpansionにより!variable!形式の遅延展開が可能
