# バッチ設計書 19-AppleRunnerTemplate.sh

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるApple（iOS/tvOS/macOS）テスト実行テンプレートスクリプト`eng/testing/AppleRunnerTemplate.sh`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Apple環境（iOS、tvOS、Mac Catalyst）向けのテスト実行を管理するスクリプトである。XHarnessツールを使用してiOSシミュレータ/実機、tvOSシミュレータ/実機、Mac Catalyst上でテストを実行し、結果を収集する。ローカル開発環境での使用を主目的としており、CI環境ではHelix SDKが代替として使用される。

**業務上の目的・背景**：.NET MAUI、XamarinおよびMonoベースのiOS/tvOS/Mac Catalystアプリケーション開発において、Appleプラットフォーム上でのテスト実行が必要である。本スクリプトはXHarness CLIを活用してAppleテストの実行を標準化し、開発者がローカル環境で簡単にAppleプラットフォームテストを実行できる環境を提供する。

**バッチの実行タイミング**：開発者がローカルでAppleテストを実行する際に使用。CI環境ではHelix SDKが使用されるため、主にローカル開発・デバッグ用途。

**主要な処理内容**：
1. コマンドライン引数の解析（アセンブリ名、アーキテクチャ、OS、テスト名、構成）
2. ターゲットプラットフォームの決定（iOSシミュレータ、実機、tvOS、Mac Catalyst）
3. スキーム・SDK設定の決定
4. 排他制御用のロックディレクトリ取得
5. XHarness CLIの実行パス決定
6. XHarness appleテスト/実行コマンドの実行
7. 終了コードの返却

**前後の処理との関連**：テストビルド後に.appバンドルが生成されている必要がある。テスト結果はxharness-outputディレクトリに出力される。

**影響範囲**：iOSシミュレータ/実機、tvOSシミュレータ/実機、Mac Catalyst、xharness-output出力ディレクトリ。

## バッチ種別

テスト実行（モバイル・デスクトップ）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS環境 | macOSが必要（Xcodeツールチェーン） |
| Xcode | Xcodeがインストールされていること（xcode-selectで検出） |
| XHarness | dotnet xharnessコマンドまたはXHARNESS_CLI_PATHが利用可能 |
| .appバンドル | テスト対象の.appが適切なディレクトリに存在すること |
| シミュレータ/実機 | ターゲットに応じたシミュレータまたは接続された実機 |

### 実行可否判定

- ASSEMBLY_NAME、TARGET_ARCH、TARGET_OS、TEST_NAME、CONFIGURATIONパラメータが指定されていること
- .appバンドルが存在すること
- ターゲットシミュレータ/実機が利用可能であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (ASSEMBLY_NAME) | string | Yes | なし | テストアセンブリ名 |
| $2 (TARGET_ARCH) | string | Yes | なし | ターゲットアーキテクチャ（x86, x64, arm, arm64） |
| $3 (TARGET_OS) | string | Yes | なし | ターゲットOS（iossimulator, ios, tvossimulator, tvos, maccatalyst） |
| $4 (TEST_NAME) | string | Yes | なし | テスト名（.appディレクトリ名のベース） |
| $5 (CONFIGURATION) | string | Yes | なし | ビルド構成（Debug, Release） |
| $6+ (ADDITIONAL_ARGS) | string | No | なし | XHarnessへの追加引数（指定時はrunモード） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .appバンドル | ディレクトリ | テスト対象のAppleアプリケーション |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| xharness-output | ディレクトリ | XHarness出力ディレクトリ |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成するテスト結果ファイル |
| 出力先 | $EXECUTION_DIR/xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 変数初期化
   └─ EXECUTION_DIR、引数の取得、デフォルトモード（test）設定
2. 追加引数チェック
   └─ $6が存在する場合はrunモードに切替
3. 構成の正規化
   └─ Debug以外はReleaseに設定
4. ターゲット判定
   └─ TARGET_OSとTARGET_ARCHからXHarnessターゲットを決定
5. SCHEME_SDK設定
   └─ ターゲットに応じたXcode SDK名を設定
6. SIGNAL_APP_END設定
   └─ 実機ターゲットの場合に--signal-app-end追加
7. 実行ディレクトリへ移動
   └─ cd $EXECUTION_DIR
8. ロック取得
   └─ /tmp/appletests.lockディレクトリの作成待ち
9. XHarnessランナー決定
   └─ XHARNESS_CLI_PATH設定時はdotnet exec、未設定時はdotnet xharness
10. XHarness appleコマンド実行
    └─ apple test/run --app --targets --xcode --output-directory
11. 終了コード取得
    └─ $_exitCodeに保存
12. 出力パス表示・終了
    └─ XHarness artifactsパスを出力、終了コードで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C{$6存在?}
    C -->|Yes| D[runモード設定]
    C -->|No| E[testモード維持]
    D --> F[構成正規化]
    E --> F
    F --> G[ターゲット判定]
    G --> H[SCHEME_SDK設定]
    H --> I{実機ターゲット?}
    I -->|Yes| J[SIGNAL_APP_END設定]
    I -->|No| K[ロック取得]
    J --> K
    K --> L{ロック取得可能?}
    L -->|No| M[5秒待機]
    M --> L
    L -->|Yes| N{XHARNESS_CLI_PATH設定?}
    N -->|Yes| O[dotnet exec]
    N -->|No| P[dotnet xharness]
    O --> Q[apple test/run実行]
    P --> Q
    Q --> R[終了コード取得]
    R --> S[artifacts表示]
    S --> T[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | XHarnessエラー | テスト失敗、シミュレータエラー等 | XHarness出力を確認 |
| 非0 | .app不存在 | 指定された.appバンドルが存在しない | ビルドを確認 |
| 非0 | シミュレータエラー | シミュレータの起動失敗等 | Xcodeでシミュレータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプトレベルではなし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. XHarness出力ディレクトリを確認
2. xcrun simctl listでシミュレータ状態を確認
3. .appバンドルの存在を確認
4. Xcodeコンソールでエラーを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行で1テストセット |
| 目標処理時間 | テスト依存（XHarnessのデフォルトタイムアウトに従う） |
| メモリ使用量上限 | シミュレータ/デバイス依存 |

## 排他制御

/tmp/appletests.lockディレクトリによるセマフォ方式の排他制御を実装。並列テスト実行は現在サポートされていないため、ロック取得まで5秒間隔でリトライする。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | スクリプト自体は開始ログを出力しない |
| 進捗ログ | なし | XHarnessからの出力に依存 |
| 終了ログ | 実行完了時 | XHarness artifactsパス |
| エラーログ | エラー発生時 | XHarnessからのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | XHarness設定依存 | コンソール出力 |
| エラー件数 | 1件 | コンソール出力 |

## 備考

- 本スクリプトはローカル開発用であり、CI環境ではHelix SDKが使用される（コメントに記載）
- サポートするターゲット：
  - iossimulator + x86 → ios-simulator-32
  - iossimulator + x64/arm64 → ios-simulator-64
  - ios + arm/arm64 → ios-device
  - tvossimulator + x64/arm64 → tvos-simulator
  - tvos + arm64 → tvos-device
  - maccatalyst → maccatalyst
- XCODE_PATHはxcode-select -pから取得（/../..で.appディレクトリを指す）
- 実機ターゲット（ios-device、tvos-device）では--signal-app-endオプションが追加される
- SCHEME_SDKはビルド構成とXcode SDKの組み合わせ（例：Release-iphonesimulator）
- XHARNESS_CLI_PATH環境変数でXHarness CLIのパスをオーバーライド可能
- $6以降の引数が存在する場合、testコマンドではなくrunコマンドが使用される
