# バッチ設計書 2-build.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトのルートディレクトリに配置されたWindows向けプロジェクトビルドスクリプト `build.cmd` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Windows環境で.NET Runtimeプロジェクトをビルドするためのエントリーポイントスクリプトである。PowerShellを介して `eng/build.ps1` を実行し、プロジェクト全体のビルドを行う。

**業務上の目的・背景**：Windows開発者がコマンドプロンプトから直感的にビルドを実行できるようにするためのラッパースクリプトである。.NETの主要な開発環境であるWindowsにおいて、開発者体験を向上させる重要な役割を担う。Windowsバッチファイル形式により、PowerShellの明示的な起動なしにビルドを開始できる。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプライン（Azure DevOps、GitHub Actions等）からの自動実行。Windowsビルドエージェントでの実行が想定される。

**主要な処理内容**：
1. コマンドライン引数の受け取りと前処理
2. ヘルプオプション（-? または /?）の変換
3. PowerShellの起動と eng/build.ps1 の実行
4. 終了コードの伝播

**前後の処理との関連**：このスクリプトは `eng/build.ps1` を呼び出す。`eng/build.ps1` はさらに `eng/common/build.ps1` を呼び出してMSBuildによるビルドを実行する。Unix系環境の `build.sh` と対になるスクリプトである。

**影響範囲**：プロジェクト全体のビルドプロセス、成果物の生成、テスト実行に影響する。ビルド成果物は `artifacts/` ディレクトリ配下に出力される。

## バッチ種別

ビルド実行 / PowerShellラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境での実行が必要 |
| PowerShell | PowerShellが利用可能であること |
| プロジェクト構成 | eng/build.ps1 が存在すること |

### 実行可否判定

スクリプトは常に実行可能。PowerShellが利用できない環境ではエラーとなる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | 任意のコマンドライン引数（eng/build.ps1 にそのまま渡される） |
| -? | flag | No | なし | ヘルプ表示（-help に変換される） |
| /? | flag | No | なし | ヘルプ表示（-help に変換される） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| %~dp0 | バッチ変数 | スクリプトのディレクトリパス |
| %* | バッチ変数 | 全コマンドライン引数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力/標準エラー | テキスト | eng/build.ps1 の出力がそのまま出力される |

### 出力ファイル仕様

このスクリプト自体はファイル出力を行わない。委譲先のビルドスクリプトがビルド成果物を出力する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 委譲先スクリプトに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. エコー出力の抑制
   └─ @echo off でコマンドエコーを無効化
2. ローカル環境の設定
   └─ setlocal で環境変数の変更をローカルスコープに限定
3. コマンドライン引数の取得
   └─ %* を _args 変数に格納
4. ヘルプオプションの変換
   └─ -? または /? を -help に変換
5. PowerShell の実行
   └─ ExecutionPolicy ByPass, NoProfile オプションで eng/build.ps1 を実行
6. 終了コードの伝播
   └─ ERRORLEVEL を戻り値として返す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off / setlocal]
    B --> C[引数を _args に格納]
    C --> D{-? または /?}
    D -->|Yes| E[_args を -help に変更]
    D -->|No| F[_args をそのまま使用]
    E --> G[PowerShell で eng/build.ps1 を実行]
    F --> G
    G --> H[ERRORLEVEL を返却]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | 委譲先エラー | eng/build.ps1 がエラー終了 | 委譲先スクリプトのエラーメッセージを確認 |
| 1 | PowerShellエラー | PowerShellの起動に失敗 | PowerShellのインストール状態を確認 |
| 1 | ファイル不在 | eng/build.ps1 が存在しない | プロジェクト構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、PowerShellスクリプトの問題を特定
2. PowerShellの実行ポリシーを確認（ByPassが使用されているため通常は問題にならない）
3. プロジェクトの依存関係やSDKのインストール状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の実行 |
| 目標処理時間 | スクリプト自体は1秒未満（ビルド全体は構成による） |
| メモリ使用量上限 | 最小限（数MB） |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。複数の同時ビルドは委譲先のビルドシステムやCI/CDシステムで管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | eng/build.ps1 の出力 |
| 標準エラー | エラー発生時 | eng/build.ps1 のエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| 実行時間 | 構成による | CI/CDシステム |

## 備考

- `-ExecutionPolicy ByPass` オプションにより、システムの実行ポリシー設定に関わらずスクリプトが実行される
- `-NoProfile` オプションにより、PowerShellプロファイルの読み込みをスキップしてパフォーマンスを向上
- ヘルプオプションの `-?` と `/?` を `-help` に変換することで、Windowsユーザーの慣習に対応
- `setlocal` により環境変数の変更がバッチファイル内に限定される
