# バッチ設計書 20-AppleHelixRunnerTemplate.sh

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるHelix環境でのAppleテスト実行テンプレートスクリプト`eng/testing/AppleHelixRunnerTemplate.sh`の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、Helix分散テストインフラストラクチャ上でApple環境（iOS/tvOS/macOS）向けのテストを実行するためのテンプレートスクリプトである。ローカル開発用のAppleRunnerTemplate.shとは異なり、CI/CD環境でのHelix SDKと連携した自動化テスト実行を想定している。テンプレートとして設計されており、ビルド時にプレースホルダー（[[RunCommands]]）が実際のコマンドに置換される。

**業務上の目的・背景**：.NET runtimeプロジェクトの品質保証において、Apple環境でのテストを大規模に分散実行する必要がある。本スクリプトはHelixインフラを活用してAppleテストの自動実行を標準化し、PRビルドやオフィシャルビルドでのAppleプラットフォームテストを効率的に実行する。tests.mobile.targetsで定義されたコマンドがテンプレートに注入される。

**バッチの実行タイミング**：CI/CDパイプラインでのテストフェーズ、HelixワークアイテムとしてmacOSテストマシンで実行される。PRビルドやオフィシャルビルドのAppleテストステップで使用。

**主要な処理内容**：
1. 実行ディレクトリの決定
2. XHarness出力ディレクトリの設定
3. [[RunCommands]]プレースホルダーで定義されたテストコマンドの実行

**前後の処理との関連**：Helixインフラによりテストマシンにペイロードとして配布され実行される。tests.mobile.targetsでRunCommandsが定義され、ビルド時にテンプレートに注入される。テスト結果はXHarness出力ディレクトリに出力される。

**影響範囲**：Appleシミュレータ/実機、xharness-output出力ディレクトリ。

## バッチ種別

テスト実行（CI/CD・モバイル）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガー時 |
| 実行時刻 | 随時（CI/CDパイプライン依存） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Helixワークアイテム |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS環境 | Helix上のmacOSエージェントで実行 |
| Xcode | Xcodeがインストールされていること |
| XHarness | ペイロードにXHarnessが含まれていること |
| .appバンドル | テスト対象の.appがペイロードに含まれていること |

### 実行可否判定

- Helixペイロードが正しく配置されていること
- [[RunCommands]]が適切に置換されていること

## 入力仕様

### 入力パラメータ

本スクリプトは直接のコマンドライン引数を受け取らない。テスト実行に必要なパラメータは[[RunCommands]]プレースホルダーを通じてビルド時に注入される。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| （なし） | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tests.mobile.targets | MSBuild | RunCommands定義元 |
| Helixペイロード | ディレクトリ | テストアセンブリ、.app、XHarness等 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| xharness-output | ディレクトリ | XHarness出力ディレクトリ |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成するテスト結果ファイル |
| 出力先 | $XHARNESS_EXECUTION_DIR/xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 実行ディレクトリ決定
   └─ cd -- "$(dirname "$0")"でスクリプト位置を基準に決定
   └─ pwd -Pで絶対パスを取得
2. XHarness出力ディレクトリ設定
   └─ XHARNESS_OUT="$XHARNESS_EXECUTION_DIR/xharness-output"
3. RunCommands実行
   └─ [[RunCommands]]プレースホルダーがビルド時にXHarnessコマンドに置換
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[実行ディレクトリ決定]
    B --> C[XHARNESS_EXECUTION_DIR設定]
    C --> D[XHARNESS_OUT設定]
    D --> E[RunCommands実行]
    E --> F[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本バッチはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | XHarnessエラー | テスト失敗、シミュレータエラー等 | XHarness出力を確認 |
| 非0 | コマンド未定義 | [[RunCommands]]が空または未置換 | ビルドログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スクリプトレベルではなし（Helix側で管理） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. Helixワークアイテムのログを確認
2. XHarness出力ディレクトリを確認
3. [[RunCommands]]の置換内容を確認
4. tests.mobile.targetsの定義を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークアイテムあたり1テストセット |
| 目標処理時間 | テストセット依存（Helixタイムアウト設定に従う） |
| メモリ使用量上限 | シミュレータ/デバイス依存 |

## 排他制御

本スクリプト自体には排他制御は実装されていない。[[RunCommands]]で注入されるXHarnessコマンドに排他制御が含まれる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | スクリプト自体は開始ログを出力しない |
| 進捗ログ | RunCommands実行中 | XHarnessからの出力に依存 |
| 終了ログ | なし | スクリプト自体は終了ログを出力しない |
| エラーログ | エラー発生時 | XHarnessからのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | Helix設定依存 | Helixインフラ |
| エラー件数 | テスト失敗 | CI/CDパイプライン |

## 備考

- 本スクリプトは非常にシンプルなテンプレートであり、主要なロジックは[[RunCommands]]プレースホルダーに注入される
- [[RunCommands]]はtests.mobile.targetsで定義され、MSBuildによりビルド時に実際のXHarnessコマンドに置換される
- ローカル開発用のAppleRunnerTemplate.shと比較して、排他制御（ロック取得）やXHarnessパス決定ロジックは含まれていない（Helix環境では不要なため）
- XHARNESS_EXECUTION_DIRは"$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"で決定される
  - cd -- により特殊文字を含むディレクトリ名にも対応
  - >/dev/null 2>&1 でcdの出力を抑制
  - pwd -P でシンボリックリンクを解決した絶対パスを取得
- Helix環境変数（HELIX_WORKITEM_PAYLOAD等）への依存は[[RunCommands]]内で処理される
