# バッチ設計書 21-WasmRunnerTemplate.sh

## 概要

本ドキュメントは、WebAssembly（Wasm）環境向けテスト実行テンプレートスクリプト `eng/testing/WasmRunnerTemplate.sh` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムのWebAssembly対応テストをLinux/macOS環境で実行するためのテンプレートスクリプトである。XHarnessテストフレームワークを使用して、V8エンジンやブラウザ（Chrome/Firefox）上でWasmテストを実行し、結果を収集する。

**業務上の目的・背景**：.NETランタイムはWebAssembly（Wasm）プラットフォームをサポートしており、ブラウザやNode.js環境で.NETコードを実行できる。本バッチは、このWasm対応機能の品質保証のため、CIパイプラインやHelix分散テスト環境でWasmテストを自動実行する基盤を提供する。Blazor WebAssemblyなどのフレームワークの信頼性確保に不可欠である。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド後テスト実行時、Helixテストキューからのテストジョブ実行時、開発者によるローカルテスト実行時に随時実行される。

**主要な処理内容**：
1. 実行環境の初期化（PATH設定、XHarness CLI検出）
2. テストシナリオの判定（V8テスト/Chrome/Firefoxブラウザテスト）
3. JavaScriptエンジンおよびブラウザ引数の設定
4. AOTビルド機能の提供（_buildAOTFunc関数）
5. XHarnessを使用したテスト実行
6. テスト結果とアーティファクトの出力

**前後の処理との関連**：ビルドスクリプト（build.sh等）によるWasmビルド完了後に実行される。tests.wasm.targetsで定義されたSetCommands/RunCommandsがテンプレートプレースホルダーとして埋め込まれる。

**影響範囲**：WebAssemblyテスト結果、XHarnessアーティファクト出力、CIパイプラインのテスト判定結果に影響する。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/Helixテストキュー/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnetコマンドが利用可能であること |
| XHarness | XHarness CLIがインストールされているか、XHARNESS_CLI_PATHが設定されていること |
| JavaScript環境 | V8エンジンまたはブラウザ（Chrome/Firefox）が利用可能であること |
| jsvu | ブラウザ以外のテストではjsvuによるJSエンジン管理が設定されていること |
| テストアセンブリ | ビルド済みのWasmテストアセンブリが存在すること |

### 実行可否判定

テストアセンブリと必要なランタイムファイルが存在する場合に実行可能。tests.wasm.targetsによって生成されたSetCommands/RunCommandsが正しく展開されている必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $3 (SCENARIO) | string | No | - | テストシナリオ（WasmTestOnFirefox/WasmTestOnChrome等） |
| XHARNESS_CLI_PATH | env | No | - | XHarness CLIDLLへのパス |
| XHARNESS_COMMAND | env | No | test/test-browser | XHarnessコマンド種別 |
| JS_ENGINE | env | No | --engine=V8 | 使用するJavaScriptエンジン |
| JS_ENGINE_ARGS | env | No | --engine-arg=--stack-trace-limit=1000 | JSエンジン引数 |
| MAIN_JS | env | No | --js-file=test-main.js | メインJSファイル |
| PREPEND_PATH | env | No | - | PATHに追加するディレクトリ |
| XUNIT_RANDOM_ORDER_SEED | env | No | - | XUnitテストのランダム順序シード |
| HELIX_WORKITEM_UPLOAD_ROOT | env | No | - | Helixアーティファクトアップロードルート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| [[SetCommands]] | テンプレート | tests.wasm.targetsで定義された初期化コマンド |
| [[RunCommands]] | テンプレート | tests.wasm.targetsで定義されたテスト実行コマンド |
| TestEnv.txt | テキスト | テスト環境変数定義（存在する場合） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $XHARNESS_OUT | ディレクトリ | XHarnessテスト結果アーティファクト |
| 標準出力 | テキスト | テスト実行ログ |
| 終了コード | 整数 | テスト結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成する各種結果ファイル |
| 出力先 | $EXECUTION_DIR/xharness-output または $HELIX_WORKITEM_UPLOAD_ROOT/xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境変数の初期化
   └─ SetCommandsの実行、PATH設定、実行ディレクトリ特定
2. XHarness実行環境の検出
   └─ XHARNESS_CLI_PATHまたはdotnet xharnessの設定
3. テストシナリオ判定
   └─ SCENARIOに基づきtest/test-browserコマンドを選択
4. JavaScriptエンジン設定
   └─ V8/Chrome/Firefoxに応じた引数設定
5. AOTビルド関数の定義
   └─ _buildAOTFunc関数を定義（必要時に呼び出し可能）
6. テスト実行
   └─ RunCommandsの実行（XHarnessによるテスト実行）
7. 結果出力
   └─ 終了コードとアーティファクトパスを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SetCommands実行]
    B --> C[XHarness CLI検出]
    C --> D{SCENARIO判定}
    D -->|WasmTestOnFirefox| E[Firefox設定]
    D -->|WasmTestOnChrome| F[Chrome設定]
    D -->|その他| G[V8エンジン設定]
    E --> H[XHARNESS_COMMAND=test-browser]
    F --> H
    G --> I[XHARNESS_COMMAND=test]
    H --> J[ブラウザ引数設定]
    I --> K[エンジン引数設定]
    J --> L[RunCommands実行]
    K --> L
    L --> M[終了コード取得]
    M --> N[アーティファクトパス出力]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 9100 | AOTビルド失敗 | AOTコンパイルが失敗した場合 | ビルドログを確認し、コンパイルエラーを修正 |
| 9200 | OOM | Linuxでメモリ不足によりoom-killが発生 | メモリ割り当てを増やすか、並列度を下げる |
| 非0 | テスト失敗 | XHarnessテストが失敗した場合 | テスト結果ログを確認し、失敗テストを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、Helixレベルで制御） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. XHarnessアーティファクト（$XHARNESS_OUT）を確認
2. AOTビルド失敗時はbinlogファイルを分析
3. OOMエラー時はdmesgログを確認
4. 再現手順がechoで出力されるため、それに従ってローカル再現を試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（テスト実行のため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テストケース数に依存 |
| 目標処理時間 | Helixタイムアウト設定に依存（通常30分以内） |
| メモリ使用量上限 | 環境依存（OOM検出機能あり） |

## 排他制御

本バッチ自体は排他制御を行わない。複数インスタンスの同時実行はHelixインフラストラクチャレベルで管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 日時、実行ディレクトリ、再現コマンド |
| 環境ログ | 初期化後 | PATH、SCENARIO、XHARNESS設定値 |
| 終了ログ | バッチ終了時 | 終了コード、XHarnessアーティファクトパス |
| エラーログ | エラー発生時 | dmesgの最終20行（Linux環境でのOOM検出時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |
| OOMエラー | 発生時 | CIパイプライン（終了コード9200） |
| AOTビルドエラー | 発生時 | CIパイプライン（終了コード9100） |

## 備考

- テンプレートプレースホルダー（[[SetCommands]]、[[RunCommands]]等）はビルド時にtests.wasm.targetsによって実際のコマンドに置換される
- jsvu（JavaScript Version Manager）はV8等のJSエンジン管理に使用される
- XHarnessは.NET用のクロスプラットフォームテストハーネス
- ブラウザテストではChrome/Firefoxの特定バージョンがHelix環境にプリインストールされている
