# バッチ設計書 24-WasiRunnerTemplate.cmd

## 概要

本ドキュメントは、WASI（WebAssembly System Interface）環境向けテスト実行テンプレートスクリプト `eng/testing/WasiRunnerTemplate.cmd` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムのWASI対応テストをWindows環境で実行するためのテンプレートスクリプトである。XHarnessテストフレームワークを使用して、WASIランタイム上でテストを実行し、結果を収集する。Linux/macOS版のWasiRunnerTemplate.shと機能的に同等である。

**業務上の目的・背景**：WASIは、WebAssemblyをブラウザ外のサーバーサイドやエッジコンピューティング環境で実行するための標準インターフェースである。Windows環境でもWASIテストの実行が必要であり、本バッチはWindows CI環境やHelix分散テスト環境でWASIテストを自動実行する基盤を提供する。クロスプラットフォームでのWASI機能の一貫性確保に不可欠である。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド後テスト実行時、Helixテストキューからのテストジョブ実行時、開発者によるローカルテスト実行時に随時実行される。

**主要な処理内容**：
1. 実行環境の初期化（PATH設定、XHarness CLI検出）
2. XHarnessコマンドの設定（testコマンド）
3. WASIエンジン引数の設定
4. XHarnessを使用したテスト実行
5. テスト結果とアーティファクトの出力

**前後の処理との関連**：ビルドスクリプトによるWASIビルド完了後に実行される。tests.wasi.targetsで定義されたSetCommands/RunCommandsがテンプレートプレースホルダーとして埋め込まれる。

**影響範囲**：WASIテスト結果、XHarnessアーティファクト出力、CIパイプラインのテスト判定結果に影響する。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/Helixテストキュー/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnet.exeコマンドが利用可能であること |
| XHarness | XHarness CLIがインストールされているか、XHARNESS_CLI_PATHが設定されていること |
| WASIランタイム | WASI互換ランタイム（Wasmtime等）が利用可能であること |
| WASI-SDK | WASIビルドに必要なSDKがインストールされていること |
| テストアセンブリ | ビルド済みのWASIテストアセンブリが存在すること |

### 実行可否判定

テストアセンブリと必要なランタイムファイルが存在する場合に実行可能。tests.wasi.targetsによって生成されたSetCommands/RunCommandsが正しく展開されている必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %3 (SCENARIO) | string | No | - | テストシナリオ |
| XHARNESS_CLI_PATH | env | No | - | XHarness CLIDLLへのパス |
| XHARNESS_COMMAND | env | No | test | XHarnessコマンド種別 |
| ENGINE_ARGS | env | No | - | WASIエンジン引数 |
| XHARNESS_ARGS | env | No | %ENGINE_ARGS% | XHarness追加引数 |
| PREPEND_PATH | env | No | - | PATHに追加するディレクトリ |
| XUNIT_RANDOM_ORDER_SEED | env | No | - | XUnitテストのランダム順序シード |
| HELIX_WORKITEM_UPLOAD_ROOT | env | No | - | Helixアーティファクトアップロードルート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| [[SetCommands]] | テンプレート | tests.wasi.targetsで定義された初期化コマンド |
| [[RunCommands]] | テンプレート | tests.wasi.targetsで定義されたテスト実行コマンド |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %XHARNESS_OUT% | ディレクトリ | XHarnessテスト結果アーティファクト |
| 標準出力 | テキスト | テスト実行ログ |
| ERRORLEVEL | 整数 | テスト結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成する各種結果ファイル |
| 出力先 | %EXECUTION_DIR%xharness-output または %HELIX_WORKITEM_UPLOAD_ROOT%\xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 環境変数の初期化
   └─ SetCommandsの実行、PATH設定、実行ディレクトリ特定
2. XHarness実行環境の検出
   └─ XHARNESS_CLI_PATHまたはdotnet.exe xharnessの設定
3. XHarnessコマンド設定
   └─ testコマンドをデフォルトとして設定
4. WASIエンジン引数設定
   └─ ENGINE_ARGSからXHARNESS_ARGSを設定
5. テスト実行
   └─ RunCommandsの実行（XHarnessによるテスト実行）
6. 結果出力
   └─ 終了コードとアーティファクトパスを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[SetCommands実行]
    B --> C[XHarness CLI検出]
    C --> D[XHARNESS_COMMAND=test設定]
    D --> E[ENGINE_ARGS設定]
    E --> F[RunCommands実行]
    F --> G[終了コード取得]
    G --> H[アーティファクトパス出力]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | テスト失敗 | XHarnessテストが失敗した場合 | テスト結果ログを確認し、失敗テストを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、Helixレベルで制御） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. XHarnessアーティファクト（%XHARNESS_OUT%）を確認
2. 再現手順がechoで出力されるため、それに従ってローカル再現を試行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（テスト実行のため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テストケース数に依存 |
| 目標処理時間 | Helixタイムアウト設定に依存 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

本バッチ自体は排他制御を行わない。複数インスタンスの同時実行はHelixインフラストラクチャレベルで管理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 日時、実行ディレクトリ、再現コマンド |
| 環境ログ | 初期化後 | SCENARIO、XHARNESS設定値 |
| 終了ログ | バッチ終了時 | 終了コード、XHarnessアーティファクトパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |

## 備考

- Linux/macOS版（WasiRunnerTemplate.sh）と機能的に同等だが、Windows固有の差異あり
- Linux版に存在する_buildAOTFunc関数はWindows版には含まれていない
- 遅延展開（setlocal enabledelayedexpansion）を使用して変数の動的評価に対応
- テンプレートプレースホルダー（[[SetCommands]]、[[RunCommands]]等）はビルド時にtests.wasi.targetsによって実際のコマンドに置換される
- XUNIT_RANDOM_ORDER_SEEDは--setenv形式で設定
