# バッチ設計書 26-BionicRunnerTemplate.cmd

## 概要

本ドキュメントは、Android Bionic（Linux ABI）環境向けテスト実行テンプレートスクリプト `eng/testing/BionicRunnerTemplate.cmd` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムのAndroid Bionic libc環境対応テストをWindows環境で実行するためのテンプレートスクリプトである。XHarnessのandroid-headlessコマンドを使用して、Bionic環境（Android NDK使用）でのテストを実行し、結果を収集する。Linux/macOS版のBionicRunnerTemplate.shと機能的に同等である。

**業務上の目的・背景**：Android Bionicは、AndroidのC標準ライブラリ（libc）実装である。Windows環境でもAndroid向けテストの実行が必要であり、本バッチはWindows CI環境やHelix分散テスト環境でBionicテストを自動実行する基盤を提供する。クロスプラットフォームでのBionicテスト実行に不可欠である。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド後テスト実行時、Helixテストキューからのテストジョブ実行時、開発者によるローカルテスト実行時に随時実行される。

**主要な処理内容**：
1. TestEnv.txtからテスト環境変数の読み込み
2. ランタイムパスの検証と正規化
3. 排他ロックの取得（並列実行制御）
4. XHarness android-headlessコマンドによるテスト実行
5. テスト結果とアーティファクトの出力
6. ロックの解放

**前後の処理との関連**：ビルドスクリプトによるBionicビルド完了後に実行される。TestEnv.txtで定義されたテスト環境設定を読み込む。

**影響範囲**：Bionicテスト結果、XHarnessアーティファクト出力、CIパイプラインのテスト判定結果に影響する。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/Helixテストキュー/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | dotnet.exeコマンドが利用可能であること |
| XHarness | XHarness CLIがインストールされているか、XHARNESS_CLI_PATHが設定されていること |
| ランタイム | --runtime-pathで指定されたパスにdotnetランタイムが存在すること |
| TestEnv.txt | 実行ディレクトリにTestEnv.txtが存在すること |
| テストアセンブリ | ASSEMBLY_NAMEで指定されたテストアセンブリが存在すること |

### 実行可否判定

--runtime-pathオプションが指定され、有効なdotnetランタイムパスが存在する場合に実行可能。TestEnv.txtから環境設定が正しく読み込まれる必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 | string | Yes | - | --runtime-path（固定値） |
| %2 (RUNTIME_PATH) | string | Yes | - | dotnetランタイムへのパス |
| %3-%9 | string | No | - | XHarnessへの追加引数 |
| XHARNESS_CLI_PATH | env | No | - | XHarness CLIDLLへのパス |
| HELIX_WORKITEM_UPLOAD_ROOT | env | No | - | Helixアーティファクトアップロードルート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| TestEnv.txt | シェル変数形式 | ASSEMBLY_NAME、TEST_ARCH等のテスト環境設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %XHARNESS_OUT% | ディレクトリ | XHarnessテスト結果アーティファクト |
| 標準出力 | テキスト | テスト実行ログ |
| ERRORLEVEL | 整数 | テスト結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | XHarnessが生成する各種結果ファイル |
| 出力先 | %EXECUTION_DIR%xharness-output または %HELIX_WORKITEM_UPLOAD_ROOT%\xharness-output |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 実行環境の初期化
   └─ 実行ディレクトリの特定、TestEnv.txtの読み込み
2. 入力パラメータの検証
   └─ --runtime-pathオプションの存在確認
3. パスの正規化
   └─ RUNTIME_PATHをNORMALIZEPATH関数で絶対パスに変換
4. 排他ロックの取得
   └─ androidtests.lockディレクトリによるセマフォ
5. XHarness実行環境の検出
   └─ XHARNESS_CLI_PATHまたはdotnet.exe xharnessの設定
6. テスト実行
   └─ XHarness android-headlessコマンドの実行
7. 結果出力
   └─ 終了コードとアーティファクトパスを出力
8. ロック解放
   └─ androidtests.lockディレクトリの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[TestEnv.txt読み込み]
    B --> C{--runtime-path確認}
    C -->|なし| D[エラー終了]
    C -->|あり| E[RUNTIME_PATH正規化]
    E --> F[ロック取得試行]
    F --> G{ロック取得成功?}
    G -->|No| H[5秒待機]
    H --> F
    G -->|Yes| I[XHarness CLI検出]
    I --> J[android-headless test実行]
    J --> K[終了コード取得]
    K --> L[アーティファクトパス出力]
    L --> M[ロック解放]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータエラー | --runtime-pathオプションが指定されていない | 正しいオプションを指定して再実行 |
| 非0 | テスト失敗 | XHarnessテストが失敗した場合 | テスト結果ログを確認し、失敗テストを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | ロック取得は無限リトライ（ping待機） |
| リトライ間隔 | 約5秒（ping -n 6による待機） |
| リトライ対象エラー | ロック取得失敗のみ |

### 障害時対応

1. XHarnessアーティファクト（%XHARNESS_OUT%）を確認
2. TestEnv.txtの設定内容を確認
3. ランタイムパスが正しいか確認
4. ロックが残っている場合は手動でandroidtests.lockディレクトリを削除

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（テスト実行のため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テストケース数に依存 |
| 目標処理時間 | 1800秒（30分）のタイムアウト設定 |
| メモリ使用量上限 | 環境依存 |

## 排他制御

| 項目 | 内容 |
|-----|------|
| 排他制御方式 | ディレクトリロック（androidtests.lock） |
| ロック取得 | MKDIRコマンドによる排他的ディレクトリ作成 |
| ロック解放 | RMDIR /Qによるディレクトリ削除 |
| 待機方式 | ping -n 6（約5秒間隔）でリトライ |

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | パラメータエラー時 | 使用方法メッセージ |
| 終了ログ | バッチ終了時 | XHarnessアーティファクトパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |
| タイムアウト | 1800秒 | XHarness |

## 備考

- Linux/macOS版（BionicRunnerTemplate.sh）と機能的に同等
- ヘッドレスモード（android-headless）でのテスト実行に特化
- 並列実行をサポートしないため、ディレクトリロックによるセマフォを実装
- タイムアウトは1800秒（30分）に設定
- TestEnv.txtの読み込みにはFOR /Fコマンドを使用
- TEST_SCRIPTはASSEMBLY_NAMEから自動生成（.dllを.shに置換）
- パスの正規化にはNORMALIZEPATH関数（%~f1）を使用
- 遅延展開（setlocal enabledelayedexpansion）を使用
