# バッチ設計書 27-BionicRunOnDevice.sh

## 概要

本ドキュメントは、実機またはエミュレータ上でBionicテストを実行するスクリプト `eng/testing/BionicRunOnDevice.sh` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムのAndroid Bionic libc環境対応テストを実機またはエミュレータ上で実行するためのスクリプトである。XUnitテストランナーを使用して、Bionic環境でのテストを実行し、XML形式で結果を出力する。BionicRunnerTemplate.shのヘッドレスモードとは異なり、実際のデバイス環境でのテスト実行に特化している。

**業務上の目的・背景**：Android Bionicは、AndroidのC標準ライブラリ（libc）実装である。実機またはエミュレータでのテスト実行により、より実環境に近い条件での動作確認が可能となる。本バッチは、adb（Android Debug Bridge）を使用してデバイス上でテストを実行する基盤を提供し、実環境での.NET動作の品質保証に不可欠である。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド後テスト実行時、Helixテストキューからのテストジョブ実行時、開発者によるローカルテスト実行時に随時実行される。

**主要な処理内容**：
1. コマンドライン引数の検証（-r ランタイムパス）
2. オプションの-l（プリロードライブラリ）パスの処理
3. OpenSSLライブラリの自動検出と設定
4. HOME環境変数の設定（Androidの制限回避）
5. XUnitテストランナーによるテスト実行
6. XML形式でのテスト結果出力

**前後の処理との関連**：ビルドスクリプトによるBionicビルド完了後に実行される。テスト対象のアセンブリとランタイムがデバイス上で利用可能である必要がある。

**影響範囲**：Bionicテスト結果（testResults.xml）、コンソール出力に影響する。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/Helixテストキュー/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| dotnetランタイム | -rオプションで指定されたdotnet実行ファイルが存在すること |
| テストアセンブリ | 実行ディレクトリにテスト用DLLが存在すること |
| XUnit | xunit.console.dllが実行ディレクトリに存在すること |
| デバイス/エミュレータ | adb経由でアクセス可能なデバイスが存在すること |

### 実行可否判定

-rオプションで指定されたdotnet実行ファイルが有効で、テストアセンブリが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -r | string | Yes | - | dotnetランタイム実行ファイルへのパス |
| -l | string | No | - | プリロードライブラリディレクトリへのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ${currentTest}.dll | DLL | テスト対象アセンブリ |
| ${currentTest}.runtimeconfig.json | JSON | ランタイム構成ファイル |
| ${currentTest}.deps.json | JSON | 依存関係ファイル（存在する場合） |
| xunit.console.dll | DLL | XUnitテストランナー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| testResults.xml | XML | XUnitテスト結果 |
| 標準出力 | テキスト | テスト実行ログ |
| 終了コード | 整数 | テスト結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | testResults.xml |
| 出力先 | 実行ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ -r（ランタイムパス）、-l（プリロードライブラリ）の取得
2. ランタイムパスの検証
   └─ 実行ファイルの存在確認
3. プリロードライブラリの設定
   └─ LD_LIBRARY_PATH環境変数の設定
4. OpenSSLの検出と設定
   └─ ランタイムフォルダ内のOpenSSLライブラリの検出、SSL_CERT_DIRの設定
5. HOME環境変数の設定
   └─ 実行ディレクトリをHOMEに設定（Android制限回避）
6. 作業ディレクトリへの移動
   └─ テストアセンブリのあるディレクトリへcd
7. XUnitテスト実行
   └─ dotnet exec xunit.console.dllによるテスト実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|引数なし| C[使用方法表示]
    C --> D[終了]
    B -->|引数あり| E{-r オプション確認}
    E -->|なし| F[エラー: ランタイム必須]
    F --> D
    E -->|あり| G{ランタイム存在確認}
    G -->|なし| H[エラー: 無効なランタイム]
    H --> D
    G -->|あり| I{-l オプション確認}
    I -->|あり| J[LD_LIBRARY_PATH設定]
    I -->|なし| K[OpenSSL検出]
    J --> K
    K --> L{OpenSSLあり?}
    L -->|Yes| M[OpenSSL LD_LIBRARY_PATH設定]
    M --> N[SSL_CERT_DIR設定]
    L -->|No| O[HOME設定]
    N --> O
    O --> P[実行ディレクトリへcd]
    P --> Q{deps.jsonあり?}
    Q -->|Yes| R[--depsfile引数追加]
    Q -->|No| S[XUnit実行]
    R --> S
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 0 | 使用方法表示 | 引数なしで実行 | 正しい引数で再実行 |
| 1 | パラメータエラー | -rオプションが不正 | 正しいオプション形式で再実行 |
| 1 | ランタイムエラー | 指定されたランタイムが無効 | 有効なdotnetパスを指定 |
| 1 | ディレクトリエラー | -lで指定されたディレクトリが無効 | 有効なディレクトリパスを指定 |
| 非0 | テスト失敗 | XUnitテストが失敗した場合 | テスト結果XMLを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. testResults.xmlを確認
2. ランタイムパスが正しいか確認
3. OpenSSLライブラリの配置を確認
4. デバイス/エミュレータへの接続状態を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（テスト実行のため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | テストケース数に依存 |
| 目標処理時間 | テストケース数に依存 |
| メモリ使用量上限 | デバイス/エミュレータのメモリに依存 |

## 排他制御

本バッチ自体は排他制御を行わない。デバイスへの排他アクセスはadbまたは上位スクリプトで制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | パラメータエラー時 | 使用方法メッセージ |
| テスト結果 | テスト完了時 | testResults.xml |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |

## 備考

- スクリプト名から自動的にテスト名を導出（.shを除去）
- XUnitの除外トレイト：IgnoreForCI、OuterLoop、failing
- OpenSSLライブラリはランタイムフォルダ内のopenssl/prefabから自動検出
- アーキテクチャマッピング：
  - x86_64 -> x86_64
  - i*86 -> x86
  - armv* -> armeabi-v7a
  - aarch* -> arm64-v8a
- SSL_CERT_DIRは/system/etc/security/cacertsに設定（Helix環境向け）
- Androidの無効なHOME値を回避するため、実行ディレクトリをHOMEに設定
- --nologo、--nocolorオプションでクリーンな出力を生成
