# バッチ設計書 28-build-docker-sdk.sh

## 概要

本ドキュメントは、Docker SDKイメージビルドスクリプト `eng/docker/build-docker-sdk.sh` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムの現在のビルド成果物を含むdotnet SDK Dockerイメージを作成するためのスクリプトである。Linux環境向けに、ビルド済みのライブラリを含むカスタムSDKイメージを生成し、コンテナ化テストやストレステストの実行基盤を提供する。

**業務上の目的・背景**：.NETランタイムの開発・テストにおいて、ビルド成果物を含むDockerイメージが必要となる。本バッチは、現在のビルド結果をパッケージ化したSDKイメージを自動生成することで、コンテナ環境でのテスト実行を効率化する。CI/CDパイプラインでのコンテナ化テストや、HttpStress等のストレステスト実行に不可欠である。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド完了後、コンテナ化テスト実行前に随時実行される。

**主要な処理内容**：
1. リポジトリルートおよびバージョン情報の取得
2. コマンドライン引数の解析（イメージ名、構成）
3. Dockerfileパスの決定
4. docker buildコマンドの実行
5. カスタムSDKイメージの生成

**前後の処理との関連**：ビルドスクリプト（build.sh等）によるライブラリビルド完了後に実行される。生成されたイメージは後続のコンテナ化テストで使用される。

**影響範囲**：Dockerイメージレジストリ、コンテナ化テスト環境に影響する。

## バッチ種別

ビルド・イメージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker | Dockerがインストールされ、実行可能であること |
| ビルド成果物 | ライブラリビルドが完了していること |
| Dockerfile | eng/docker/libraries-sdk.linux.Dockerfileが存在すること |
| Git | gitコマンドが利用可能であること |
| eng/Versions.props | バージョン情報ファイルが存在すること |

### 実行可否判定

Dockerデーモンが起動しており、必要なビルド成果物とDockerfileが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -imagename / -t | string | No | dotnet-sdk-libs-current | 生成するDockerイメージ名 |
| -configuration / -c | string | No | Release | ビルド構成（Debug/Release） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/Versions.props | XML | MajorVersion、MinorVersionの取得元 |
| eng/docker/libraries-sdk.linux.Dockerfile | Dockerfile | Dockerイメージビルド定義 |
| リポジトリルート | ディレクトリ | ビルドコンテキスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Dockerイメージ | Dockerイメージ | 生成されたSDKイメージ |
| 終了コード | 整数 | ビルド結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| イメージ名 | 指定された名前またはdotnet-sdk-libs-current |
| タグ | latest（暗黙） |
| ビルド引数 | CONFIGURATION、VERSION |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ シンボリックリンクの解決
2. リポジトリルートの取得
   └─ git rev-parse --show-toplevelで取得
3. バージョン情報の取得
   └─ eng/Versions.propsからMajorVersion、MinorVersionを抽出
4. コマンドライン引数の解析
   └─ イメージ名、構成の取得
5. Dockerfileパスの決定
   └─ libraries-sdk.linux.Dockerfile
6. docker buildの実行
   └─ --build-argでCONFIGURATION、VERSIONを渡す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[リポジトリルート取得]
    C --> D[Versions.propsからバージョン取得]
    D --> E[コマンドライン引数解析]
    E --> F[Dockerfileパス設定]
    F --> G[docker build実行]
    G --> H[終了コード取得]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | Docker ビルドエラー | docker buildコマンドが失敗 | ビルドログを確認し、Dockerfile/依存関係を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. docker buildの出力ログを確認
2. Dockerfileの構文エラーを確認
3. ビルドコンテキスト（リポジトリルート）の内容を確認
4. Versions.propsのバージョン情報を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（Dockerイメージビルドのため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1イメージ |
| 目標処理時間 | ビルド内容に依存 |
| メモリ使用量上限 | Docker設定に依存 |

## 排他制御

Dockerデーモンレベルでの排他制御に依存。同一イメージ名への同時ビルドは最後のビルドが有効となる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | docker build実行中 | Dockerビルドの標準出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |

## 備考

- set -u：未定義変数使用時にエラー
- set -e：コマンドエラー時にスクリプト停止
- シンボリックリンクの再帰的解決をサポート
- バージョンは{MajorVersion}.{MinorVersion}形式（例: 9.0）
- grepの-oPオプションでPerl正規表現を使用
- ビルドコンテキストはリポジトリルート全体
- Linux向けDockerfile（libraries-sdk.linux.Dockerfile）を使用
- Windows向けは別スクリプト（build-docker-sdk.ps1）で対応
