# バッチ設計書 29-build-docker-sdk.ps1

## 概要

本ドキュメントは、Docker SDKイメージビルドスクリプト `eng/docker/build-docker-sdk.ps1` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムの現在のビルド成果物を含むdotnet SDK Dockerイメージを作成するためのPowerShellスクリプトである。LinuxおよびWindows両環境のコンテナイメージ生成をサポートし、コンテナ化テストやストレステストの実行基盤を提供する。

**業務上の目的・背景**：.NETランタイムの開発・テストにおいて、ビルド成果物を含むDockerイメージが必要となる。本バッチは、現在のビルド結果をパッケージ化したSDKイメージを自動生成することで、コンテナ環境でのテスト実行を効率化する。特にWindowsコンテナでは、サイズの問題からホストマシンでビルドしてからイメージにコピーする最適化を行っている。

**バッチの実行タイミング**：CI/CDパイプラインでのビルド完了後、コンテナ化テスト実行前に随時実行される。

**主要な処理内容**：
1. リポジトリルートおよびバージョン情報の取得
2. コマンドライン引数の解析（イメージ名、構成、Windowsコンテナフラグ）
3. Linux/Windowsに応じたビルド方式の選択
4. Windowsコンテナ時：ホストでのビルドとアーティファクト収集
5. docker buildコマンドの実行
6. カスタムSDKイメージの生成

**前後の処理との関連**：ビルドスクリプト（build.cmd等）によるライブラリビルド完了後に実行される。生成されたイメージは後続のコンテナ化テストで使用される。

**影響範囲**：Dockerイメージレジストリ、コンテナ化テスト環境に影響する。

## バッチ種別

ビルド・イメージ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDトリガー） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CIパイプライン/手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Docker | Dockerがインストールされ、実行可能であること |
| PowerShell | PowerShell環境が利用可能であること |
| Git | gitコマンドが利用可能であること |
| eng/Versions.props | バージョン情報ファイルが存在すること |
| Dockerfile | 対象プラットフォームのDockerfileが存在すること |

### 実行可否判定

Dockerデーモンが起動しており、必要なDockerfileが存在する場合に実行可能。Windowsコンテナビルド時はビルド成果物が存在する必要がある。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -imageName / -t | string | No | dotnet-sdk-libs-current | 生成するDockerイメージ名 |
| -configuration / -c | string | No | Release | ビルド構成（Debug/Release） |
| -buildWindowsContainers / -w | switch | No | false | Windowsコンテナビルドフラグ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/Versions.props | XML | MajorVersion、MinorVersionの取得元 |
| eng/docker/libraries-sdk.linux.Dockerfile | Dockerfile | Linux用イメージビルド定義 |
| eng/docker/libraries-sdk.windows.Dockerfile | Dockerfile | Windows用イメージビルド定義 |
| artifacts/bin | ディレクトリ | ビルド成果物（Windowsコンテナ用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Dockerイメージ | Dockerイメージ | 生成されたSDKイメージ |
| LASTEXITCODE | 整数 | ビルド結果（0:成功、非0:失敗） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| イメージ名 | 指定された名前またはdotnet-sdk-libs-current |
| タグ | latest（暗黙） |
| ビルド引数 | CONFIGURATION、VERSION |

## 処理フロー

### 処理シーケンス

```
1. リポジトリルートの取得
   └─ git rev-parse --show-toplevelで取得
2. バージョン情報の取得
   └─ eng/Versions.propsからXML解析でMajorVersion、MinorVersionを抽出
3. コマンドライン引数の解析
   └─ イメージ名、構成、Windowsフラグの取得
4. プラットフォーム判定
   └─ -buildWindowsContainersフラグに基づく分岐
5-A. Windowsコンテナの場合
   └─ ホストでbuild.cmdを実行してビルド
   └─ アーティファクトをdocker-contextに収集
   └─ libraries-sdk.windows.Dockerfileでビルド
5-B. Linuxコンテナの場合
   └─ libraries-sdk.linux.Dockerfileでビルド
6. docker buildの実行
   └─ --build-argでCONFIGURATION、VERSIONを渡す
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[リポジトリルート取得]
    B --> C[Versions.propsからバージョン取得]
    C --> D{Windowsコンテナ?}
    D -->|Yes| E[build.cmd実行]
    E --> F{ビルド成功?}
    F -->|No| G[エラー終了]
    F -->|Yes| H[docker-context作成]
    H --> I[アーティファクト収集]
    I --> J[AspNetCore除去]
    J --> K[Windows Dockerfile使用]
    D -->|No| L[Linux Dockerfile使用]
    K --> M[docker build実行]
    L --> M
    M --> N[終了コード取得]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | build.cmdが失敗（Windowsコンテナ時） | ビルドログを確認 |
| 非0 | Dockerビルドエラー | docker buildコマンドが失敗 | Dockerビルドログを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. docker buildの出力ログを確認
2. Windowsコンテナ時はbuild.cmdのビルドログを確認
3. docker-contextディレクトリの内容を確認
4. Dockerfileの構文エラーを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（Dockerイメージビルドのため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1イメージ |
| 目標処理時間 | ビルド内容に依存 |
| メモリ使用量上限 | Docker設定に依存 |

## 排他制御

Dockerデーモンレベルでの排他制御に依存。同一イメージ名への同時ビルドは最後のビルドが有効となる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | build.cmd実行中 | .NETビルドの標準出力（Windowsコンテナ時） |
| Dockerログ | docker build実行中 | Dockerビルドの標準出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |

## 備考

- $ErrorActionPreference = "Stop"でエラー時に停止
- Windowsコンテナはサイズ問題からホストビルド後にコピー方式を採用
- Windowsコンテナ用に収集されるアーティファクト：
  - microsoft.netcore.app.ref（参照アセンブリパック）
  - microsoft.netcore.app.runtime.win-x64（ランタイムパック）
  - testhost（テストホスト）
  - targetingpacks.targets（ターゲティングパック設定）
  - msquic-interop（QUIC相互運用ソース、HttpStress用）
- Microsoft.AspNetCore.Appはテストホストから除去（非CIビルド対応）
- バージョン形式は{MajorVersion}.{MinorVersion}（例: 9.0）
- [CmdletBinding(PositionalBinding=$false)]で名前付きパラメータを強制
- Linuxコンテナ時はリポジトリルート全体がビルドコンテキスト
- Windowsコンテナ時はartifacts/docker-contextがビルドコンテキスト
