# バッチ設計書 3-eng/build.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/build.sh` - Linux/macOS向けメインビルドスクリプトの設計仕様を記載する。

### 本バッチの処理概要

このバッチは、.NET Runtimeプロジェクトの実際のビルド処理を制御するメインスクリプトである。ルートの `build.sh` から呼び出され、アーキテクチャ、構成、サブセットの指定に基づいてCoreCLR、Mono、ライブラリのビルドを実行する。豊富なコマンドラインオプションにより、様々なビルドシナリオに対応できる。

**業務上の目的・背景**：.NET Runtimeは複雑なマルチコンポーネントプロジェクトであり、開発者やCIシステムが特定のコンポーネント（CLR、Mono、Libraries等）を選択的にビルドする必要がある。このスクリプトは、サブセットビルド、クロスコンパイル、複数の構成オプションをサポートし、効率的な開発ワークフローを実現する。

**バッチの実行タイミング**：ルートの `build.sh` から呼び出される。開発者による手動実行時やCI/CDパイプラインでのビルド時に使用される。

**主要な処理内容**：
1. コマンドライン引数の解析と検証（アーキテクチャ、OS、構成、サブセット等）
2. ビルド環境の初期化（ディストリビューションRID、コンパイラ設定等）
3. ブートストラップビルドの実行（オプション）
4. eng/common/build.sh への処理委譲
5. MSBuildプロパティの設定と受け渡し

**前後の処理との関連**：ルートの `build.sh` から呼び出され、`eng/common/build.sh` を呼び出す。`eng/common/native/init-distro-rid.sh` や `eng/common/native/init-os-and-arch.sh` などの初期化スクリプトを読み込む。

**影響範囲**：ビルド成果物（バイナリ、パッケージ）、テスト実行、パッケージング処理に影響する。`artifacts/` ディレクトリ配下に成果物が出力される。

## バッチ種別

ビルド制御 / 構成管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | build.sh からの呼び出し / 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル | Bash互換シェルが利用可能であること |
| ビルドツール | CMake、Ninja/Make、コンパイラ（Clang/GCC）がインストールされていること |
| .NET SDK | プロジェクトで指定されたSDKバージョンが利用可能であること |
| スクリプト依存 | eng/common/build.sh、eng/common/native/*.sh が存在すること |

### 実行可否判定

スクリプトは常に実行可能だが、ビルドの成功には適切なツールチェーンのインストールが必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --arch (-a) | string | No | ホストアーキテクチャ | ターゲットプラットフォーム（x86, x64, arm, arm64, wasm等） |
| --configuration (-c) | string | No | Debug | ビルド構成（Debug, Release, Checked） |
| --os | string | No | ホストOS | ターゲットOS（linux, osx, windows等） |
| --subset (-s) | string | No | 全体 | ビルド対象サブセット（clr, mono, libs等） |
| --cross | flag | No | false | クロスコンパイルの有効化 |
| --restore (-r) | flag | No | false | 依存関係の復元 |
| --build (-b) | flag | No | false | ビルドの実行 |
| --test (-t) | flag | No | false | テストの実行 |
| --pack | flag | No | false | NuGetパッケージの作成 |
| --clang / --clangX | string | No | PATH上のclang | Clangコンパイラの指定 |
| --gcc / --gccX.Y | string | No | PATH上のgcc | GCCコンパイラの指定 |
| --ninja | flag | No | false | Ninjaビルドシステムの使用 |
| --bootstrap | flag | No | false | ブートストラップビルドの実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/native/init-os-and-arch.sh | シェルスクリプト | OS/アーキテクチャの自動検出 |
| eng/common/native/init-distro-rid.sh | シェルスクリプト | ディストリビューションRIDの初期化 |
| ROOTFS_DIR | 環境変数 | クロスコンパイル用rootfsパス |
| TreatWarningsAsErrors | 環境変数 | 警告をエラーとして扱う設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| artifacts/bin | バイナリ | ビルド成果物 |
| artifacts/obj | オブジェクト | 中間ファイル |
| artifacts/log | ログ | ビルドログ（binlog含む） |
| artifacts/packages | NuGet | パッケージファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成、アーキテクチャ、サブセットに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ set -ue でエラー時停止、シンボリックリンク解決
2. OS/アーキテクチャ検出
   └─ init-os-and-arch.sh を読み込み
3. コマンドライン引数解析
   └─ 各オプションを解析してMSBuildプロパティに変換
4. サブセットの処理
   └─ 最初の引数がサブセット指定かどうかを判定
5. ディストリビューションRID初期化
   └─ initDistroRid 関数でターゲットRIDを設定
6. ブートストラップビルド（オプション）
   └─ --bootstrap 指定時、先行ビルドを実行
7. eng/common/build.sh の呼び出し
   └─ 収集した引数を渡してビルドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[OS/Arch検出]
    B --> C[引数解析ループ]
    C --> D{サブセット指定?}
    D -->|Yes| E[/p:Subset設定]
    D -->|No| F[オプション処理]
    E --> F
    F --> G{アクション指定あり?}
    G -->|No| H[-restore -build を追加]
    G -->|Yes| I[指定アクションを使用]
    H --> J[DistroRID初期化]
    I --> J
    J --> K{Bootstrap?}
    K -->|Yes| L[Bootstrapビルド実行]
    L --> M[artifacts/bin削除]
    M --> N[eng/common/build.sh呼出]
    K -->|No| N
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 無効なアーキテクチャ/OS/構成の指定 | エラーメッセージに従い有効な値を指定 |
| 1 | 依存エラー | 必要なツール/スクリプトが存在しない | 前提条件を確認しツールをインストール |
| 非0 | ビルドエラー | コンパイルエラー、テスト失敗等 | ログを確認して問題を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動リトライ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. `set -ue` によりエラー発生行で停止するため、エラーメッセージを確認
2. バイナリログ（binlog）を確認して詳細なビルドエラーを特定
3. 必要に応じて `--verbosity diagnostic` で詳細ログを取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド実行 |
| 目標処理時間 | サブセットと構成に依存（フルビルドで数十分〜数時間） |
| メモリ使用量上限 | ビルド内容に依存（数GB〜数十GB） |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。artifacts ディレクトリへの書き込みが競合する可能性があるため、同一ディレクトリでの並行ビルドは推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗、コンパイラ出力 |
| バイナリログ | -bl 指定時 | MSBuildの詳細ログ（.binlog） |
| エラーログ | エラー発生時 | コンパイルエラー、テスト失敗詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| ビルド時間 | 構成による | CI/CDシステム |
| ディスク使用量 | 構成による | システム監視 |

## 備考

- `set -ue` により未定義変数参照とコマンドエラーで即座にスクリプトが終了する
- Browser/WASI向けビルドでは自動的にアーキテクチャがwasmに設定される
- ブートストラップビルドではartifacts/bin とartifacts/obj が削除されてクリーンビルドが行われる
- CMake引数内のスペースはURL エンコード（%20）されてMSBuildに渡される
- terminal logger は既知の問題（#97211）により無効化されている
