# バッチ設計書 30-build-commons.sh

## 概要

本ドキュメントは、ネイティブコードビルド共通スクリプト `eng/native/build-commons.sh` の設計仕様を定義する。

### 本バッチの処理概要

本バッチは、.NETランタイムのネイティブコンポーネント（CoreCLR、ライブラリ等）をビルドするための共通関数と設定を提供するスクリプトである。CMakeを使用したクロスプラットフォームビルドをサポートし、多様なターゲットOS・アーキテクチャに対応する。他のビルドスクリプトからsource（読み込み）されて使用される。

**業務上の目的・背景**：.NETランタイムは、C/C++で記述されたネイティブコンポーネントを含んでいる。本バッチは、これらのネイティブコードを複数のプラットフォーム（Linux、macOS、iOS、Android、WebAssembly等）向けにビルドするための共通基盤を提供する。クロスプラットフォーム対応とビルド設定の一元管理に不可欠である。

**バッチの実行タイミング**：直接実行されず、他のビルドスクリプト（build-native.sh等）からsourceされて使用される。

**主要な処理内容**：
1. ターゲットOS・アーキテクチャの初期化と検出
2. 前提条件のチェック（pkg-config、OpenSSL、Ninja等）
3. ディレクトリ構造のセットアップ
4. クロスコンパイル環境の設定
5. CMakeビルドシステムの生成と実行
6. 各種ビルドオプションの処理

**前後の処理との関連**：eng/common/native/init-os-and-arch.shでOS・アーキテクチャを検出後に使用される。eng/native/gen-buildsys.shを呼び出してCMakeファイルを生成する。

**影響範囲**：ネイティブコンポーネントのビルド成果物、ビルドディレクトリ構造に影響する。

## バッチ種別

ビルド共通ライブラリ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからsourceされた際 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 他ビルドスクリプトからのsource |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CMake | CMakeがインストールされていること |
| コンパイラ | Clang/GCCがインストールされていること |
| pkg-config | macOSの場合、pkg-configがインストールされていること |
| OpenSSL | macOSの場合、OpenSSLがインストールされていること |
| Ninja | -ninjaオプション使用時、Ninjaがインストールされていること |
| Android NDK | Androidビルド時、ANDROID_NDK_ROOTが設定されていること |

### 実行可否判定

必要なビルドツールがインストールされており、ターゲットプラットフォーム用のツールチェーンが利用可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -arm / -arm64 / -x64 / -x86等 | flag | No | ホストアーキテクチャ | ターゲットアーキテクチャ |
| -debug / -checked / -release | flag | No | Debug | ビルドタイプ |
| -os | string | No | ホストOS | ターゲットOS |
| -bindir | string | No | artifacts | 出力ディレクトリ |
| -ci | flag | No | false | CIビルドモード |
| -clang / -clangx.y | flag | No | - | Clangコンパイラ指定 |
| -gcc / -gccx.y | flag | No | - | GCCコンパイラ指定 |
| -ninja | flag | No | false | Ninjaビルドシステム使用 |
| -cross | flag | No | false | クロスコンパイルモード |
| -cmakeargs | string | No | - | 追加CMake引数 |
| -configureonly | flag | No | false | 構成のみ実行 |
| -skipconfigure | flag | No | false | 構成スキップ |
| -numproc | number | No | CPU数+1 | 並列ビルド数 |
| -portablebuild | flag | No | true | ポータブルビルド |
| -targetrid | string | No | 自動検出 | ターゲットRID |
| -keepnativesymbols | flag | No | false | ネイティブシンボル保持 |
| -fsanitize | string | No | - | サニタイザー有効化 |
| -verbose | flag | No | false | 詳細出力 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/native/init-os-and-arch.sh | シェルスクリプト | OS・アーキテクチャ検出 |
| eng/common/native/init-distro-rid.sh | シェルスクリプト | ディストリビューションRID初期化 |
| eng/native/gen-buildsys.sh | シェルスクリプト | CMakeビルドシステム生成 |
| eng/native/version/copy_version_files.sh | シェルスクリプト | バージョンファイルコピー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $__BinDir | ディレクトリ | ビルド成果物 |
| $__IntermediatesDir | ディレクトリ | 中間ファイル |
| CMakeCache.txt | ファイル | CMakeキャッシュ |
| 終了コード | 整数 | ビルド結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ビルド出力 | $__RootBinDir配下 |
| 中間ファイル | $__IntermediatesDir配下 |
| CMakeファイル | $__IntermediatesDir/CMakeCache.txt |

## 処理フロー

### 処理シーケンス

```
1. OS・アーキテクチャ初期化
   └─ init-os-and-arch.shからの変数設定
2. コマンドライン引数解析
   └─ 各種ビルドオプションの処理
3. 前提条件チェック（check_prereqs関数）
   └─ pkg-config、OpenSSL、Ninjaの確認
4. ディレクトリセットアップ（setup_dirs関数）
   └─ ビルドディレクトリの作成
5. RID初期化（initTargetDistroRid関数）
   └─ ターゲットディストリビューションRIDの設定
6. クロスコンパイル設定
   └─ CROSSCOMPILE、ROOTFS_DIRの設定
7. ネイティブビルド実行（build_native関数）
   └─ CMake構成とビルド実行
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプトsource] --> B[OS/アーキテクチャ初期化]
    B --> C[コマンドライン引数解析]
    C --> D[前提条件チェック]
    D --> E{前提条件OK?}
    E -->|No| F[エラー終了]
    E -->|Yes| G[ディレクトリセットアップ]
    G --> H[RID初期化]
    H --> I{クロスコンパイル?}
    I -->|Yes| J[ROOTFS_DIR設定]
    I -->|No| K[build_native呼び出し準備]
    J --> K
    K --> L[CMake構成生成]
    L --> M{構成のみ?}
    M -->|Yes| N[完了]
    M -->|No| O[ビルド実行]
    O --> P[終了コード取得]
    P --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 前提条件エラー | pkg-config/OpenSSL/Ninjaが未インストール | 必要なツールをインストール |
| 1 | CMake構成エラー | gen-buildsys.shが失敗 | CMakeエラーログを確認 |
| 1 | ビルドエラー | make/ninjaが失敗 | ビルドエラーログを確認 |
| 1 | 引数エラー | 必須オプションが未指定 | 使用方法を確認して再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認（__ErrMsgPrefixでCI用フォーマット）
2. CMakeCache.txtを確認
3. ビルドログを確認
4. 前提条件の再確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ビルド処理のため） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ビルドターゲット数に依存 |
| 目標処理時間 | ビルド内容に依存 |
| メモリ使用量上限 | ビルド内容に依存 |

## 排他制御

同一出力ディレクトリへの同時ビルドは推奨されない。ビルドシステム（Make/Ninja）レベルでの並列制御は-numprocオプションで指定。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | ターゲット、構成、ディレクトリ情報 |
| CMakeログ | 構成時 | CMake生成コマンド |
| ビルドログ | ビルド実行時 | コンパイラ出力（-verbose時は詳細） |
| エラーログ | エラー発生時 | エラーメッセージ（CI時は##vso形式） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CIパイプライン |

## 備考

- sourceされて使用されるため、直接実行は想定されていない
- 提供される主要関数：
  - initTargetDistroRid: RID初期化
  - setup_dirs: ディレクトリセットアップ
  - check_prereqs: 前提条件チェック
  - build_native: ネイティブビルド実行
  - usage: 使用方法表示
- サポートされるターゲットOS：
  - linux、osx、maccatalyst
  - ios、iossimulator、tvos、tvossimulator
  - android、linux-bionic
  - browser（WebAssembly）
- サポートされるアーキテクチャ：
  - x64、x86、arm、arm64、armv6、armel
  - loongarch64、riscv64、s390x、ppc64le、wasm
- macOSではHomebrewのOpenSSLパスを自動検出
- クロスコンパイル時はROOTFS_DIR環境変数を使用
- CI環境では__ErrMsgPrefixに##vso[task.logissue type=error]を設定
- EXTRA_CFLAGS/EXTRA_CXXFLAGS/EXTRA_LDFLAGSで追加コンパイラフラグを指定可能
- scan-buildによる静的解析をサポート
