# バッチ設計書 31-gen-buildsys.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるネイティブコードビルドのためのビルドシステム生成スクリプト（Linux/macOS向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、CMakeを使用してネイティブコード（CoreCLR、Mono等）のビルドシステムファイルを生成するためのバッチ処理である。Linux/macOS環境において、指定されたアーキテクチャ、OS、コンパイラに応じた適切なビルド設定を行い、MakefileまたはNinjaビルドファイルを生成する。

**業務上の目的・背景**：.NET Runtimeは複数のプラットフォーム（Linux、macOS、Windows）と複数のアーキテクチャ（x64、ARM、ARM64、WASM等）をサポートしており、各環境に応じた適切なビルドシステムの構成が必要である。本スクリプトは、CMakeプロジェクトから各環境向けのビルドファイルを自動生成することで、開発者が手動で複雑なビルド設定を行う必要をなくし、一貫したビルドプロセスを提供する。クロスコンパイル対応により、異なるプラットフォーム向けのバイナリも同一ホストからビルドできる。

**バッチの実行タイミング**：ネイティブコードのビルド開始前（build.shまたはeng/build.shからの呼び出し時）。開発者がビルドを実行するたび、またはCI/CDパイプラインにおいてビルドジョブが開始されるときに実行される。

**主要な処理内容**：
1. コマンドライン引数の検証（CMakeLists.txtパス、中間ディレクトリパス、アーキテクチャ、OS、コンパイラ）
2. コンパイラ設定の初期化（init-compiler.shの呼び出し）
3. ビルドタイプ（DEBUG/CHECKED/RELEASE/RELWITHDEBINFO）の設定
4. ジェネレータ（Unix Makefiles/Ninja）の選択
5. クロスコンパイル設定（toolchain.cmake、tryrun.cmakeの適用）
6. WASM/WASI環境向けの特別設定（Emscripten SDK、WASI SDK）
7. CMakeの実行とビルドファイル生成

**前後の処理との関連**：本スクリプトはbuild-commons.shから呼び出される。生成されたビルドファイルは後続のmake/ninjaによるコンパイル処理で使用される。init-compiler.shを事前に読み込み、コンパイラ環境を設定する。

**影響範囲**：指定された中間ディレクトリにビルドシステムファイル（Makefile/build.ninja）を生成。環境変数（CCC_CC、CCC_CXX、TARGET_BUILD_ARCH等）を設定。

## バッチ種別

ビルド設定生成 / CMakeプロジェクト構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動（開発者ビルド）/ 自動（CI/CDパイプライン） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CMakeインストール済み | PATH上にcmakeコマンドが存在すること |
| コンパイラインストール済み | clangまたはgccがインストールされていること |
| クロスコンパイル時のROOTFS_DIR | クロスコンパイル時はROOTFS_DIR環境変数が設定されていること（Darwin除く） |
| WASM/Browser時のEMSDK_PATH | Browser向けビルド時はEmscripten SDKがセットアップされていること |
| WASM/WASI時のWASI_SDK_PATH | WASI向けビルド時はWASI SDKがセットアップされていること |

### 実行可否判定

- 引数が4個未満の場合はUsageを表示して終了（exit 1）
- CMakeが見つからない場合は終了（exit 1）
- クロスコンパイル時にROOTFS_DIRが未設定の場合は終了（exit 1）
- WASM向けビルドで必要なSDKが未設定の場合は終了（exit 1）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | CMakeLists.txtへのパス |
| $2 | string | Yes | - | 中間ディレクトリパス |
| $3 | string | Yes | - | ホストアーキテクチャ（x64, arm, arm64, armel, wasm等） |
| $4 | string | Yes | - | ターゲットOS（linux, darwin, browser, wasi等） |
| $5 | string | Yes | - | コンパイラ（clang, gcc, default） |
| $6+ | string | No | DEBUG | ビルドタイプ、Ninja指定、scan-build指定、追加CMake引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CMakeLists.txt | CMakeスクリプト | ビルド対象のCMakeプロジェクト定義 |
| tryrun.cmake | CMakeキャッシュ | クロスコンパイル用tryrun結果キャッシュ |
| tryrun.browser.cmake | CMakeキャッシュ | WASM/Browser用tryrun結果キャッシュ |
| toolchain.cmake | CMakeツールチェーンファイル | クロスコンパイル用ツールチェーン定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $2（中間ディレクトリ） | ビルドファイル | 生成されたビルドシステムファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Makefile（Unix Makefiles）/ build.ninja（Ninja） |
| 出力先 | 引数$2で指定された中間ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ 引数が4個未満の場合はUsage表示して終了
2. 基本変数設定
   └─ host_arch、target_os、compilerを引数から取得
3. コンパイラ初期化
   └─ compilerがdefaultでない場合、init-compiler.shを読み込み
   └─ CC、CXX、CCC_CC、CCC_CXX環境変数を設定
4. ビルドオプション解析
   └─ $6以降の引数を解析
   └─ ビルドタイプ（DEBUG/CHECKED/RELEASE/RELWITHDEBINFO）の判定
   └─ Ninja指定の判定
   └─ scan-build指定の判定
   └─ その他のCMake引数の収集
5. クロスコンパイル設定
   └─ CROSSCOMPILE=1の場合、ツールチェーンファイルを設定
   └─ Darwin以外でROOTFS_DIRが未設定の場合はエラー
6. アーキテクチャ固有設定
   └─ armelの場合、ARM_SOFTFP=1を設定
7. WASM環境設定
   └─ browser向け：Emscripten SDKを初期化、emcmakeプレフィックス設定
   └─ wasi向け：WASI SDKツールチェーン設定
8. CMake実行
   └─ 設定済みオプションでCMakeを実行
   └─ ビルドファイルを中間ディレクトリに生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数チェック}
    B -->|4個未満| C[Usage表示・終了]
    B -->|4個以上| D[変数設定]
    D --> E{compiler != default?}
    E -->|Yes| F[init-compiler.sh読み込み]
    E -->|No| G[ビルドオプション解析]
    F --> G
    G --> H{CROSSCOMPILE=1?}
    H -->|Yes| I{Darwin?}
    I -->|Yes| J[Darwin用設定]
    I -->|No| K{ROOTFS_DIR設定済み?}
    K -->|No| L[エラー終了]
    K -->|Yes| M[ツールチェーン設定]
    J --> N[アーキテクチャ固有設定]
    M --> N
    H -->|No| N
    N --> O{WASM?}
    O -->|Yes| P{browser or wasi?}
    P -->|browser| Q[Emscripten設定]
    P -->|wasi| R[WASI SDK設定]
    P -->|その他| S[エラー終了]
    Q --> T[CMake実行]
    R --> T
    O -->|No| T
    T --> U[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が4個未満 | 正しい引数を指定して再実行 |
| 1 | 環境エラー | CMakeが見つからない | CMakeをインストールしPATHに追加 |
| 1 | 環境エラー | ROOTFS_DIR未設定（クロスコンパイル時） | ROOTFS_DIR環境変数を設定 |
| 1 | 環境エラー | EMSDK_PATH未設定（browser向け） | Emscripten SDKをセットアップ |
| 1 | 環境エラー | WASI_SDK_PATH未設定（wasi向け） | WASI SDKをセットアップ |
| CMake終了コード | CMakeエラー | CMake実行失敗 | CMakeエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- CMakeエラーの場合：エラーメッセージを確認し、不足している依存関係やツールをインストール
- SDK未設定エラーの場合：該当するSDKをダウンロード・設定
- クロスコンパイルエラーの場合：ROOTFS_DIRが正しく設定されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルドにつき1回 |
| 目標処理時間 | 数秒〜数十秒（プロジェクト規模による） |
| メモリ使用量上限 | CMakeプロセスに依存 |

## 排他制御

- 同一中間ディレクトリに対する同時実行は非推奨
- 異なる構成（アーキテクチャ/ビルドタイプ）は異なる中間ディレクトリを使用することで並列実行可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | 明示的な開始ログなし |
| 進捗ログ | scan-build有効時 | "Static analysis is turned on for this build." |
| 進捗ログ | CMake実行時 | CMakeの出力がそのまま標準出力に表示 |
| エラーログ | エラー発生時 | "CMake was not found in PATH." / "ROOTFS_DIR not set for crosscompile" / SDK未設定エラー等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- CMakeの終了コードがそのままスクリプトの終了コードとして使用される
- scan-build機能により、Clang Static Analyzerを使用した静的解析ビルドが可能
- WASM向けビルドでは、emcmakeラッパーを通じてCMakeが実行される
