# バッチ設計書 32-gen-buildsys.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるネイティブコードビルドのためのビルドシステム生成スクリプト（Windows向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、CMakeを使用してWindows環境におけるネイティブコード（CoreCLR、Mono等）のビルドシステムファイルを生成するためのバッチ処理である。Visual StudioジェネレータまたはNinjaを使用して、指定されたアーキテクチャとOSに応じたビルドファイルを生成する。

**業務上の目的・背景**：.NET RuntimeのWindows向けネイティブビルドでは、Visual StudioのMSBuildプロジェクトファイルまたはNinjaビルドファイルが必要である。本スクリプトは、CMakeプロジェクトからこれらのビルドファイルを自動生成することで、開発者が手動でプロジェクト設定を行う必要をなくす。また、WASM（Browser/WASI）やAndroid向けのクロスコンパイルにも対応しており、Windows開発環境から多様なプラットフォーム向けのビルドが可能である。コマンドライン引数のキャッシュ機能により、設定が変わらない場合はCMake再実行をスキップして効率化を図る。

**バッチの実行タイミング**：ネイティブコードのビルド開始前（build.cmdまたはeng/build.ps1からの呼び出し時）。開発者がビルドを実行するたび、またはCI/CDパイプラインにおいてWindowsビルドジョブが開始されるときに実行される。

**主要な処理内容**：
1. コマンドライン引数の検証（CMakeLists.txtパス、中間ディレクトリパス、VSバージョン、アーキテクチャ、OS）
2. WASM/Browser向けEmscripten SDK環境の設定
3. Visual StudioバージョンとアーキテクチャによるCMakeジェネレータの選択
4. WASM/WASI向けの特別設定（NMake Makefiles、WASI SDKツールチェーン）
5. Android向けNDKツールチェーン設定
6. コマンドライン引数のキャッシュ確認と再実行スキップ判定
7. CMakeの実行とビルドファイル生成

**前後の処理との関連**：本スクリプトはeng/build.ps1や他のビルドスクリプトから呼び出される。生成されたビルドファイルは後続のMSBuild/Ninjaによるコンパイル処理で使用される。__CMakeBinDir、CMakePath等の環境変数が事前に設定されている必要がある。

**影響範囲**：指定された中間ディレクトリにビルドシステムファイル（.vcxproj/build.ninja/Makefile）を生成。環境変数（EMSDK_QUIET、WASI_SDK_PATH等）を設定する場合がある。

## バッチ種別

ビルド設定生成 / CMakeプロジェクト構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動（開発者ビルド）/ 自動（CI/CDパイプライン） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| CMakeインストール済み | CMakePathまたはPATH上にcmakeが存在すること |
| Visual Studio 2022/2026インストール済み | VS 17.0または18.0がインストールされていること |
| WASM/Browser時のEMSDK_PATH | Browser向けビルド時はEmscripten SDKがセットアップされていること |
| WASM/WASI時のWASI_SDK_PATH | WASI向けビルド時はWASI SDKがセットアップされていること |
| Android時のANDROID_NDK_ROOT | Android向けビルド時はAndroid NDKがセットアップされていること |

### 実行可否判定

- 引数が4個未満の場合はUsageを表示して終了（exit /B 1）
- 引数が"/?"""の場合はUsageを表示
- WASM向けでOS未指定の場合はエラー終了
- 各SDK未設定の場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 | string | Yes | - | CMakeLists.txtへのパス |
| %2 | string | Yes | - | 中間ディレクトリパス |
| %3 | string | Yes | - | Visual Studioバージョン（17.0, 18.0） |
| %4 | string | Yes | - | アーキテクチャ（x64, x86, arm, arm64, wasm） |
| %5 | string | No | - | ターゲットOS（browser, wasi, android） |
| %6+ | string | No | - | 追加CMake引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| CMakeLists.txt | CMakeスクリプト | ビルド対象のCMakeプロジェクト定義 |
| tryrun.cmake | CMakeキャッシュ | Android向けtryrun結果キャッシュ |
| android.toolchain.cmake | CMakeツールチェーンファイル | Android NDKツールチェーン |
| wasi-sdk-p2.cmake | CMakeツールチェーンファイル | WASI SDKツールチェーン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %2（中間ディレクトリ） | ビルドファイル | 生成されたビルドシステムファイル |
| cmake_cmd_line.txt | テキストファイル | CMakeコマンドライン引数キャッシュ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | *.vcxproj（Visual Studio）/ build.ninja（Ninja）/ Makefile（NMake） |
| 出力先 | 引数%2で指定された中間ディレクトリ |
| 文字コード | UTF-8/UTF-16（ジェネレータによる） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ 引数が4個未満または/?の場合はUsage表示して終了
2. 基本変数設定
   └─ __SourceDir、__IntermediatesDir、__VSVersion、__Arch、__Osを引数から取得
3. Emscripten SDK設定（browser向け）
   └─ EMSDK_PATHが未設定の場合はデフォルトパスを使用
   └─ emsdk_envを呼び出して環境を設定
4. CMakeジェネレータ選択
   └─ __Ninja=1の場合はNinjaジェネレータ
   └─ wasmの場合はNMake Makefiles
   └─ それ以外はVisual Studioジェネレータ（バージョン17/18に応じて選択）
5. アーキテクチャ設定
   └─ x64/arm/arm64/x86に応じて-Aオプションを設定
6. WASM設定
   └─ browser：emcmakeプレフィックス設定
   └─ wasi：WASI SDKツールチェーン設定、Ninjaジェネレータ強制
7. Android設定
   └─ NDKツールチェーン設定
   └─ APIレベル21を設定
   └─ アーキテクチャに応じたABI設定
8. 追加引数収集
   └─ %6以降の引数を__ExtraCmakeParamsに追加
9. コマンドラインキャッシュ確認
   └─ 非Visual Studioジェネレータかつ__ConfigureOnly!=1の場合
   └─ 前回と同じコマンドラインなら実行スキップ
10. CMake実行
    └─ 設定済みオプションでCMakeを実行
    └─ 成功時はコマンドラインをキャッシュファイルに保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数チェック}
    B -->|4個未満 or /?| C[Usage表示・終了]
    B -->|4個以上| D[変数設定]
    D --> E{__Os == browser?}
    E -->|Yes| F[Emscripten SDK設定]
    E -->|No| G[ジェネレータ選択]
    F --> G
    G --> H{__Ninja == 1?}
    H -->|Yes| I[Ninjaジェネレータ]
    H -->|No| J{__Arch == wasm?}
    J -->|Yes| K[NMake Makefilesジェネレータ]
    J -->|No| L[Visual Studioジェネレータ]
    I --> M[アーキテクチャ設定]
    K --> M
    L --> M
    M --> N{__Arch == wasm?}
    N -->|Yes| O{__Os判定}
    O -->|browser| P[emcmake設定]
    O -->|wasi| Q[WASI SDK設定]
    O -->|未指定| R[エラー終了]
    P --> S[Android判定]
    Q --> S
    N -->|No| S
    S --> T{__Os == android?}
    T -->|Yes| U[Android NDK設定]
    T -->|No| V[追加引数収集]
    U --> V
    V --> W{コマンドラインキャッシュ確認}
    W -->|同じ| X[スキップ・正常終了]
    W -->|異なるまたはなし| Y[CMake実行]
    Y --> Z{成功?}
    Z -->|Yes| AA[キャッシュ保存・終了]
    Z -->|No| AB[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が4個未満 | 正しい引数を指定して再実行 |
| 1 | 引数エラー | WASMでOS未指定 | 第5引数にbrowserまたはwasiを指定 |
| 1 | 環境エラー | EMSDK_PATH未設定（browser向け） | Emscripten SDKをセットアップ |
| 1 | 環境エラー | WASI_SDK_PATH未設定（wasi向け） | WASI SDKをセットアップ |
| 1 | 環境エラー | ANDROID_NDK_ROOT未設定（Android向け） | Android NDKをセットアップ |
| CMake終了コード | CMakeエラー | CMake実行失敗 | CMakeエラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- CMakeエラーの場合：エラーメッセージを確認し、不足している依存関係やツールをインストール
- SDK未設定エラーの場合：該当するSDKをダウンロード・設定
- Visual Studio未検出の場合：VS 2022以降をインストール

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルドにつき1回 |
| 目標処理時間 | 数秒〜数十秒（プロジェクト規模による） |
| メモリ使用量上限 | CMakeプロセスに依存 |

## 排他制御

- 同一中間ディレクトリに対する同時実行は非推奨
- 異なる構成（アーキテクチャ/ビルドタイプ）は異なる中間ディレクトリを使用することで並列実行可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | CMake実行前 | CMakeコマンドラインのエコー出力 |
| 進捗ログ | キャッシュ確認時 | "The CMake command line is the same as the last run. Skipping running CMake." |
| 進捗ログ | CMake実行時 | CMakeの出力がそのまま標準出力に表示 |
| エラーログ | エラー発生時 | SDK未設定エラー等 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- CMakeの終了コードがそのままスクリプトの終了コードとして使用される
- Visual Studio 18.0（2026）およびVisual Studio 17.0（2022）をサポート
- コマンドラインキャッシュ機能はVisual Studioジェネレータ以外で有効（MSBuildの再読み込み問題を回避）
- Android APIレベルは21（Directory.Build.propsと同期が必要）
- setlocal enabledelayedexpansionにより遅延環境変数展開を使用
