# バッチ設計書 34-generateversionscript.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける共有ライブラリのシンボルバージョニング用スクリプト生成（Windows PowerShell向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、共有ライブラリのシンボルエクスポート制御のためのリンカバージョンスクリプトを生成するPowerShellバッチ処理である。入力ファイルに記載されたシンボル名リストを読み込み、GNU ldリンカが認識するバージョンスクリプト形式に変換して標準出力に出力する。generateversionscript.shのWindows PowerShell版として同等の機能を提供する。

**業務上の目的・背景**：Windows環境でのクロスコンパイルやLinux向けビルドにおいて、PowerShellからバージョンスクリプトを生成する必要がある場合に使用される。Linux/macOS向けの共有ライブラリでは、外部に公開するシンボル（関数・変数）を明示的に制御することが重要である。本スクリプトは、シンボルリストファイルからリンカが使用するバージョンスクリプトを自動生成することで、シンボルエクスポートの管理を効率化し、意図しないシンボルの公開を防止する。プレフィックス付きシンボル（#で始まるエントリ）への対応により、複数ライブラリで共通のシンボル定義を再利用しつつ、ライブラリ固有のプレフィックスを追加できる。

**バッチの実行タイミング**：ネイティブ共有ライブラリのリンク処理前（CMakeビルドプロセス中、Windows環境）。ライブラリごとにビルド時に呼び出され、生成されたバージョンスクリプトがリンカに渡される。

**主要な処理内容**：
1. パラメータの受け取り（inputFile、prefix）
2. バージョンスクリプトのヘッダ出力（"V1.0 { global:"）
3. 入力ファイルの各行を処理
   - 空行とセミコロン(;)で始まるコメント行をスキップ
   - Windows形式の改行（CR）を除去
   - #で始まるエントリにはプレフィックスを付加し#を除去
   - それ以外のエントリはそのまま出力
4. バージョンスクリプトのフッタ出力（"local: *;"）

**前後の処理との関連**：本スクリプトはCMakeビルドプロセスから呼び出される。出力はリンカの--version-scriptオプションに渡され、共有ライブラリのシンボル可視性を制御する。シンボルリストファイル（.txt）が入力として必要。

**影響範囲**：標準出力へのバージョンスクリプト出力。ファイルシステムへの直接書き込みは行わない（呼び出し側でリダイレクト）。

## バッチ種別

ビルド補助 / コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 自動（CMakeビルドプロセス） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力ファイルの存在 | シンボルリストファイルが存在すること |
| PowerShell環境 | PowerShell 5.0以降が利用可能であること |

### 実行可否判定

- 入力ファイルが存在しない場合はGet-Contentでエラー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| inputFile | string | Yes | - | シンボルリストファイルのパス |
| prefix | string | No | - | シンボルプレフィックス（#で始まるエントリに付加） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| シンボルリストファイル | テキスト | 1行1シンボルの形式。;で始まる行はコメント。#で始まる行はプレフィックス対象 |

### 入力ファイル形式

```
; コメント行（セミコロンで開始）
シンボル名1
シンボル名2
#プレフィックス対象シンボル
```

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | GNU ldバージョンスクリプト形式 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 呼び出し側でリダイレクトにより決定 |
| 出力先 | 標準出力（Write-Output） |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

### 出力形式

```
V1.0 {
    global:
        シンボル名1;
        シンボル名2;
        プレフィックスシンボル名3;
    local: *;
};
```

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り
   └─ $inputFile、$prefixをparam()で受け取り
2. ヘッダ出力
   └─ "V1.0 {"を出力
   └─ "    global:"を出力
3. シンボル行処理（Get-Content | ForEach-Object）
   └─ 行のTrim処理
   └─ 空行チェック：空白のみの行をスキップ（return）
   └─ コメントチェック：;で始まる行をスキップ（return）
   └─ CR除去：-replace "`r", ""
   └─ プレフィックス判定：#で始まる場合
      └─ #を除去してプレフィックス付加
   └─ シンボル出力：インデント付きで出力
4. フッタ出力
   └─ "    local: *;"を出力
   └─ "};"を出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ受け取り]
    B --> C[ヘッダ出力 V1.0]
    C --> D[ヘッダ出力 global:]
    D --> E[Get-Content パイプライン]
    E --> F{ForEach 行処理}
    F -->|行あり| G[Trim処理]
    G --> H{空行 or ;コメント?}
    H -->|Yes| I[return スキップ]
    I --> F
    H -->|No| J[CR除去]
    J --> K{#で始まる?}
    K -->|Yes| L[#除去 + prefix付加]
    K -->|No| M[そのまま]
    L --> N[シンボル出力]
    M --> N
    N --> F
    F -->|EOF| O[フッタ出力 local: *]
    O --> P[フッタ出力 };]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PowerShellエラー | ファイルエラー | 入力ファイルが存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- ファイルが見つからない場合：シンボルリストファイルのパスを確認
- 出力が不正な場合：入力ファイルの形式を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ストリーム処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百シンボル/ファイル |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限（パイプライン処理） |

## 排他制御

- 標準出力への書き込みのみのため、排他制御不要
- 呼び出し側で出力リダイレクト時のファイルロックを考慮

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | なし |
| 進捗ログ | N/A | なし |
| 終了ログ | N/A | なし |
| エラーログ | N/A | なし（標準出力のみ使用） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CMakeビルドプロセス |

## 備考

- 出力形式はGNU ldのバージョンスクリプト仕様に準拠
- "local: *;"により、明示的にglobalに指定されていないシンボルはすべて非公開
- PowerShellのパイプライン処理（Get-Content | ForEach-Object）を使用
- returnステートメントでForEach-Object内の処理をスキップ（継続）
- Bash版（generateversionscript.sh）と同等の機能を提供
