# バッチ設計書 35-generateexportedsymbols.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける共有ライブラリのエクスポートシンボルリスト生成スクリプト（Linux/macOS向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、共有ライブラリの公開シンボルリストを生成するバッチ処理である。入力ファイルに記載されたシンボル名リストを読み込み、各シンボル名の先頭にアンダースコア（_）を付加した形式で標準出力に出力する。主にNative AOT（Ahead-of-Time）コンパイル用のシンボルエクスポート定義に使用される。

**業務上の目的・背景**：Native AOTやmacOSのMach-Oフォーマットでは、エクスポートするシンボルを明示的にリスト化する必要がある場合がある。特にmacOSでは、シンボル名にアンダースコアプレフィックスが必要となる。本スクリプトは、シンボルリストファイルからプラットフォーム固有の形式に変換されたエクスポートシンボルリストを自動生成することで、Native AOTビルドにおけるシンボルエクスポートの管理を効率化する。generateversionscript.shとは異なり、バージョンスクリプト形式ではなくシンプルなシンボルリスト形式（1行1シンボル、アンダースコアプレフィックス付き）を出力する。

**バッチの実行タイミング**：Native AOTビルドプロセス中、リンク処理前（CMakeビルドプロセス）。ライブラリごとにビルド時に呼び出され、生成されたシンボルリストがリンカに渡される。

**主要な処理内容**：
1. コマンドライン引数の解析（--help/-hオプションの処理）
2. 入力ファイルの各行を処理
   - 空行とセミコロン(;)で始まるコメント行をスキップ
   - Windows形式の改行（CR）を除去
   - #記号を除去（プレフィックス対象マーカーの削除）
   - 各シンボル名の先頭にアンダースコア（_）を付加して出力

**前後の処理との関連**：本スクリプトはCMakeビルドプロセスから呼び出される。出力はmacOSのリンカの-exported_symbols_listオプション等に渡され、共有ライブラリのシンボルエクスポートを制御する。シンボルリストファイル（.txt）が入力として必要。

**影響範囲**：標準出力へのシンボルリスト出力。ファイルシステムへの直接書き込みは行わない（呼び出し側でリダイレクト）。

## バッチ種別

ビルド補助 / コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 自動（CMakeビルドプロセス） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力ファイルの存在 | シンボルリストファイルが存在すること |
| Bash環境 | /usr/bin/env bashが利用可能であること |

### 実行可否判定

- --helpまたは-hオプションが指定された場合はUsageを表示して終了（exit 1）
- 入力ファイルが存在しない場合はエラー（read失敗）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | シンボルリストファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| シンボルリストファイル | テキスト | 1行1シンボルの形式。;で始まる行はコメント。#はマーカーとして除去される |

### 入力ファイル形式

```
; コメント行（セミコロンで開始）
シンボル名1
シンボル名2
#シンボル名3
```

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | アンダースコアプレフィックス付きシンボルリスト |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 呼び出し側でリダイレクトにより決定 |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

### 出力形式

```
_シンボル名1
_シンボル名2
_シンボル名3
```

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ --help/-hオプションの確認
   └─ オプションがあればUsage表示して終了
2. シンボル行処理（入力ファイルの各行をループ）
   └─ 空行チェック：空白のみの行をスキップ
   └─ コメントチェック：;で始まる行をスキップ
   └─ CR除去：Windows形式の改行を除去
   └─ #記号除去：#マーカーを削除
   └─ アンダースコア付加：_プレフィックスを付けて出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{--help/-h?}
    B -->|Yes| C[Usage表示・終了]
    B -->|No| D[ファイル読み込み開始]
    D --> E{行を読み込み}
    E -->|EOF| F[バッチ終了]
    E -->|行あり| G{空行 or ;コメント?}
    G -->|Yes| E
    G -->|No| H[CR除去]
    H --> I[#記号除去]
    I --> J[_プレフィックス付加して出力]
    J --> E
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ヘルプ表示 | --help/-hオプション指定 | 正しい引数で再実行 |
| N/A | ファイルエラー | 入力ファイルが存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- ファイルが見つからない場合：シンボルリストファイルのパスを確認
- 出力が不正な場合：入力ファイルの形式を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ストリーム処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百シンボル/ファイル |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限（行単位ストリーム処理） |

## 排他制御

- 標準出力への書き込みのみのため、排他制御不要
- 呼び出し側で出力リダイレクト時のファイルロックを考慮

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | なし |
| 進捗ログ | N/A | なし |
| 終了ログ | N/A | なし |
| エラーログ | N/A | なし（標準出力のみ使用） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CMakeビルドプロセス |

## 備考

- 出力形式はmacOSのMach-Oシンボルエクスポートリスト形式に対応
- アンダースコアプレフィックスはmacOSのABIで必要
- generateversionscript.shとは異なり、プレフィックスパラメータは不要（固定で_を付加）
- #記号は入力ファイル内のマーカーとして使用され、出力時には除去される
- Native AOTビルドで主に使用される
