# バッチ設計書 36-genmoduleindex.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるデバッグ用モジュールインデックスヘッダ生成スクリプト（Linux/macOS向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、ネイティブバイナリモジュールからビルドIDまたはUUIDを抽出し、デバッグ用のモジュールインデックスヘッダファイルを生成するバッチ処理である。生成されたヘッダファイルは、DAC（Data Access Component）やSOS（Son of Strike）デバッガでモジュールを識別するために使用される。

**業務上の目的・背景**：.NET Runtimeのデバッグ機能（特にクロスプラットフォームデバッグ）では、ネイティブモジュールを一意に識別する必要がある。LinuxではELFのBuild IDが、macOSではMach-OのUUIDが使用される。本スクリプトは、これらの識別子を抽出してC言語のバイナリリテラル形式に変換したヘッダファイルを生成することで、デバッガがモジュールを正確に識別・マッチングできるようにする。これはDAC（Data Access Component）がクラッシュダンプやライブプロセスのデバッグ時にモジュールのバージョン整合性を確認するために必要である。

**バッチの実行タイミング**：ネイティブコンポーネント（CoreCLR、DAC等）のビルド後処理。ビルドされたバイナリからモジュールインデックスを抽出し、後続のビルドで使用するヘッダファイルを生成する。

**主要な処理内容**：
1. コマンドライン引数の検証（モジュールファイルパス、出力ヘッダファイルパス、readelfパス）
2. プラットフォーム判定（Darwin/Linux）
3. プラットフォーム固有のツール実行
   - macOS：dwarfdumpでUUIDを抽出
   - Linux：readelfでBuild IDを抽出
4. IDをバイナリリテラル形式に変換（長さプレフィックス + 16進数バイト）
5. ヘッダファイルへの出力

**前後の処理との関連**：本スクリプトはCMakeビルドプロセスから呼び出される。生成されたヘッダファイルはDACやCoreClRのソースコードからインクルードされ、モジュールインデックス情報がランタイムに埋め込まれる。

**影響範囲**：指定された出力パスにヘッダファイルを生成。モジュールバイナリの読み取りのみで、変更は行わない。

## バッチ種別

ビルド補助 / コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 自動（CMakeビルドプロセス） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| モジュールファイルの存在 | ビルド済みのネイティブバイナリが存在すること |
| デバッグツールの存在 | macOS：dwarfdump / Linux：readelfが利用可能であること |
| Bash環境 | /usr/bin/env bashが利用可能であること |

### 実行可否判定

- 引数が2個未満の場合はUsageを表示して終了（exit 1）
- バイナリにBuild ID/UUIDが含まれていない場合は空のヘッダを出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 | string | Yes | - | モジュールバイナリファイルのパス |
| $2 | string | Yes | - | 出力ヘッダファイルのパス |
| $3 | string | No（Linux時は必須） | - | readelfバイナリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| モジュールバイナリ | ELF/Mach-O | ビルド済みのネイティブ共有ライブラリまたは実行ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $2（ヘッダファイル） | Cソース | バイナリリテラル形式のモジュールインデックス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 引数$2で指定 |
| 出力先 | 引数$2で指定されたパス |
| 文字コード | ASCII |
| 区切り文字 | カンマ |

### 出力形式

```c
0x10, 0xab, 0xcd, 0xef, 0x12, 0x34, 0x56, 0x78, 0x9a, 0xbc, 0xde, 0xf0, 0x12, 0x34, 0x56, 0x78, 0x9a,
```

- 最初の1バイト：ID全体の長さ（バイト数）
- 残りのバイト：Build ID/UUIDの各バイト

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ 引数が2個未満の場合はUsage表示して終了
2. printIdAsBinary関数定義
   └─ IDをバイナリリテラル形式に変換する内部関数
3. プラットフォーム判定
   └─ uname -sでOS種別を取得
4. ツール設定
   └─ Darwin：dwarfdump -u / パターン：UUID: ...
   └─ Linux：readelf -n / パターン：Build ID: ...
5. ID抽出
   └─ ツールを実行してID文字列を抽出
   └─ ハイフンを除去
6. バイナリリテラル変換
   └─ 長さプレフィックスを出力
   └─ 各2桁の16進数を0xXX形式に変換
7. ヘッダファイル出力
   └─ 変換結果を$2にリダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数数チェック}
    B -->|2個未満| C[Usage表示・終了]
    B -->|2個以上| D[プラットフォーム判定]
    D --> E{Darwin?}
    E -->|Yes| F[dwarfdump設定]
    E -->|No| G[readelf設定]
    F --> H[ツール実行・ID抽出]
    G --> H
    H --> I{パターンマッチ?}
    I -->|Yes| J[ハイフン除去]
    I -->|No| K[空出力でループ終了]
    J --> L[printIdAsBinary呼出]
    L --> M[バイナリリテラル変換]
    M --> N[ヘッダファイル出力]
    K --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 引数が2個未満 | 正しい引数を指定して再実行 |
| N/A | ツールエラー | dwarfdump/readelfが見つからない | ツールをインストール |
| N/A | パターン不一致 | Build ID/UUIDが抽出できない | バイナリがBuild ID付きでビルドされているか確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- ツールが見つからない場合：必要なデバッグツール（dwarfdump/readelf）をインストール
- Build IDが抽出できない場合：バイナリが-Wl,--build-id等のオプションでビルドされているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1モジュール/回 |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 出力ファイルへの同時書き込みは非推奨
- ビルドシステムによりファイル単位で排他制御される想定

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | なし |
| 進捗ログ | N/A | なし |
| 終了ログ | N/A | なし |
| エラーログ | N/A | なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CMakeビルドプロセス |

## 備考

- set -euo pipefailにより、エラー発生時は即座に終了
- macOSのdwarfdumpはXcodeコマンドラインツールに含まれる
- Linuxのreadelfはbinutilsパッケージに含まれる
- Build IDは通常SHA-1ハッシュの20バイト、UUIDは16バイト
- Windows版（genmoduleindex.cmd）とは抽出方法が異なる（PE形式のタイムスタンプ＋イメージサイズを使用）
