# バッチ設計書 37-genmoduleindex.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるデバッグ用モジュールインデックスヘッダ生成スクリプト（Windows向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、Windows PE（Portable Executable）形式のネイティブバイナリモジュールからタイムスタンプとイメージサイズを抽出し、デバッグ用のモジュールインデックスヘッダファイルを生成するバッチ処理である。生成されたヘッダファイルは、DAC（Data Access Component）やSOS（Son of Strike）デバッガでモジュールを識別するために使用される。

**業務上の目的・背景**：.NET Runtimeのデバッグ機能（特にクロスプラットフォームデバッグ）では、ネイティブモジュールを一意に識別する必要がある。Windows PEファイルでは、COFFヘッダのタイムスタンプとオプショナルヘッダのイメージサイズの組み合わせがモジュールの一意識別子として使用される。本スクリプトは、これらの値を抽出してC言語のバイナリリテラル形式に変換したヘッダファイルを生成することで、デバッガがモジュールを正確に識別・マッチングできるようにする。これはDAC（Data Access Component）がクラッシュダンプやライブプロセスのデバッグ時にモジュールのバージョン整合性を確認するために必要である。

**バッチの実行タイミング**：ネイティブコンポーネント（CoreCLR、DAC等）のビルド後処理。ビルドされたPEバイナリからモジュールインデックスを抽出し、後続のビルドで使用するヘッダファイルを生成する。

**主要な処理内容**：
1. コマンドライン引数の検証（モジュールファイルパス、出力ヘッダファイルパス）
2. dumpbinでPEヘッダ情報を取得
3. "size of image"からイメージサイズを抽出（8桁16進数にパディング）
4. "time date"からタイムスタンプを抽出（8桁16進数にパディング）
5. バイナリリテラル形式でヘッダファイルに出力（リトルエンディアン）

**前後の処理との関連**：本スクリプトはCMakeビルドプロセスから呼び出される。生成されたヘッダファイルはDACやCoreClRのソースコードからインクルードされ、モジュールインデックス情報がランタイムに埋め込まれる。

**影響範囲**：指定された出力パスにヘッダファイルを生成。モジュールバイナリの読み取りのみで、変更は行わない。

## バッチ種別

ビルド補助 / コード生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 自動（CMakeビルドプロセス） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| モジュールファイルの存在 | ビルド済みのPE形式バイナリが存在すること |
| dumpbinの存在 | Visual StudioのdumpbinコマンドがPATHに存在すること |
| Visual Studio環境 | Visual Studio開発者コマンドプロンプトまたは環境設定済みであること |

### 実行可否判定

- 引数%1または%2が空の場合はUsageを表示して終了（exit /b 1）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 | string | Yes | - | モジュールバイナリファイルのパス（PEファイル） |
| %2 | string | Yes | - | 出力ヘッダファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| モジュールバイナリ | PE | ビルド済みのWindows DLLまたはEXE |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| %2（ヘッダファイル） | Cソース | バイナリリテラル形式のモジュールインデックス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 引数%2で指定 |
| 出力先 | 引数%2で指定されたパス |
| 文字コード | ASCII |
| 区切り文字 | カンマ |

### 出力形式

```c
0x08, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX, 0xXX,
```

- 最初の1バイト：固定値0x08（8バイトの識別子長）
- 2-5バイト目：タイムスタンプ（リトルエンディアン）
- 6-9バイト目：イメージサイズ（リトルエンディアン）

## 処理フロー

### 処理シーケンス

```
1. 引数検証
   └─ %1または%2が空の場合はUsage表示して終了
2. setlocalで環境変数ローカル化
3. イメージサイズ抽出
   └─ dumpbin /HEADERS %1 | findstr /c:"size of image"
   └─ for /fで最初のトークン（16進数値）を取得
   └─ 8桁にゼロパディング
4. タイムスタンプ抽出
   └─ dumpbin /HEADERS %1 | findstr /c:"time date"
   └─ for /fで最初のトークン（16進数値）を取得
   └─ 8桁にゼロパディング
5. ヘッダファイル出力
   └─ 長さプレフィックス0x08を出力
   └─ タイムスタンプをリトルエンディアンで出力
   └─ イメージサイズをリトルエンディアンで出力
6. endlocal・正常終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{%1または%2が空?}
    B -->|Yes| C[Usage表示・終了]
    B -->|No| D[setlocal]
    D --> E[dumpbin /HEADERS実行]
    E --> F[size of imageを検索]
    F --> G[イメージサイズ取得・パディング]
    G --> H[time dateを検索]
    H --> I[タイムスタンプ取得・パディング]
    I --> J[ヘッダファイル出力]
    J --> K[endlocal]
    K --> L[exit /b 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | %1または%2が空 | 正しい引数を指定して再実行 |
| N/A | ツールエラー | dumpbinが見つからない | Visual Studio開発者コマンドプロンプトを使用 |
| N/A | ファイルエラー | %1が存在しない | ファイルパスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- dumpbinが見つからない場合：Visual Studio開発者コマンドプロンプトから実行、またはvcvarsall.batで環境設定
- findstrで値が見つからない場合：PEファイルが正しい形式か確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1モジュール/回 |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 出力ファイルへの同時書き込みは非推奨
- ビルドシステムによりファイル単位で排他制御される想定

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | なし |
| 進捗ログ | N/A | なし |
| 終了ログ | N/A | なし |
| エラーログ | N/A | なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CMakeビルドプロセス |

## 備考

- dumpbinはVisual Studioに付属するPE解析ツール
- Windows PEファイルのモジュール識別は、タイムスタンプ＋イメージサイズの組み合わせ（PDB署名と同じ）
- Linux/macOS版（genmoduleindex.sh）とは抽出方法が異なる（Build ID/UUID vs タイムスタンプ＋サイズ）
- 出力はリトルエンディアン形式（Windows ABI準拠）
- 8桁へのゼロパディングは文字列操作（00000000%value%で先頭にゼロを追加し、末尾8文字を切り出し）で実装
