# バッチ設計書 39-copy_version_files.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるバージョンファイルコピースクリプト（Windows PowerShell向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、ネイティブコードビルドに必要なバージョン情報ファイル（_version.h、_version.c等）をソースディレクトリからビルド成果物ディレクトリにコピーするPowerShellバッチ処理である。特に_version.cファイルについては、現在のGitコミットIDを埋め込む処理を行い、ビルドされたバイナリにコミット情報を記録できるようにする。copy_version_files.shのWindows PowerShell版として同等の機能を提供する。

**業務上の目的・背景**：.NET Runtimeのネイティブバイナリには、トラブルシューティングやバージョン管理のためにバージョン情報が埋め込まれる。本スクリプトは、ビルド時にGitコミットIDを_version.cに埋め込むことで、ビルド成果物がどのコミットから生成されたかを追跡可能にする。これは、問題報告時のバージョン特定やCI/CDパイプラインでのビルドトレーサビリティに不可欠である。プレースホルダーファイルの更新判定機能により、不要な再コンパイルを防ぎビルド時間を短縮する。

**バッチの実行タイミング**：ネイティブコードのビルド前処理（Windows環境）。CMakeビルドプロセスの初期段階で呼び出され、バージョンファイルを適切な場所に配置する。

**主要な処理内容**：
1. $PSScriptRootからスクリプトディレクトリを取得
2. リポジトリルートのパス解決（スクリプトから3階層上）
3. _version.*ファイルをGet-ChildItemで走査
4. _version.cの特別処理
   - Gitコミットハッシュを取得
   - バージョン文字列を-replaceで置換
   - 既存ファイルとの比較（プレースホルダー判定）
   - 変更がある場合のみ更新
5. その他のファイル
   - 存在しない場合のみコピー

**前後の処理との関連**：本スクリプトはCMakeビルドプロセスから呼び出される。生成されたバージョンファイルはネイティブコードのコンパイル時にインクルードされ、バイナリにバージョン情報が埋め込まれる。

**影響範囲**：artifacts\obj\ディレクトリにバージョンファイルを配置。ソースファイルの変更は行わない。

## バッチ種別

ビルド補助 / ファイルコピー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 自動（CMakeビルドプロセス） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | PowerShell 5.0以降が利用可能であること |
| Gitリポジトリ | Gitコミットハッシュ取得のため（オプション、取得失敗時は"N/A"） |
| バージョンファイルテンプレートの存在 | eng\native\version\ディレクトリにテンプレートファイルが存在すること |
| artifacts\obj\ディレクトリ | 出力先ディレクトリが作成可能であること |

### 実行可否判定

- _version.*ファイルが存在しない場合はスキップ
- Gitコミットハッシュが取得できない場合は"N/A"を使用

## 入力仕様

### 入力パラメータ

本スクリプトは引数を受け取らない。パスは$PSScriptRootから自動解決される。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng\native\version\_version.c | Cソース | バージョン情報テンプレート |
| eng\native\version\_version.h | Cヘッダ | バージョン情報ヘッダテンプレート |
| .git\HEAD | Git参照 | 現在のコミットハッシュ取得用 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts\obj\_version.c | Cソース | コミットID埋め込み済みバージョンファイル |
| artifacts\obj\_version.h | Cヘッダ | バージョン情報ヘッダ（コピー） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | _version.c、_version.h等 |
| 出力先 | {リポジトリルート}\artifacts\obj\ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

### _version.cの出力形式

```c
static char sccsid[] __attribute__((used)) = "@(#)Version N/A @Commit: abc123def456...";
```

## 処理フロー

### 処理シーケンス

```
1. パス解決
   └─ $VersionFolder：$PSScriptRoot
   └─ $RepoRoot：Resolve-Pathで3階層上（TrimEnd("\")で末尾スラッシュ除去）
2. ファイル走査
   └─ Get-ChildItem -Filter "_version.*"でファイル一覧取得
3. ForEach-Objectでファイル処理
4. _version.cの処理
   └─ Gitコミットハッシュを取得（git rev-parse HEAD）
   └─ 取得失敗時は"N/A"を設定
   └─ -replaceでstatic行を置換してコミットIDを埋め込み
   └─ 出力先ファイルの存在確認（Test-Path）
   └─ プレースホルダーファイル判定（-matchで正規表現マッチ）
   └─ プレースホルダーかつ内容変更ありの場合のみ更新
5. その他ファイルの処理
   └─ Test-Pathで存在確認
   └─ 存在しない場合のみCopy-Itemでコピー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パス解決]
    B --> C[Get-ChildItem]
    C --> D{ファイルあり?}
    D -->|No| E[バッチ終了]
    D -->|Yes| F{_version.c?}
    F -->|Yes| G[Gitコミットハッシュ取得]
    G --> H{取得成功?}
    H -->|Yes| I[$commit設定]
    H -->|No| J[$commit = N/A]
    I --> K[-replaceで置換]
    J --> K
    K --> L{Test-Path 出力先?}
    L -->|Yes| M[Get-Content読み込み]
    L -->|No| N[$is_placeholder_file = $true]
    M --> O{-matchでプレースホルダー判定}
    O -->|Yes| P[$is_placeholder_file = $true]
    O -->|No| Q[$is_placeholder_file = $false]
    N --> R{内容変更あり?}
    P --> R
    Q --> R
    R -->|Yes かつ プレースホルダー| S[Set-Content出力]
    R -->|No または 非プレースホルダー| D
    S --> D
    F -->|No| T{Test-Path 出力先?}
    T -->|No| U[Copy-Item]
    T -->|Yes| D
    U --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | Git未初期化 | git rev-parse HEAD失敗 | "N/A"で継続 |
| N/A | ファイル読み取りエラー | テンプレートファイルが読めない | ファイル権限を確認 |
| N/A | ファイル書き込みエラー | 出力先に書き込めない | ディレクトリ権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- Gitコミットハッシュが取得できない場合："N/A"が埋め込まれて継続
- ファイルコピー失敗の場合：後続のビルドでコンパイルエラーとなる

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数ファイル |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 同一出力先への同時書き込みは非推奨
- ビルドシステムによりファイル単位で排他制御される想定

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | N/A | なし |
| 進捗ログ | N/A | なし |
| 終了ログ | N/A | なし |
| エラーログ | N/A | なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | N/A | N/A（暗黙的成功） |

## 備考

- $PSScriptRootでスクリプトディレクトリを自動取得
- Resolve-Pathでパスを正規化
- TrimEnd("\")でWindowsパスの末尾バックスラッシュを除去
- Get-Content | ForEach-Objectのパイプライン処理で行単位置換
- -matchで正規表現によるプレースホルダー判定
- Set-Contentでファイル出力
- Bash版（copy_version_files.sh）と同等の機能を提供
- 2>$nullでGitエラー出力を抑制
