# バッチ設計書 4-eng/build.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/build.ps1` - Windows向けメインビルドスクリプト（PowerShell）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Windows環境で.NET Runtimeプロジェクトのビルドを制御するメインスクリプトである。ルートの `build.cmd` から呼び出され、複数の構成・アーキテクチャでのビルドをサポートする。Visual Studioソリューション生成機能も提供し、IDE での開発を支援する。

**業務上の目的・背景**：Windowsは.NET開発の主要なプラットフォームであり、Visual StudioやMSBuildとの緊密な統合が求められる。このスクリプトは、複数のアーキテクチャや構成を一度に指定してビルドする機能、Visual Studioでのデバッグ用ソリューション生成機能を提供し、Windows開発者の生産性を向上させる。

**バッチの実行タイミング**：ルートの `build.cmd` から呼び出される。開発者による手動実行時やCI/CDパイプライン（Azure DevOps等）でのビルド時に使用される。

**主要な処理内容**：
1. コマンドライン引数の解析（PowerShellパラメータバインディング）
2. Visual Studio ソリューションの生成と起動（-vs オプション）
3. 複数構成/複数アーキテクチャでの反復ビルド
4. ブートストラップビルドの実行（オプション）
5. eng/common/build.ps1 への処理委譲

**前後の処理との関連**：ルートの `build.cmd` から呼び出され、`eng/common/build.ps1` を呼び出す。`eng/common/tools.ps1` を読み込んでSDK初期化等を行う。`eng/build.sh` のWindows版である。

**影響範囲**：ビルド成果物（バイナリ、パッケージ）、Visual Studioソリューション、テスト実行、パッケージング処理に影響する。

## バッチ種別

ビルド制御 / 構成管理 / IDE統合

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | build.cmd からの呼び出し / 手動実行 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境での実行が必要 |
| PowerShell | PowerShell 5.1以上が利用可能であること |
| Visual Studio | -vs オプション使用時はVisual Studioがインストールされていること |
| .NET SDK | プロジェクトで指定されたSDKバージョンが利用可能であること |

### 実行可否判定

スクリプトは常に実行可能。Visual Studio機能を使用する場合はIDEのインストールが必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -arch (-a) | string[] | No | ホストアーキテクチャ | ターゲットプラットフォーム（x86, x64, arm, arm64, wasm）、カンマ区切りで複数指定可 |
| -configuration (-c) | string[] | No | Debug | ビルド構成（Debug, Release, Checked）、カンマ区切りで複数指定可 |
| -os | string | No | なし | ターゲットOS（windows, linux, osx, android, browser, wasi） |
| -subset (-s) | string | No | なし | ビルド対象サブセット |
| -vs | string | No | なし | Visual Studioで開くソリューション名 |
| -restore (-r) | switch | No | false | 依存関係の復元 |
| -build (-b) | switch | No | false | ビルドの実行 |
| -test (-t) | switch | No | false | テストの実行 |
| -pack | switch | No | false | NuGetパッケージの作成 |
| -runtimeConfiguration (-rc) | string | No | なし | ランタイム構成 |
| -librariesConfiguration (-lc) | string | No | なし | ライブラリ構成 |
| -runtimeFlavor (-rf) | string | No | CoreCLR | ランタイムフレーバー（CoreCLR, Mono） |
| -ninja | switch | No | false | Ninjaビルドシステムの使用 |
| -msbuild | switch | No | false | MSBuildジェネレータの使用 |
| -bootstrap | switch | No | false | ブートストラップビルドの実行 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/tools.ps1 | PowerShellスクリプト | SDK初期化関数の提供 |
| TreatWarningsAsErrors | 環境変数 | 警告をエラーとして扱う設定 |
| artifacts/toolset/sdk.txt | テキストファイル | SDKパス情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| artifacts/bin | バイナリ | ビルド成果物 |
| artifacts/obj | オブジェクト | 中間ファイル、ソリューションファイル |
| artifacts/log | ログ | ビルドログ（binlog含む） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成、アーキテクチャ、サブセットに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. パラメータ解析
   └─ CmdletBinding によるPowerShellパラメータバインディング
2. ヘルプ表示判定
   └─ -help 指定時はヘルプを表示して終了
3. サブセット引数の処理
   └─ 最初の位置引数がサブセット指定かどうかを判定
4. Visual Studio モード判定
   └─ -vs 指定時はソリューション生成/起動
5. アクション判定
   └─ アクション未指定時は -restore -build をデフォルト設定
6. ブートストラップビルド（オプション）
   └─ -bootstrap 指定時、先行ビルドを実行
7. 構成/アーキテクチャごとのビルドループ
   └─ 各組み合わせで eng/common/build.ps1 を呼び出し
8. 結果の集計
   └─ 失敗したビルドがあればエラー終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{-help?}
    B -->|Yes| C[ヘルプ表示]
    C --> D[終了]
    B -->|No| E{サブセット引数?}
    E -->|Yes| F[subset変数設定]
    E -->|No| G[引数処理続行]
    F --> H{-vs指定?}
    G --> H
    H -->|Yes| I[ソリューション生成/VS起動]
    I --> D
    H -->|No| J{アクション指定?}
    J -->|No| K[-restore -build 設定]
    J -->|Yes| L[指定アクション使用]
    K --> M{Bootstrap?}
    L --> M
    M -->|Yes| N[Bootstrapビルド]
    N --> O[artifacts削除]
    O --> P[構成ループ開始]
    M -->|No| P
    P --> Q[アーキテクチャループ]
    Q --> R[eng/common/build.ps1呼出]
    R --> S{次の組み合わせ?}
    S -->|Yes| Q
    S -->|No| T{失敗あり?}
    T -->|Yes| U[エラー終了]
    T -->|No| D
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 無効なアーキテクチャ/OS/構成の指定 | ValidateSet で制限された値を使用 |
| 1 | ソリューションエラー | -vs 指定時にソリューションが見つからない | パスまたは名前を確認 |
| 1 | ビルドエラー | いずれかの構成/アーキテクチャでビルド失敗 | 失敗した組み合わせを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（手動リトライ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 失敗したビルドの構成/アーキテクチャの組み合わせを確認
2. バイナリログ（binlog）を確認して詳細なビルドエラーを特定
3. 必要に応じて `-verbosity detailed` で詳細ログを取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 構成 x アーキテクチャの組み合わせ数 |
| 目標処理時間 | サブセットと構成に依存 |
| メモリ使用量上限 | ビルド内容に依存 |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。複数の構成/アーキテクチャビルドは順次実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗、コンパイラ出力 |
| バイナリログ | -bl 指定時 | MSBuildの詳細ログ |
| 失敗ログ | ビルド失敗時 | 失敗した構成/アーキテクチャの一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| ビルド時間 | 構成による | CI/CDシステム |

## 備考

- 複数のアーキテクチャ/構成をカンマ区切りで指定可能（例: `-arch x64,arm64 -c Debug,Release`）
- `-vs` オプションでVisual Studioを起動する場合、DOTNET_ROOT環境変数が設定される
- `-ninja` オプションはWindowsではデフォルトのため、指定しても効果がない旨の警告が表示される
- `-msbuild` オプションでMSBuildジェネレータを使用可能だが、Browser/WASIビルドでは非対応
- ブートストラップビルドは単一の構成/アーキテクチャでのみ実行可能
- terminal logger は既知の問題（#97211）により無効化されている
- VSDebugger_ValidateDotnetDebugLibSignatures=0 でローカルビルドの署名検証エラーを回避
