# バッチ設計書 40-init-vs-env.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける Visual Studio開発者環境初期化スクリプト（Windows向け）の設計仕様を記載する。

### 本バッチの処理概要

本スクリプトは、Windows環境でのネイティブコードビルドに必要なVisual Studio開発者環境（Developer Command Prompt環境）を初期化するバッチ処理である。Visual Studioの検出、開発者コマンド環境の設定、VC++ビルド環境の初期化、およびCMakeパスの設定を行う。

**業務上の目的・背景**：.NET RuntimeのネイティブコードをWindowsでビルドするには、Visual Studio C++コンパイラ（MSVC）とその関連ツール（リンカ、ライブラリツール等）が必要である。これらのツールはVisual Studioのインストールディレクトリに配置されており、適切な環境変数設定が必要である。本スクリプトは、インストールされているVisual Studioを自動検出し、指定されたターゲットアーキテクチャ（x64、x86、ARM64等）向けのビルド環境を初期化することで、開発者が手動で環境設定を行う必要をなくす。クロスコンパイル（ARM64ホストからx64ビルド等）にも対応している。

**バッチの実行タイミング**：ネイティブコードのビルド開始前。build.cmdや他のビルドスクリプトから呼び出され、VC++ビルド環境を準備する。

**主要な処理内容**：
1. ターゲットアーキテクチャからVC++ビルドアーキテクチャを決定
2. Visual Studioの検出
   - 既にVisualStudioVersionが設定されている場合はスキップ
   - VSWhereを使用して最新のVSインストールを検出
3. VsDevCmd.batを呼び出してVisual Studio開発者環境を初期化
4. vcvarsall.batを呼び出してVC++ビルド環境を初期化（アーキテクチャ指定）
5. set-cmake-path.ps1を呼び出してCMakeパスを設定

**前後の処理との関連**：本スクリプトはビルド開始時に呼び出される。後続のCMakeやネイティブコンパイル処理で必要なコンパイラやツールが使用可能になる。set-cmake-path.ps1を呼び出してCMakePath環境変数を設定する。

**影響範囲**：環境変数（PATH、INCLUDE、LIB、VisualStudioVersion、VCINSTALLDIR、CMakePath等）を設定。ファイルシステムの変更は行わない。

## バッチ種別

環境設定 / ビルド前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動（開発者ビルド）/ 自動（CI/CDパイプライン） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio 2022以降 | C++コンポーネントがインストールされていること |
| VSWhere | Visual Studioインストーラディレクトリに存在すること |
| PowerShell | set-cmake-path.ps1の実行に必要 |

### 実行可否判定

- Visual Studioが検出できない場合はエラー終了（exit /b 1）
- vcvarsall.batが存在しない場合はエラー終了（exit /b 1）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %1 | string | No | - | ターゲットアーキテクチャ（x64, x86, arm64, wasm） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| vswhere.exe | 実行ファイル | Visual Studioインストール情報の取得 |
| VsDevCmd.bat | バッチファイル | Visual Studio開発者環境設定 |
| vcvarsall.bat | バッチファイル | VC++ビルド環境設定 |
| set-cmake-path.ps1 | PowerShell | CMakeパス設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 環境変数 | 文字列 | ビルドに必要な環境変数を設定 |

### 設定される主な環境変数

| 環境変数 | 説明 |
|---------|------|
| VisualStudioVersion | Visual Studioのバージョン |
| VCINSTALLDIR | VC++インストールディレクトリ |
| PATH | コンパイラ・リンカ等のパス追加 |
| INCLUDE | ヘッダファイルのパス |
| LIB | ライブラリファイルのパス |
| CMakePath | CMake実行ファイルのパス |

## 処理フロー

### 処理シーケンス

```
1. ビルドアーキテクチャ決定
   └─ PROCESSOR_ARCHITECTUREとターゲットアーキテクチャから__VCBuildArchを設定
   └─ ARM64ホスト：arm64_amd64/arm64_x86/arm64
   └─ x64ホスト：amd64/amd64_x86/amd64_arm64
2. Visual Studio検出
   └─ VisualStudioVersionが既に設定されていればスキップ
   └─ VSWhereで最新のVSインストールを検索
   └─ Common7\Toolsパスを取得
3. VsDevCmd.bat呼び出し
   └─ VSCMD_START_DIRで現在ディレクトリを保持
   └─ -no_logoオプションでロゴ非表示
4. VC++ビルド環境初期化（アーキテクチャ指定時のみ）
   └─ SkipVCEnvInitが設定されていればスキップ
   └─ vcvarsall.batを__VCBuildArchで呼び出し
5. CMakeパス設定
   └─ set-cmake-path.ps1を実行
   └─ 出力をfor /fで評価してCMakePathを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ビルドアーキテクチャ決定]
    B --> C{PROCESSOR_ARCHITECTURE?}
    C -->|ARM64| D[ARM64ホスト用設定]
    C -->|x64| E[x64ホスト用設定]
    D --> F{VisualStudioVersion設定済み?}
    E --> F
    F -->|Yes| G[VSDetectedへ]
    F -->|No| H[VSWhere存在確認]
    H --> I{VSWhere存在?}
    I -->|No| J[VSWhereMissingエラー]
    I -->|Yes| K[VSWhereでVS検索]
    K --> L{VS検出?}
    L -->|No| M[VSMissingエラー]
    L -->|Yes| N[VsDevCmd.bat呼び出し]
    G --> O[SetVCEnvironmentへ]
    N --> O
    O --> P{__VCBuildArch設定?}
    P -->|No| Q[正常終了]
    P -->|Yes| R{SkipVCEnvInit設定?}
    R -->|Yes| S[CMakeパス設定へ]
    R -->|No| T{vcvarsall.bat存在?}
    T -->|No| U[VSMissingエラー]
    T -->|Yes| V[vcvarsall.bat呼び出し]
    V --> W{成功?}
    W -->|No| X[エラー終了]
    W -->|Yes| S
    S --> Y[set-cmake-path.ps1実行]
    Y --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | VS未検出 | Visual Studioがインストールされていない | VS 2022以降をインストール |
| 1 | VSWhere未検出 | VSWhereが見つからない | Visual Studioインストーラを確認 |
| 1 | vcvarsall未検出 | VC++コンポーネントがない | Visual StudioでC++ワークロードを追加 |
| 1 | vcvarsall失敗 | vcvarsall.batがエラー | VSインストールを修復 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

- VS未検出エラー：Visual Studio 2022以降をインストール
- C++コンポーネント不足：Visual Studio InstallerでC++ワークロードを追加

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（環境変数設定のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルドセッション |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

- 環境変数設定のみのため、排他制御不要
- 同一プロセス内での複数回呼び出しは想定していない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | VS未検出時 | "Error: Visual Studio 2022 with C++ tools required..." |
| エラーログ | VSWhere未検出時 | "Error: vswhere could not be found..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | ビルドスクリプト |

## 備考

- VSWhereはVisual Studio 2017以降のインストーラに含まれる
- -prereleaseオプションでプレビュー版のVSも検出対象
- -requires Microsoft.VisualStudio.Component.VC.Tools.x86.x64でC++ツール必須条件
- SkipVCEnvInit環境変数で新しいMSVCバージョンのテストが可能
- VSCMD_START_DIRで作業ディレクトリを保持（VsDevCmd.batがcdする問題への対応）
- for /f "delims=" %%aでPowerShellスクリプトの出力を評価実行
- ARM64 Windowsからのクロスコンパイル（arm64_amd64等）をサポート
