# バッチ設計書 41-set-cmake-path.ps1

## 概要

本ドキュメントは、Windows環境でCMakeの実行パスを検出・設定するPowerShellスクリプト `eng/native/set-cmake-path.ps1` の設計を記述します。このスクリプトはネイティブコードビルドの前提条件となるCMakeツールの検出と設定を自動化します。

### 本バッチの処理概要

このバッチでは、Windows環境においてCMakeビルドツールのパスを自動検出し、バッチファイルから利用可能な形式で出力します。

**業務上の目的・背景**：.NET Runtimeプロジェクトには、CoreCLRやネイティブライブラリなど、C/C++で記述されたコンポーネントが含まれています。これらのビルドにはCMakeが必須であり、開発者やCIシステムが正しいバージョンのCMakeを使用できるよう、パスの自動検出が必要です。手動でのパス設定は煩雑でエラーを招きやすいため、本スクリプトで自動化しています。

**バッチの実行タイミング**：ネイティブコードのビルド前に実行されます。具体的には、`eng/native/init-vs-env.cmd`などのビルド初期化スクリプトから呼び出されます。

**主要な処理内容**：
1. PATH環境変数からcmake.exeを検索
2. PATH上に見つからない場合、Windowsレジストリからインストール先を検索
3. CMakeのバージョンを確認（最低3.16.4が必要）
4. バッチファイルで評価可能な形式でパスを出力

**前後の処理との関連**：`eng/native/init-vs-env.cmd`から呼び出され、出力された`set CMakePath=...`コマンドがバッチファイル内で評価されます。後続のネイティブビルドプロセスがこのパスを使用してCMakeを実行します。

**影響範囲**：Windowsプラットフォームでのネイティブコードビルドプロセス全体に影響します。CMakeが見つからないか、バージョンが古い場合はビルドが失敗します。

## バッチ種別

環境設定 / ツールチェーン構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ネイティブビルド初期化時に呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows環境 | PowerShellが実行可能なWindows環境であること |
| CMakeインストール | CMake 3.16.4以上がシステムにインストールされていること |

### 実行可否判定

CMakeがPATH上またはレジストリに登録されていない場合、エラーメッセージを出力して失敗します。バージョンが3.16.4未満の場合も同様に失敗します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 本スクリプトはパラメータを受け取りません |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PATH環境変数 | 文字列 | cmake.exeの検索パス |
| Windowsレジストリ | レジストリキー | HKLM:\SOFTWARE\Kitware\CMakeおよびHKLM:\SOFTWARE\Wow6432Node\Kitware\CMakeからInstallDir値を取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | `set CMakePath=<パス>`形式のコマンド、またはエラー時は`exit /b 1` |
| 標準エラー | テキスト | エラー時のメッセージ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わず、標準出力にバッチコマンド形式で結果を出力します。

| 項目 | 内容 |
|-----|------|
| 出力形式 | `set CMakePath=<cmake.exeのフルパス>` |
| エラー時出力 | `exit /b 1` |
| 文字コード | システムデフォルト |

## 処理フロー

### 処理シーケンス

```
1. LocateCMake関数でCMakeパスを検索
   └─ 1-1. Get-CommandでPATH上のcmake.exeを検索
   └─ 1-2. 見つからない場合、レジストリ(HKLM:\SOFTWARE\Kitware\CMake)を検索
   └─ 1-3. 32bit互換レジストリ(HKLM:\SOFTWARE\Wow6432Node\Kitware\CMake)も検索
   └─ 1-4. 見つかったInstallDirにbin\cmake.exeを付加してパスを構築
2. CMakeパスの存在確認
   └─ パスがnullの場合、エラーメッセージを出力
3. CMakeバージョンの取得と検証
   └─ `cmake --version`を実行してバージョン番号を抽出
   └─ バージョンが3.16.4未満の場合、エラーを出力
4. 結果の出力
   └─ 成功時: `set CMakePath=<パス>`を標準出力
   └─ 失敗時: エラーメッセージを標準エラーに、`exit /b 1`を標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[PATH上でcmake.exeを検索]
    B --> C{cmake.exe発見?}
    C -->|Yes| G[バージョン確認]
    C -->|No| D[レジストリからInstallDirを検索]
    D --> E{レジストリに存在?}
    E -->|Yes| F[bin\cmake.exeパスを構築]
    E -->|No| K[エラー: CMake未インストール]
    F --> G
    G --> H{バージョン >= 3.16.4?}
    H -->|Yes| I[set CMakePath=... を出力]
    H -->|No| J[エラー: バージョン不足]
    I --> L[正常終了]
    J --> M[exit /b 1 を出力]
    K --> M
    M --> N[異常終了]
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit /b 1 | CMake未検出 | PATHおよびレジストリにCMakeが見つからない | CMakeをhttps://cmake.org/download/からインストール |
| exit /b 1 | バージョン不足 | CMakeが3.16.4未満 | CMake 3.16.4以上をインストール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

CMakeが見つからない場合は、https://cmake.org/download/ からCMake 3.16.4以上をインストールしてください。インストール後、PATHに追加するか、Kitware社の標準インストーラを使用してレジストリに登録してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の検索処理 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | PowerShell標準使用量内 |

## 排他制御

本スクリプトは読み取り専用の処理であり、排他制御は不要です。複数プロセスからの同時実行が可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | CMake未検出時 | "CMake is a pre-requisite to build this repository but it was not found..." |
| エラーログ | バージョン不足時 | "CMake 3.16.4 or newer is required..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A（ローカル実行スクリプトのため監視対象外） |

## 備考

- このスクリプトはSet-StrictMode -Version 3を使用しており、厳格なエラー検出を行います
- 出力は`for /f`コマンドで評価することを想定したバッチコマンド形式です
- Visual Studio付属のCMakeも検出対象となりますが、PATH上にある場合のみです
