# バッチ設計書 44-build-android-rootfs.sh

## 概要

本ドキュメントは、Androidクロスコンパイル用のツールチェーンとsysrootを構築するBashスクリプト `eng/common/cross/build-android-rootfs.sh` の設計を記述します。このスクリプトは、Android NDKを使用して.NET RuntimeのAndroid向けビルド環境を自動構築します。

### 本バッチの処理概要

このバッチでは、Android NDKをダウンロードし、Termuxパッケージリポジトリから依存ライブラリを取得して、Androidクロスコンパイル用のsysrootを構築します。

**業務上の目的・背景**：.NET Runtime（特にMono）はAndroidプラットフォームをサポートしており、MAUIやXamarinアプリケーションの基盤となっています。Androidアプリは通常ARM64/ARMアーキテクチャで動作するため、x64 Linux開発マシンからクロスコンパイルを行う必要があります。本スクリプトはそのためのビルド環境を自動構築します。

**バッチの実行タイミング**：Android向けクロスコンパイルビルドの前に1回実行されます。構築されたsysrootは複数回のビルドで再利用可能です。

**主要な処理内容**：
1. Android NDKのダウンロードと展開
2. LLDBのダウンロードと展開
3. Termuxパッケージリポジトリから依存ライブラリを取得
4. ライブラリをsysrootに配置
5. android_platformファイルの生成（RID設定用）

**前後の処理との関連**：このスクリプトで構築されたsysrootは、環境変数`ROOTFS_DIR`を通じてビルドスクリプトに渡されます。ビルドスクリプトはこのsysrootを使用してAndroid向けにCoreCLR、ライブラリ、ホストをビルドします。

**影響範囲**：Android向けの.NET Runtimeビルド全体に影響します。sysrootの構築に失敗すると、Android向けビルドができません。

## バッチ種別

環境構築 / クロスコンパイル準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Android向けビルド環境構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行またはCI初回セットアップ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | Linux x86_64環境（NDKがLinux向け） |
| ネットワーク接続 | NDKとパッケージのダウンロードにインターネット接続が必要 |
| wget | ダウンロードツールとして必要 |
| unzip | NDK zipファイルの展開に必要 |
| dpkg | Termuxパッケージの展開に必要 |

### 実行可否判定

サポートされていないアーキテクチャを指定した場合、ヘルプを表示して終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BuildArch | string | No | arm64 | ターゲットアーキテクチャ（arm64, arm） |
| ApiLevel | int | No | 28 | ターゲットAndroid APIレベル |
| --ndk | string | No | r21 | Android NDKバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Android NDK | ZIP | dl.google.com/android/repositoryからダウンロード |
| LLDB | ZIP | dl.google.com/android/repositoryからダウンロード |
| Termuxパッケージ | deb | packages.termux.devからダウンロード |

### 環境変数

| 変数名 | 説明 |
|-------|------|
| TOOLCHAIN_DIR | ツールチェーン出力先（オプション） |
| NDK_DIR | 既存NDKのパス（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| sysrootディレクトリ | ファイルシステム | .tools/android-rootfs/android-ndk-{version}/sysroot |
| android_platformファイル | テキスト | RID設定ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| NDKディレクトリ | .tools/android-rootfs/android-ndk-{version} |
| LLDBディレクトリ | .tools/android-rootfs/lldb |
| android_platform | `RID=android.{ApiLevel}-{BuildArch}`形式 |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ アーキテクチャ、APIレベル、NDKバージョンの設定
2. NDKバージョンに応じたパス設定
   └─ r21/r22: -x86_64サフィックス、sysrootパス
   └─ 他: 新しいディレクトリ構造
3. NDKのダウンロードと展開（未存在時）
   └─ dl.google.comからzipをダウンロード
   └─ unzipで展開
4. LLDBのダウンロードと展開（未存在時）
   └─ lldb-2.3.3614996をダウンロード
5. Termuxパッケージのダウンロード
   └─ Packages一覧を取得
   └─ libicu, libandroid-glob, liblzma, krb5, opensslを検索
   └─ 各パッケージをダウンロードしてdpkg -xで展開
6. ライブラリのコピー
   └─ 展開したファイルをsysrootにコピー
7. android_platformファイルの生成
   └─ `RID=android.{ApiLevel}-{BuildArch}`を書き込み
8. ビルドコマンドの案内を出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[引数解析]
    B --> C{NDK存在?}
    C -->|No| D[NDKダウンロード・展開]
    C -->|Yes| E{LLDB存在?}
    D --> E
    E -->|No| F[LLDBダウンロード・展開]
    E -->|Yes| G[一時ディレクトリ作成]
    F --> G
    G --> H[Termux Packages一覧取得]
    H --> I[依存パッケージ検索・ダウンロード]
    I --> J[dpkg -xで展開]
    J --> K[sysrootにファイルコピー]
    K --> L[android_platform生成]
    L --> M[ビルドコマンド案内出力]
    M --> N[正常終了]
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 使用方法エラー | -h/-?/--help指定時 | ヘルプを参照 |
| ダウンロードエラー | NDKダウンロード失敗 | ネットワーク接続問題 | ネットワークを確認、再実行 |
| 展開エラー | unzip失敗 | ディスク容量不足等 | ディスク容量を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ネットワーク接続を確認
2. ディスク空き容量を確認（NDKは数GB必要）
3. 一時ディレクトリを削除して再実行
4. 既存NDKがある場合はNDK_DIR環境変数で指定

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のsysroot構築 |
| 目標処理時間 | 5-15分（ネットワーク速度による） |
| メモリ使用量上限 | 1GB以上推奨 |
| ディスク使用量 | 約5GB（NDK + LLDB + パッケージ） |

## 排他制御

同一出力ディレクトリへの同時実行は避けてください。NDKが既に存在する場合はダウンロードをスキップします。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 設定確認時 | Target API level, architecture, NDK version, location |
| 情報ログ | NDKダウンロード時 | "Downloading the NDK into {path}" |
| 情報ログ | LLDBダウンロード時 | "Downloading LLDB into {path}" |
| 情報ログ | パッケージダウンロード時 | "Working on: {package}" |
| 情報ログ | 完了時 | ビルドコマンドの案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | CI通知 |
| ディスク空き容量 | 10GB未満 | CI通知 |

## 備考

- サポートアーキテクチャ: arm64（デフォルト）、arm
- デフォルトAPIレベル: 28（glob(3)をサポートする最低バージョン）
- デフォルトNDKバージョン: r21
- 依存パッケージ: libicu, libandroid-glob, liblzma, krb5, openssl
- Termuxリポジトリ（termux-main-21）からパッケージを取得
- NDK r21/r22とそれ以降でディレクトリ構造が異なることに注意
- 最終的なビルドコマンドは`ROOTFS_DIR=$(realpath $__ToolchainDir/$__SysRoot) ./build.sh clr+libs+host --cross --arch $__BuildArch`
