# バッチ設計書 45-tizen-build-rootfs.sh

## 概要

本ドキュメントは、Tizenプラットフォーム向けクロスコンパイル用rootfsを構築するBashスクリプト `eng/common/cross/tizen-build-rootfs.sh` の設計を記述します。このスクリプトは、Samsung Tizenオペレーティングシステム向けの.NET Runtimeビルド環境を構築します。

### 本バッチの処理概要

このバッチでは、Tizenリポジトリからパッケージをダウンロードし、RPMパッケージを展開してrootfsを構築します。

**業務上の目的・背景**：Tizenは、主にSamsungのスマートTV、ウェアラブルデバイス、IoTデバイスで使用されるLinuxベースのオペレーティングシステムです。.NET RuntimeはTizen上で動作する.NETアプリケーション（Tizen .NET）の基盤となっています。本スクリプトはTizen向けクロスコンパイルに必要なsysrootを構築します。

**バッチの実行タイミング**：Tizen向けクロスコンパイルビルドの前に1回実行されます。build-rootfs.shから`--codename tizen`オプション指定時に呼び出されます。

**主要な処理内容**：
1. アーキテクチャに応じたTizenアーキテクチャ名への変換
2. tizen-fetch.shを呼び出してRPMパッケージをダウンロード
3. rpm2cpio + cpioでRPMパッケージを展開
4. シンボリックリンクの設定（asm-{arch}）
5. tizen.patchの適用
6. RISC-V64向けの追加シンボリックリンク修正

**前後の処理との関連**：build-rootfs.shからTizen指定時に呼び出されます。構築されたrootfsは環境変数`ROOTFS_DIR`経由でビルドスクリプトに渡されます。

**影響範囲**：Tizen向けの.NET Runtimeビルド全体に影響します。rootfsの構築に失敗すると、Tizen向けビルドができません。

## バッチ種別

環境構築 / クロスコンパイル準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Tizen向けビルド環境構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | build-rootfs.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | BashスクリプトとしてLinux環境が必要 |
| ROOTFS_DIR環境変数 | rootfs出力先パスの設定が必須 |
| rpm2cpio | RPMパッケージ展開に必要 |
| cpio | アーカイブ展開に必要 |
| patch | tizen.patch適用に必要 |
| ネットワーク接続 | Tizenリポジトリへのアクセスに必要 |

### 実行可否判定

ROOTFS_DIR環境変数が未設定の場合、エラーメッセージを出力して終了します。サポートされていないアーキテクチャを指定した場合も終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ARCH | string | Yes | なし | ターゲットアーキテクチャ（arm, armel, arm64, x86, x64, riscv64） |

### 環境変数

| 変数名 | 必須 | 説明 |
|-------|------|------|
| ROOTFS_DIR | Yes | rootfs出力先ディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Tizenリポジトリ | RPM | download.tizen.orgからダウンロード（tizen-fetch.sh経由） |
| tizen.patch | パッチ | アーキテクチャ別のパッチファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ROOTFS_DIR | ファイルシステム | Tizen rootfs |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ | ROOTFS_DIR環境変数で指定 |
| 内容 | /usr/include、/usr/lib、/lib等のTizenシステムファイル |
| シンボリックリンク | /usr/include/asm -> asm-{arch} |

## 処理フロー

### 処理シーケンス

```
1. アーキテクチャ名の変換
   └─ arm -> armv7hl
   └─ armel -> armv7l
   └─ arm64 -> aarch64
   └─ x86 -> i686
   └─ x64 -> x86_64
   └─ riscv64 -> riscv64
2. ROOTFS_DIR環境変数のチェック
   └─ 未設定なら終了
3. 一時ディレクトリの作成
   └─ $ROOTFS_DIR/tizen_tmp
4. tizen-fetch.shの呼び出し
   └─ RPMパッケージのダウンロード
5. RPMパッケージの展開
   └─ 各RPMに対してrpm2cpio | cpio -idm
6. 一時ディレクトリの削除
7. rootfsの設定
   └─ asm-{arch}へのシンボリックリンク作成
   └─ tizen.patchの適用
8. RISC-V64向け追加処理（該当時）
   └─ 壊れたシンボリックリンクの修正
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[アーキテクチャ名変換]
    B --> C{ROOTFS_DIR設定?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[一時ディレクトリ作成]
    E --> F[tizen-fetch.sh呼び出し]
    F --> G[RPMファイル一覧取得]
    G --> H[rpm2cpio + cpioで展開]
    H --> I[一時ディレクトリ削除]
    I --> J[asm-{arch}シンボリックリンク作成]
    J --> K[tizen.patch適用]
    K --> L{RISC-V64?}
    L -->|Yes| M[シンボリックリンク修正]
    L -->|No| N[正常終了]
    M --> N
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 未サポートアーキテクチャ | サポート外のARCHを指定 | サポートアーキテクチャを確認 |
| exit 1 | 環境変数未設定 | ROOTFS_DIRが未定義 | ROOTFS_DIR環境変数を設定 |
| パッチ適用失敗 | patch失敗 | パッチが適用できない | rootfsの状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ROOTFS_DIR環境変数の設定を確認
2. tizen-fetch.shのログを確認
3. Tizenリポジトリへのネットワーク接続を確認
4. rootfsディレクトリを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のrootfs構築 |
| 目標処理時間 | 5-15分（ネットワーク速度による） |
| メモリ使用量上限 | 1GB以上推奨 |
| ディスク使用量 | 500MB-1GB |

## 排他制御

同一ROOTFS_DIRへの同時実行は避けてください。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ダウンロード開始時 | ">>Start downloading files" |
| 情報ログ | ダウンロード完了時 | "<<Finish downloading files" |
| 情報ログ | rootfs構築開始時 | ">>Start constructing Tizen rootfs" |
| 情報ログ | rootfs構築完了時 | "<<Finish constructing Tizen rootfs" |
| 情報ログ | 設定開始時 | ">>Start configuring Tizen rootfs" |
| 情報ログ | 設定完了時 | "<<Finish configuring Tizen rootfs" |
| 情報ログ | RISC-V64修正時 | "Fixing broken symlinks in $PWD" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分超過 | CI通知 |

## 備考

- サポートアーキテクチャ: arm (armv7hl), armel (armv7l), arm64 (aarch64), x86 (i686), x64 (x86_64), riscv64
- VERBOSE=1を設定するとtizen-fetch.shで詳細出力が有効になる
- RISC-V64ではTizenパッケージに壊れたシンボリックリンクがあるため、追加の修正処理が必要
- tizen.patchはアーキテクチャ別ディレクトリ（eng/common/cross/{arch}/tizen/）に配置
- LINK_ARCHはasmシンボリックリンク用で、一部アーキテクチャでARCHと異なる（armel->arm, x64->x86, riscv64->riscv）
