# バッチ設計書 46-tizen-fetch.sh

## 概要

本ドキュメントは、Tizenリポジトリからパッケージをダウンロードするためのユーティリティスクリプト `eng/common/cross/tizen-fetch.sh` の設計を記述します。このスクリプトは、Tizenの公式リポジトリからRPMパッケージを取得し、チェックサム検証を行います。

### 本バッチの処理概要

このバッチでは、Tizenリポジトリのメタデータを解析し、指定されたパッケージのRPMファイルをダウンロードします。

**業務上の目的・背景**：Tizen向けクロスコンパイル環境を構築するために、Tizenシステムのライブラリとヘッダーファイルが必要です。これらはRPMパッケージとしてTizenの公式リポジトリで配布されています。本スクリプトは必要なパッケージを効率的にダウンロードし、整合性を検証します。

**バッチの実行タイミング**：tizen-build-rootfs.shから呼び出されます。Tizen向けrootfs構築の一部として実行されます。

**主要な処理内容**：
1. Tizenリポジトリのbuild.xmlからビルドターゲット情報を取得
2. repomd.xmlからパッケージメタデータのパスを取得
3. primary.xmlからパッケージのダウンロードパスとチェックサムを取得
4. 各パッケージをダウンロード
5. SHA256チェックサムで整合性を検証

**前後の処理との関連**：tizen-build-rootfs.shから呼び出され、ダウンロードしたRPMパッケージは同スクリプトによって展開されます。

**影響範囲**：Tizen向けrootfs構築に影響します。パッケージのダウンロードや検証に失敗すると、rootfs構築ができません。

## バッチ種別

データ取得 / パッケージダウンロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（Tizen rootfs構築時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | tizen-build-rootfs.shからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux環境 | BashスクリプトとしてLinux環境が必要 |
| curl | HTTPダウンロードに必要 |
| xmllint | XMLパース（libxml2のコマンドラインツール）に必要 |
| sha256sum | チェックサム検証に必要 |
| gunzip | gzipファイルの展開に必要 |
| ネットワーク接続 | download.tizen.orgへのアクセスに必要 |

### 実行可否判定

curl、xmllint、sha256sumのいずれかが存在しない場合、エラーメッセージを出力して終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| TMPDIR | string | Yes | なし | ダウンロード先一時ディレクトリ |
| TIZEN_ARCH | string | Yes | なし | Tizenアーキテクチャ名（armv7hl, armv7l, aarch64, i686, x86_64, riscv64） |

### 環境変数

| 変数名 | 必須 | 説明 |
|-------|------|------|
| VERBOSE | No | 1以上で詳細ログ出力（デフォルト: 0） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Tizen build.xml | XML | ビルドターゲット設定 |
| Tizen repomd.xml | XML | リポジトリメタデータ |
| Tizen primary.xml.gz | XML(gzip圧縮) | パッケージ一覧とチェックサム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| TMPDIR | RPMファイル | ダウンロードされたRPMパッケージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | RPM |
| 命名規則 | パッケージ名-バージョン.{arch}.rpm |
| 検証 | SHA256チェックサム検証済み |

## 処理フロー

### 処理シーケンス

```
1. 前提条件チェック
   └─ curl、xmllint、sha256sumの存在確認
2. 一時ディレクトリの設定
   └─ 引数またはデフォルト(./tizen_tmp)
3. Tizen-Baseリポジトリの初期化
   └─ build.xmlからターゲットパスを取得
   └─ repomd.xmlからprimary.xmlのパスを取得
   └─ primary.xml.gzをダウンロードして展開
4. 共通パッケージのダウンロード
   └─ gcc, gcc-devel-static, glibc, glibc-devel, libicu等
5. CoreCLRパッケージのダウンロード
   └─ libgcc, libstdc++, libunwind, lttng-ust等
6. CoreFXパッケージのダウンロード
   └─ libcom_err, zlib, libopenssl11, krb5等
7. Tizen-Unifiedリポジトリの初期化
   └─ 同様の手順でprimary.xmlを取得
8. 追加パッケージのダウンロード
   └─ gssdp, tizen-release
9. 各パッケージについて
   └─ XPathでダウンロードパスを取得
   └─ XPathでチェックサムを取得
   └─ curlでダウンロード
   └─ sha256sumで検証
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B{curl/xmllint/sha256sum存在?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[一時ディレクトリ設定]
    D --> E[Tizen-Base初期化]
    E --> F[build.xmlダウンロード]
    F --> G[repomd.xmlダウンロード]
    G --> H[primary.xml.gzダウンロード・展開]
    H --> I[共通パッケージダウンロード]
    I --> J[CoreCLRパッケージダウンロード]
    J --> K{RISC-V64?}
    K -->|No| L[LLDBパッケージダウンロード]
    K -->|Yes| M[CoreFXパッケージダウンロード]
    L --> M
    M --> N[Tizen-Unified初期化]
    N --> O[追加パッケージダウンロード]
    O --> P[正常終了]
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 前提条件エラー | curl/xmllint/sha256sumが未インストール | 必要なツールをインストール |
| exit 1 | XPathエラー | XMLからターゲットが見つからない | リポジトリ構造の変更を確認 |
| exit 1 | チェックサムエラー | SHA256チェックサム不一致 | ダウンロードを再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（curl内部のリトライに依存） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ネットワーク接続を確認
2. download.tizen.orgの可用性を確認
3. 必要なツール（curl、xmllint、sha256sum）がインストールされているか確認
4. VERBOSE=1を設定して詳細ログを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約20-30パッケージ |
| 目標処理時間 | 3-10分（ネットワーク速度による） |
| メモリ使用量上限 | 512MB以上推奨 |
| ディスク使用量 | 200-500MB |

## 排他制御

同一一時ディレクトリへの同時実行は避けてください。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 初期化時（VERBOSE>=1） | "Initialize TARGET={target}, PROFILE={profile}" |
| 情報ログ | パッケージ取得時（VERBOSE>=1） | "Fetching... {package}" |
| デバッグログ | ダウンロード時（VERBOSE>=2） | URLとパス情報 |
| エラーログ | 前提条件エラー時 | "Require '{tool}' Aborting." |
| エラーログ | XPathエラー時 | "Can not find target from {file}" |
| エラーログ | チェックサムエラー時 | "Fail to fetch {url} to {path}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 20分超過 | CI通知 |
| チェックサムエラー | 1件以上 | CI通知 |

## 備考

- リポジトリベースURL: http://download.tizen.org/snapshots/TIZEN/Tizen
- Tizen-Baseリポジトリ: 基本システムパッケージ（gcc, glibc, icu等）
- Tizen-Unifiedリポジトリ: 追加パッケージ（gssdp, tizen-release）
- RISC-V64ではLLDBパッケージをスキップ（未対応のため）
- ダウンロードするパッケージ:
  - 共通: gcc, gcc-devel-static, glibc, glibc-devel, libicu, libicu-devel, libatomic, linux-glibc-devel, keyutils, keyutils-devel, libkeyutils
  - CoreCLR: libgcc, libstdc++, libstdc++-devel, libunwind, libunwind-devel, lttng-ust-devel, lttng-ust, userspace-rcu-devel, userspace-rcu
  - LLDB: lldb, lldb-devel（RISC-V64以外）
  - CoreFX: libcom_err, libcom_err-devel, zlib, zlib-devel, libopenssl11, libopenssl1.1-devel, krb5, krb5-devel
  - Unified: gssdp, gssdp-devel, tizen-release
- 色付きログ出力対応（青: 情報、緑: デバッグ、赤: エラー）
