# バッチ設計書 49-msbuild.sh

## 概要

本ドキュメントは、Linux/macOS環境でMSBuildを実行するためのラッパースクリプト `eng/common/msbuild.sh` の設計を記述します。このスクリプトは、tools.shの機能を活用して、適切な引数でdotnet msbuildを実行します。

### 本バッチの処理概要

このバッチでは、tools.shをsourceし、コマンドライン引数を解析した後、MSBuild関数を呼び出してビルドを実行します。

**業務上の目的・背景**：.NET Runtimeプロジェクトでは、多くのビルドタスクがMSBuildを使用して実行されます。各ビルドスクリプトで個別にMSBuild呼び出しを実装すると、コードの重複や設定の不整合が発生しやすくなります。本スクリプトは、MSBuild実行のための標準化されたエントリポイントを提供し、tools.shの共通機能（SDKインストール、ロギング、エラー処理）を活用します。

**バッチの実行タイミング**：任意のMSBuildタスクを実行する際に使用されます。他のスクリプトから呼び出されるか、直接実行されます。

**主要な処理内容**：
1. コマンドライン引数の解析（verbosity、warn_as_error、node_reuse、ci、prepare_machine等）
2. tools.shのsource（共通関数のインポート）
3. CI時のnode_reuse無効化
4. MSBuild関数の呼び出し
5. 正常終了処理

**前後の処理との関連**：tools.shに依存しています。ビルドスクリプトや直接実行で使用されます。

**影響範囲**：MSBuildを使用する全てのビルドタスクに影響します。

## バッチ種別

ビルド実行 / MSBuildラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行または他スクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS環境 | Bash実行環境 |
| tools.sh | 同ディレクトリにtools.shが存在すること |
| .NET SDK | tools.shによって初期化される |

### 実行可否判定

tools.shのsourceに失敗した場合、または.NET SDKの初期化に失敗した場合は実行できません。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --verbosity | string | No | minimal | MSBuild詳細度（q[uiet], m[inimal], n[ormal], d[etailed], diag[nostic]） |
| --warnaserror | bool | No | true | 警告をエラーとして扱う |
| --nodereuse | bool | No | true | MSBuildノードを再利用する（CI時はfalse） |
| --ci | flag | No | false | CIモードを有効化 |
| --preparemachine | flag | No | false | マシン準備/クリーンアップを実行 |
| その他 | - | No | - | MSBuildに直接渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tools.sh | Bash | 共通ビルド関数ライブラリ |
| プロジェクトファイル | MSBuild | 追加引数として指定されたプロジェクト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | MSBuildの出力 |
| artifacts/log/ | binlog | バイナリログ（有効時） |

### 終了コード

| コード | 説明 |
|-------|------|
| 0 | 正常終了 |
| 非0 | MSBuildエラー |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ シンボリックリンクを解決してscriptrootを取得
2. デフォルト値の設定
   └─ verbosity='minimal'
   └─ warn_as_error=true
   └─ node_reuse=true
   └─ prepare_machine=false
3. 引数解析ループ
   └─ --verbosity: verbosity変数に設定
   └─ --warnaserror: warn_as_error変数に設定
   └─ --nodereuse: node_reuse変数に設定
   └─ --ci: ci=trueを設定
   └─ --preparemachine: prepare_machine=trueを設定
   └─ その他: extra_argsに追加
4. tools.shのsource
5. CI時のnode_reuse無効化
   └─ ci=trueならnode_reuse=false
6. MSBuild関数呼び出し
   └─ extra_argsを渡して実行
7. ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[スクリプトパス解決]
    B --> C[デフォルト値設定]
    C --> D[引数解析ループ]
    D --> E{引数あり?}
    E -->|Yes| F{引数種別}
    F -->|--verbosity| G[verbosity設定]
    F -->|--warnaserror| H[warn_as_error設定]
    F -->|--nodereuse| I[node_reuse設定]
    F -->|--ci| J[ci=true]
    F -->|--preparemachine| K[prepare_machine=true]
    F -->|その他| L[extra_argsに追加]
    G --> D
    H --> D
    I --> D
    J --> D
    K --> D
    L --> D
    E -->|No| M[tools.shをsource]
    M --> N{ci=true?}
    N -->|Yes| O[node_reuse=false]
    N -->|No| P[MSBuild実行]
    O --> P
    P --> Q[ExitWithExitCode 0]
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | MSBuildエラー | ビルド失敗 | ビルドログを確認 |
| 非0 | SDK初期化エラー | tools.shの処理失敗 | ネットワーク、global.jsonを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（tools.sh内部でSDKダウンロードはリトライ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. ビルドログ（binlog）を確認
2. tools.shのエラーメッセージを確認
3. ネットワーク接続を確認
4. --verbosity detailedまたはdiagで詳細ログを取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のMSBuild実行 |
| 目標処理時間 | ビルド内容による |
| メモリ使用量上限 | MSBuildとビルド内容による |

## 排他制御

node_reuseがtrueの場合、MSBuildノードが共有されます。CI環境ではnode_reuseがfalseに強制されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| MSBuildログ | ビルド中 | verbosityレベルに応じた詳細度 |
| バイナリログ | ビルド完了時 | 完全なビルドログ（CI時） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド失敗 | 1件以上 | CI通知 |

## 備考

- このスクリプトは薄いラッパーで、主要なロジックはtools.shに含まれています
- シンボリックリンク解決処理により、任意のディレクトリから実行可能
- 引数の大文字小文字は区別されません（lowerI変数で小文字化）
- CI時はnode_reuseが強制的にfalseになります（決定論的ビルドのため）
- ExitWithExitCode 0は、MSBuild関数内でエラー処理が行われるため、ここに到達した時点で成功を意味します
