# バッチ設計書 5-eng/common/build.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/common/build.sh` - 共通ビルドスクリプト（Linux/macOS）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Arcadeビルドインフラストラクチャの共通ビルドスクリプトであり、restore、build、test、pack、publishアクションを実行する。source-build（ソースからのビルド）およびproduct-build（製品ビルド）モードをサポートし、.NET SDKの初期化からMSBuildの実行までを一貫して管理する。

**業務上の目的・背景**：.NET関連の複数のリポジトリ（runtime、aspnetcore、sdk等）で共通のビルドインフラストラクチャを提供するため、Arcadeフレームワークが開発された。このスクリプトはArcadeの中核コンポーネントであり、すべてのビルドアクションを統一されたインターフェースで提供する。

**バッチの実行タイミング**：`eng/build.sh` から呼び出される。CI/CDパイプラインやローカルビルドで使用される。source-buildモードはLinuxディストリビューションでの.NETビルドに使用される。

**主要な処理内容**：
1. コマンドライン引数の解析（restore, build, test, pack, publish等）
2. ツールセットの初期化（.NET SDKのインストールと設定）
3. カスタムツールセットの読み込み（restore-toolset.shがある場合）
4. MSBuildによるビルドの実行
5. クリーン処理（--clean指定時）

**前後の処理との関連**：`eng/build.sh` から呼び出され、`eng/common/tools.sh` を読み込んでSDK初期化を行う。カスタマイズ用に `eng/restore-toolset.sh` を読み込む。

**影響範囲**：プロジェクト全体のビルドプロセス、NuGetパッケージの作成、テスト実行、成果物の公開に影響する。

## バッチ種別

ビルド実行 / ツールセット管理 / Arcadeインフラ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | eng/build.sh からの呼び出し / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bashシェル | Bash互換シェルが利用可能であること |
| .NET SDK | 自動的にインストールされる（tools.shによる） |
| ネットワーク接続 | SDKダウンロードやNuGetパッケージ復元に必要 |
| eng/common/tools.sh | 共通ツール関数が存在すること |

### 実行可否判定

スクリプトは常に実行可能。`--clean` オプション指定時はartifactsディレクトリを削除して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --configuration (-c) | string | No | Debug | ビルド構成（Debug, Release） |
| --verbosity (-v) | string | No | minimal | MSBuild詳細度（q, m, n, d, diag） |
| --binaryLog (-bl) | flag | No | false | バイナリログ出力 |
| --restore (-r) | flag | No | false | 依存関係の復元 |
| --build (-b) | flag | No | false | ビルドの実行 |
| --rebuild | flag | No | false | リビルドの実行 |
| --test (-t) | flag | No | false | 単体テストの実行 |
| --integrationTest | flag | No | false | 統合テストの実行 |
| --performanceTest | flag | No | false | パフォーマンステストの実行 |
| --pack | flag | No | false | NuGetパッケージの作成 |
| --sign | flag | No | false | 成果物の署名 |
| --publish | flag | No | false | 成果物の公開 |
| --clean | flag | No | false | artifactsディレクトリの削除 |
| --sourceBuild (-sb) | flag | No | false | ソースビルドモード |
| --productBuild (-pb) | flag | No | false | 製品ビルドモード |
| --ci | flag | No | false | CI環境での実行 |
| --prepareMachine | flag | No | false | マシン準備モード |
| --projects | string | No | なし | ビルド対象プロジェクト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/tools.sh | シェルスクリプト | SDK初期化、MSBuild関数の提供 |
| eng/restore-toolset.sh | シェルスクリプト | カスタムツールセット初期化（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| artifacts/ | ディレクトリ | ビルド成果物 |
| artifacts/log/Build.binlog | バイナリ | MSBuildバイナリログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成とアクションに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプト初期化
   └─ set -u -e でエラー時停止
2. 変数初期化
   └─ 各フラグを false に初期化
3. コマンドライン引数解析
   └─ while ループで引数を処理
4. 構成のデフォルト設定
   └─ source_build時はRelease、それ以外はDebug
5. CI環境設定
   └─ CI時はbinary_log有効、node_reuse無効
6. tools.sh の読み込み
   └─ InitializeToolset等の関数を定義
7. クリーン処理（--clean時）
   └─ artifacts_dirを削除して終了
8. ネイティブツール初期化（--restore時）
   └─ InitializeNativeTools呼び出し
9. Build関数実行
   └─ ツールセット初期化、MSBuild呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[変数初期化]
    B --> C[引数解析ループ]
    C --> D{--clean?}
    D -->|Yes| E[artifacts削除]
    E --> F[終了]
    D -->|No| G{構成指定あり?}
    G -->|No| H{source_build?}
    H -->|Yes| I[構成をReleaseに]
    H -->|No| J[構成をDebugに]
    G -->|Yes| K[指定構成を使用]
    I --> L{CI?}
    J --> L
    K --> L
    L -->|Yes| M[binary_log有効化, node_reuse無効化]
    L -->|No| N[tools.sh読み込み]
    M --> N
    N --> O{--restore?}
    O -->|Yes| P[InitializeNativeTools]
    O -->|No| Q[Build関数呼び出し]
    P --> Q
    Q --> R[InitializeToolset]
    R --> S[InitializeCustomToolset]
    S --> T[MSBuild実行]
    T --> U[ExitWithExitCode 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | MSBuildがエラー終了 | ログを確認して問題を修正 |
| 非0 | 復元エラー | NuGetパッケージの復元に失敗 | ネットワーク接続とフィードを確認 |
| 非0 | テストエラー | テストが失敗 | テスト結果を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. `set -e` によりエラー発生時に停止するため、エラーメッセージを確認
2. `-bl` オプションでバイナリログを有効にして詳細を確認
3. CI環境では自動的にバイナリログが有効

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド実行 |
| 目標処理時間 | プロジェクトサイズに依存 |
| メモリ使用量上限 | プロジェクトサイズに依存 |

## 排他制御

node_reuseオプションにより、MSBuildノードの再利用を制御。CI環境ではデフォルトで無効にされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗 |
| バイナリログ | -bl指定時/CI | MSBuildの詳細ログ |
| パイプラインログ | CI時 | Azure Pipelines形式のログ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| ビルド時間 | プロジェクトによる | CI/CDシステム |

## 備考

- `set -u` により未定義変数参照でエラー、`set -e` によりコマンドエラーで終了
- `--sourceBuild` モードでは自動的に `--restore --build --pack` が有効になり、構成がReleaseに設定される
- `--productBuild` モードはVMR（Virtual Monolithic Repository）でのビルドに使用される
- CI環境（`--ci`）では自動的にバイナリログが有効になり、MSBuildノードの再利用が無効になる
- カスタムツールセット初期化用に `eng/restore-toolset.sh` を読み込む仕組みがある
- ExitWithExitCode関数により適切な終了コードが返される
