# バッチ設計書 50-sdk-task.sh

## 概要

本ドキュメントは、Arcade SDKタスクを実行するためのLinux/macOS向けラッパースクリプト `eng/common/sdk-task.sh` の設計を記述します。このスクリプトは、Arcade SDKパッケージに含まれるSdkTasksディレクトリ内のプロジェクトを実行します。

### 本バッチの処理概要

このバッチでは、tools.shをsourceし、指定されたArcade SDKタスクプロジェクトをMSBuildで実行します。

**業務上の目的・背景**：.NET Runtimeプロジェクトでは、Arcade SDKを使用して共通のビルドタスクを管理しています。SDKタスクは、パッケージ署名、マニフェスト生成、NuGetパッケージ公開などの特定の処理を行います。本スクリプトは、これらのSDKタスクを一貫した方法で実行するためのエントリポイントを提供します。

**バッチの実行タイミング**：CI/CDパイプラインや手動で、特定のSDKタスクを実行する際に使用されます。

**主要な処理内容**：
1. コマンドライン引数の解析（task、restore、verbosity等）
2. tools.shのsource（共通関数のインポート）
3. InitializeToolsetの呼び出し
4. タスクプロジェクトの存在確認
5. Restoreの実行（オプション）
6. Executeターゲットの実行

**前後の処理との関連**：tools.shに依存しています。Arcade SDKパッケージがインストールされている必要があります。

**影響範囲**：指定されたSDKタスクの実行に影響します。

## バッチ種別

SDKタスク実行 / Arcade SDKラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDパイプラインまたは手動） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | CI/CDパイプラインまたは手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS環境 | Bash実行環境 |
| tools.sh | 同ディレクトリにtools.shが存在すること |
| Arcade SDK | InitializeToolsetでArcade SDKがインストールされること |
| .NET SDK | tools.shによって初期化される |

### 実行可否判定

- `--task`パラメータが指定されていない場合、エラーで終了
- 指定されたタスクプロジェクトが存在しない場合、エラーで終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --task | string | Yes | - | 実行するArcade SDKタスク名 |
| --restore | flag | No | false | 依存関係をリストアする |
| --verbosity | string | No | minimal | MSBuild詳細度（q[uiet], m[inimal], n[ormal], d[etailed], diag[nostic]） |
| --excludeCIBinarylog / --nobl | flag | No | false | バイナリログを出力しない |
| --noWarnAsError | flag | No | false | 警告をエラーとして扱わない |
| --help | flag | No | false | ヘルプを表示して終了 |
| その他 | - | No | - | MSBuildに直接渡される引数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| tools.sh | Bash | 共通ビルド関数ライブラリ |
| Arcade SDKタスクプロジェクト | MSBuild | SdkTasksディレクトリ内のプロジェクトファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | タスクの出力 |
| artifacts/log/ | binlog | バイナリログ（{task}.binlog、{task}.Restore.binlog） |
| artifacts/toolset/{task}/ | ディレクトリ | 中間出力ファイル |

### 終了コード

| コード | 説明 |
|-------|------|
| 0 | 正常終了 |
| 1 | タスク未指定またはタスク不明 |
| 非0 | MSBuildエラー |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ シンボリックリンクを解決してscriptrootを取得
2. デフォルト値の設定
   └─ binary_log=true
   └─ configuration='Debug'
   └─ verbosity='minimal'
   └─ restore=false
   └─ warnAsError=true
3. 引数解析ループ
   └─ --task: task変数に設定
   └─ --restore: restore=trueを設定
   └─ --verbosity: verbosity変数に設定
   └─ --excludeCIBinarylog/--nobl: binary_log=false
   └─ --noWarnAsError: warnAsError=false
   └─ --help: help=trueを設定
   └─ その他: propertiesに追加
4. ci=true設定（強制）
5. ヘルプ表示判定
   └─ help=trueならshow_usageを表示して終了
6. tools.shのsource
7. InitializeToolset呼び出し
8. タスク指定確認
   └─ 未指定ならエラー終了
9. タスクプロジェクト取得
   └─ GetSdkTaskProject関数を呼び出し
   └─ 存在しなければエラー終了
10. Restore実行（オプション）
    └─ restore=trueならBuild "Restore"
11. Execute実行
    └─ Build "Execute"
12. ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[スクリプトパス解決]
    B --> C[デフォルト値設定]
    C --> D[引数解析ループ]
    D --> E{引数あり?}
    E -->|Yes| F{引数種別}
    F -->|--task| G[task設定]
    F -->|--restore| H[restore=true]
    F -->|--verbosity| I[verbosity設定]
    F -->|--nobl| J[binary_log=false]
    F -->|--noWarnAsError| K[warnAsError=false]
    F -->|--help| L[help=true]
    F -->|その他| M[propertiesに追加]
    G --> D
    H --> D
    I --> D
    J --> D
    K --> D
    L --> D
    M --> D
    E -->|No| N[ci=true設定]
    N --> O{help=true?}
    O -->|Yes| P[show_usage]
    P --> Q[exit 0]
    O -->|No| R[tools.shをsource]
    R --> S[InitializeToolset]
    S --> T{task指定あり?}
    T -->|No| U[エラー: MissingTask]
    U --> V[ExitWithExitCode 1]
    T -->|Yes| W[GetSdkTaskProject]
    W --> X{プロジェクト存在?}
    X -->|No| Y[エラー: UnknownTask]
    Y --> V
    X -->|Yes| Z{restore=true?}
    Z -->|Yes| AA[Build Restore]
    AA --> AB[Build Execute]
    Z -->|No| AB
    AB --> AC[ExitWithExitCode 0]
```

### Build関数の詳細

```
Build(target):
1. log_suffixを決定
   └─ target != "Execute" なら ".{target}"
2. バイナリログパスを設定
   └─ $log_dir/$task$log_suffix.binlog
3. binaryLogArg設定
   └─ binary_log=true なら "/bl:$log"
4. output_pathを設定
   └─ $toolset_dir/$task/
5. MSBuild実行
   └─ $taskProject
   └─ /t:$target
   └─ /p:Configuration=$configuration
   └─ /p:RepoRoot=$repo_root
   └─ /p:BaseIntermediateOutputPath=$output_path
   └─ /v:$verbosity
   └─ $properties
```

## データベース操作仕様

本スクリプトはデータベース操作を行いません。

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | MissingTask | --taskパラメータ未指定 | --taskでタスク名を指定 |
| 1 | UnknownTask | 指定タスクが存在しない | タスク名を確認、Arcade SDKバージョンを確認 |
| 非0 | MSBuildエラー | ビルド/タスク実行失敗 | ビルドログを確認 |
| 非0 | SDK初期化エラー | tools.shの処理失敗 | ネットワーク、global.jsonを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（tools.sh内部でSDKダウンロードはリトライ） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認（MissingTask/UnknownTask）
2. ビルドログ（binlog）を確認
3. タスク名が正しいか確認
4. Arcade SDKのバージョンとタスクの互換性を確認
5. --verbosity detailedまたはdiagで詳細ログを取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のタスク実行 |
| 目標処理時間 | タスク内容による |
| メモリ使用量上限 | MSBuildとタスク内容による |

## 排他制御

同一タスクの並列実行は想定されていません。BaseIntermediateOutputPathが同一になるため、並列実行時は競合する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| MSBuildログ | タスク実行中 | verbosityレベルに応じた詳細度 |
| バイナリログ | タスク完了時 | {task}.binlog、{task}.Restore.binlog |
| パイプラインエラー | エラー時 | Write-PipelineTelemetryErrorによるCI向けエラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| タスク失敗 | 1件以上 | CI通知 |

## 備考

- ci=trueが強制的に設定されます（行93）
- binary_logのデフォルト値はtrue（CI向け）
- --excludeCIBinarylogと--noblは同じ機能（短縮形）
- タスクプロジェクトはGetSdkTaskProject関数で取得（Arcade SDKのSdkTasksディレクトリ内）
- Restoreターゲットは--restoreオプション指定時のみ実行
- Executeターゲットは常に実行される
- 引数の大文字小文字は区別されません（lowerI変数で小文字化）
- Build関数はRestore/Execute両方で使用され、ログファイル名にターゲット名を含める（Executeは省略）
- propertiesに追加された引数はMSBuildに直接渡される
