# バッチ設計書 51-sdk-task.ps1

## 概要

本ドキュメントは、Windows環境でArcade SDKタスクを実行するためのPowerShellスクリプト `eng/common/sdk-task.ps1` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、.NETプロジェクトのビルドインフラストラクチャであるArcade SDKに含まれるタスク（SdkTasksディレクトリ内のプロジェクト）を実行するためのエントリーポイントスクリプトです。パッケージング、署名、発行などのCI/CD関連タスクを統一的なインターフェースで実行できます。

**業務上の目的・背景**：.NET Runtimeプロジェクトでは、NuGetパッケージの作成、コード署名、シンボルパッケージの生成など、多岐にわたるビルド後処理が必要です。これらの処理を個別に実装・管理するのではなく、Arcade SDKが提供する標準化されたタスクとして一元管理することで、保守性の向上とCI/CDパイプラインの簡素化を実現します。

**バッチの実行タイミング**：主にCI/CDパイプラインの一部として実行されます。ビルド完了後のパッケージング処理、署名処理、公開処理などの各フェーズで呼び出されます。手動実行も可能ですが、通常はAzure DevOpsパイプラインから自動実行されます。

**主要な処理内容**：
1. コマンドライン引数の解析と検証（タスク名、構成、verbosityなど）
2. tools.ps1の読み込みによる共通関数の初期化
3. MSBuildエンジンの選択と初期化（dotnet/vs/xcopy-msbuild）
4. 指定されたSDKタスクプロジェクトの検索と検証
5. 必要に応じたRestore処理の実行
6. SDKタスクのExecuteターゲットの実行

**前後の処理との関連**：このスクリプトは `eng/common/tools.ps1` に依存しており、dotnet CLIの初期化やMSBuildの実行機能を利用します。実行されるタスクは、Arcade SDKパッケージ内のSdkTasksディレクトリに存在するMSBuildプロジェクトです。

**影響範囲**：ビルド成果物（NuGetパッケージ、署名済みバイナリ、シンボルパッケージなど）の生成に直接関係します。CI/CD環境での自動ビルド・公開プロセス全体に影響を与えます。

## バッチ種別

CI/CDタスク実行 / ビルド後処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDパイプラインの一部） |
| 実行時刻 | パイプライン定義による |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | PowerShell実行環境が必要 |
| .NET SDK | global.jsonで指定されたバージョンのSDKがインストールされていること |
| Arcade SDK | 指定されたタスクがArcade SDKに含まれていること |

### 実行可否判定

タスク名（-task パラメータ）が指定されていない場合はエラー終了します。指定されたタスクに対応するプロジェクトファイルが存在しない場合もエラー終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| configuration | string | No | Debug | ビルド構成（Debug/Release） |
| task | string | Yes | - | 実行するArcadeタスク名 |
| verbosity | string | No | minimal | MSBuild出力レベル（q/m/n/d/diag） |
| msbuildEngine | string | No | null | 使用するMSBuildエンジン（dotnet/vs） |
| restore | switch | No | false | 依存関係のリストアを実行するか |
| prepareMachine | switch | No | false | CI実行用のマシン準備を行うか |
| excludeCIBinaryLog | switch | No | false | バイナリログを出力しないか |
| noWarnAsError | switch | No | false | 警告をエラーとして扱わないか |
| runtimeSourceFeed | string | No | '' | ランタイムソースフィードURL |
| runtimeSourceFeedKey | string | No | '' | ランタイムソースフィードの認証キー |
| properties | string[] | No | - | MSBuildに渡す追加プロパティ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Arcade SDKタスクプロジェクト | .csproj/.targets | SdkTasksディレクトリ内のMSBuildプロジェクト |
| global.json | JSON | SDKバージョン、ツール設定 |
| tools.ps1 | PowerShell | 共通関数ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| バイナリログ | .binlog | MSBuildの詳細ログ（LogDirに出力） |
| タスク成果物 | 各種 | 実行タスクに応じた成果物 |
| コンソール出力 | テキスト | 実行ログ、エラーメッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {task}.binlog または {task}.{target}.binlog |
| 出力先 | $LogDir（artifacts/logディレクトリ） |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし（バイナリ形式） |

## 処理フロー

### 処理シーケンス

```
1. パラメータ解析と初期化
   └─ CmdletBinding属性により標準的なパラメータ処理
2. tools.ps1の読み込み
   └─ 共通関数（MSBuild, InitializeDotNetCli等）を利用可能にする
3. ヘルプ表示判定
   └─ -help または /? が指定された場合は使用方法を表示して終了
4. タスク名検証
   └─ -task が空の場合はエラー終了
5. MSBuildエンジン設定
   └─ -msbuildEngine が "vs" の場合、xcopy版MSBuildを初期化
6. タスクプロジェクト検証
   └─ GetSdkTaskProject関数でプロジェクトパスを取得、存在確認
7. Restore実行（オプション）
   └─ -restore が指定された場合、Restoreターゲットを実行
8. Execute実行
   └─ タスクのExecuteターゲットをMSBuildで実行
9. 終了処理
   └─ 成功時は終了コード0、失敗時は終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ解析]
    B --> C[tools.ps1読み込み]
    C --> D{ヘルプ要求?}
    D -->|Yes| E[使用方法表示]
    E --> F[終了コード0]
    D -->|No| G{タスク名指定あり?}
    G -->|No| H[エラー: タスク名必須]
    H --> I[終了コード1]
    G -->|Yes| J{msbuildEngine=vs?}
    J -->|Yes| K[xcopy MSBuild初期化]
    J -->|No| L[タスクプロジェクト検索]
    K --> L
    L --> M{プロジェクト存在?}
    M -->|No| N[エラー: 不明なタスク]
    N --> I
    M -->|Yes| O{restore指定?}
    O -->|Yes| P[Restore実行]
    P --> Q[Execute実行]
    O -->|No| Q
    Q --> R{成功?}
    R -->|Yes| F
    R -->|No| I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータエラー | -task パラメータが未指定 | タスク名を指定して再実行 |
| 1 | タスク不明エラー | 指定されたタスクのプロジェクトが存在しない | 正しいタスク名を確認して再実行 |
| 1 | MSBuildエラー | RestoreまたはExecuteが失敗 | エラーログを確認し原因を解消 |
| 1 | xcopy MSBuildエラー | VS版MSBuildの取得に失敗 | ネットワーク接続を確認、再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベルでのリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. バイナリログ（.binlog）を確認し、詳細なエラー内容を特定
2. 必要に応じて-verbosity diagnosticで再実行し、詳細ログを取得
3. NuGetパッケージキャッシュのクリア（-restoreオプションの問題の場合）
4. Azure DevOpsパイプラインの場合、ビルドログとアーティファクトを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | MSBuildタスク単位 |
| コミットタイミング | タスク成功時 |
| ロールバック条件 | MSBuildエラー発生時（部分的成果物が残る可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1タスク/実行 |
| 目標処理時間 | タスク内容に依存（数分〜数十分） |
| メモリ使用量上限 | MSBuildプロセスに依存 |

## 排他制御

同一マシン上での同一タスクの並列実行は想定されていません。CI/CDパイプラインでは、ジョブ単位での排他制御が行われます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | パラメータ情報（暗黙的） |
| 進捗ログ | MSBuild実行中 | verbosityに応じた詳細度 |
| バイナリログ | MSBuild完了時 | 完全なビルドログ（.binlog） |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによる出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure DevOpsパイプライン |
| 処理時間 | パイプライン定義による | Azure DevOps |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- Linux/macOS版として `eng/common/sdk-task.sh` が存在します
- タスクの具体的な動作は、Arcade SDKパッケージ内のSdkTasksディレクトリを参照してください
