# バッチ設計書 52-darc-init.sh

## 概要

本ドキュメントは、Linux/macOS環境でDARC（Dependency Flow Automation CLI）をインストールするためのBashスクリプト `eng/common/darc-init.sh` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、.NETプロジェクトの依存関係管理に使用されるDARC CLIツールをインストールするためのスクリプトです。DARCは、.NET Maestroサービスと連携して、複数リポジトリ間の依存関係フローを自動化するためのコマンドラインインターフェースです。

**業務上の目的・背景**：.NET Runtimeは多数のサブリポジトリ（runtime、aspnetcore、sdk等）から構成されており、これらの間の依存関係（NuGetパッケージバージョン等）を手動で管理することは非常に困難です。DARCを使用することで、Maestroサービスと連携した自動依存関係更新が可能になり、リリースエンジニアリングの効率が大幅に向上します。バージョンの整合性維持と自動PRの作成により、人的ミスを削減し、リリースサイクルを加速します。

**バッチの実行タイミング**：開発者のローカル環境セットアップ時、または新しいバージョンのDARCが必要な場合に手動実行されます。CI/CD環境では、依存関係更新ワークフローの一部として自動実行されることもあります。

**主要な処理内容**：
1. コマンドライン引数の解析（バージョン、エンドポイント、verbosity、toolpath）
2. DARCバージョンの取得（指定がない場合はMaestro APIから最新バージョンを取得）
3. dotnet CLIの初期化
4. 既存のDARC CLIがインストールされている場合はアンインストール
5. 指定バージョンのDARC CLIをdotnet tool installでインストール

**前後の処理との関連**：このスクリプトは `eng/common/tools.sh` に依存しており、InitializeDotNetCli関数を使用してdotnet SDKを初期化します。インストール後のDARCは、依存関係フローの管理、subscription作成、バージョン更新などのワークフローで使用されます。

**影響範囲**：開発者のローカル環境またはCI/CD環境のグローバルツールとしてインストールされます。インストール先は `--toolpath` で指定可能ですが、デフォルトではグローバルツールとしてインストールされます。

## バッチ種別

ツールインストール / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS OS | Bash実行環境が必要 |
| .NET SDK | global.jsonで指定されたバージョンのSDKがインストールされていること |
| ネットワーク接続 | Maestro API、Azure Artifacts（NuGetフィード）への接続が必要 |
| curl | バージョン取得のためにcurlコマンドが利用可能であること |

### 実行可否判定

ネットワーク接続が利用可能で、dotnet SDKが正常に初期化できる場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --darcversion | string | No | Maestro APIから取得 | インストールするDARCのバージョン |
| --versionendpoint | string | No | https://maestro.dot.net/api/assets/darc-version?api-version=2020-02-20 | バージョン取得用APIエンドポイント |
| --verbosity | string | No | minimal | インストール時のverbosity |
| --toolpath | string | No | なし（グローバル） | ツールのインストール先パス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Maestro API | HTTP/JSON | DARCの最新バージョン情報 |
| Azure Artifacts | NuGet | microsoft.dotnet.darcパッケージ |
| tools.sh | Bash | 共通関数ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| グローバルツール | CLI | darc コマンドとして利用可能 |
| コンソール出力 | テキスト | インストール進捗、結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | darc（実行可能ファイル） |
| 出力先 | ~/.dotnet/tools（グローバル）または--toolpath指定先 |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ --darcversion, --versionendpoint, --verbosity, --toolpath
2. スクリプトルートの解決
   └─ シンボリックリンクを辿って実際のパスを取得
3. tools.sh の読み込み
   └─ 共通関数を利用可能にする
4. DARCバージョンの決定
   └─ 未指定の場合、curlでMaestro APIから取得
5. dotnet CLIの初期化
   └─ InitializeDotNetCli関数を呼び出し
6. 既存DARCのアンインストール
   └─ dotnet tool listで確認し、存在すれば削除
7. 新規DARCのインストール
   └─ dotnet tool install でAzure Artifactsからインストール
8. 完了メッセージ出力
   └─ シェル再起動の案内を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[スクリプトルート解決]
    C --> D[tools.sh読み込み]
    D --> E{darcVersion指定?}
    E -->|No| F[Maestro APIからバージョン取得]
    E -->|Yes| G[dotnet CLI初期化]
    F --> G
    G --> H{toolpath指定?}
    H -->|No| I[グローバルツール一覧取得]
    H -->|Yes| J[指定パスのツール一覧取得]
    I --> K{DARC存在?}
    J --> K
    K -->|Yes| L[既存DARCアンインストール]
    K -->|No| M[新規DARCインストール]
    L --> M
    M --> N[完了メッセージ出力]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 不正なコマンドライン引数 | 正しい引数を指定して再実行 |
| N/A | ネットワークエラー | Maestro APIへの接続失敗 | ネットワーク接続を確認、--darcversionで直接指定 |
| N/A | インストールエラー | dotnet tool installの失敗 | NuGetフィードへの接続確認、認証情報確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベル） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ネットワーク接続を確認
2. Maestro APIエンドポイントの可用性を確認
3. Azure Artifactsフィードへのアクセス権限を確認
4. --darcversionで明示的にバージョンを指定して再試行
5. dotnet SDKのバージョンを確認（古いSDKでは動作しない可能性）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 既存ツールのアンインストール後に新規インストール失敗した場合、手動再インストールが必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 1-5分（ネットワーク速度に依存） |
| メモリ使用量上限 | dotnet tool installプロセスに依存 |

## 排他制御

同一マシン上での同時実行は想定されていません。dotnet tool installは内部でロック機構を持つ場合があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | インストール開始時 | "Installing Darc CLI version $darcVersion..." |
| 情報ログ | アンインストール時 | アンインストール結果 |
| 完了ログ | インストール完了時 | インストール成功メッセージ |
| 注意ログ | 初回インストール時 | シェル再起動の案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 |
| インストール時間 | 5分超過 | 手動確認 |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- Windows版として `eng/common/darc-init.ps1` が存在します
- DARCの使用方法については、公式ドキュメント（https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md）を参照してください
- NuGetソースとしてAzure Artifacts（dotnet-eng）が使用されます
