# バッチ設計書 53-darc-init.ps1

## 概要

本ドキュメントは、Windows環境でDARC（Dependency Flow Automation CLI）をインストールするためのPowerShellスクリプト `eng/common/darc-init.ps1` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、.NETプロジェクトの依存関係管理に使用されるDARC CLIツールをWindows環境にインストールするためのスクリプトです。DARCは、.NET Maestroサービスと連携して、複数リポジトリ間の依存関係フローを自動化するためのコマンドラインインターフェースです。

**業務上の目的・背景**：.NET Runtimeは多数のサブリポジトリ（runtime、aspnetcore、sdk等）から構成されており、これらの間の依存関係（NuGetパッケージバージョン等）を手動で管理することは非常に困難です。DARCを使用することで、Maestroサービスと連携した自動依存関係更新が可能になり、リリースエンジニアリングの効率が大幅に向上します。バージョンの整合性維持と自動PRの作成により、人的ミスを削減し、リリースサイクルを加速します。

**バッチの実行タイミング**：開発者のローカル環境セットアップ時、または新しいバージョンのDARCが必要な場合に手動実行されます。CI/CD環境では、依存関係更新ワークフローの一部として自動実行されることもあります。

**主要な処理内容**：
1. コマンドライン引数の受け取り（darcVersion、versionEndpoint、verbosity、toolpath）
2. tools.ps1の読み込みによる共通関数の初期化
3. DARCバージョンの取得（指定がない場合はInvoke-WebRequestでMaestro APIから取得）
4. dotnet CLIの初期化
5. 既存のDARC CLIがインストールされている場合はアンインストール
6. 指定バージョンのDARC CLIをdotnet tool installでインストール

**前後の処理との関連**：このスクリプトは `eng/common/tools.ps1` に依存しており、InitializeDotNetCli関数を使用してdotnet SDKを初期化します。インストール後のDARCは、依存関係フローの管理、subscription作成、バージョン更新などのワークフローで使用されます。

**影響範囲**：開発者のローカル環境またはCI/CD環境のグローバルツールとしてインストールされます。インストール先は `$toolpath` で指定可能ですが、デフォルトではグローバルツールとしてインストールされます。

## バッチ種別

ツールインストール / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | PowerShell実行環境が必要 |
| .NET SDK | global.jsonで指定されたバージョンのSDKがインストールされていること |
| ネットワーク接続 | Maestro API、Azure Artifacts（NuGetフィード）への接続が必要 |

### 実行可否判定

ネットワーク接続が利用可能で、dotnet SDKが正常に初期化できる場合に実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $darcVersion | string | No | $null（APIから取得） | インストールするDARCのバージョン |
| $versionEndpoint | string | No | https://maestro.dot.net/api/assets/darc-version?api-version=2020-02-20 | バージョン取得用APIエンドポイント |
| $verbosity | string | No | minimal | インストール時のverbosity |
| $toolpath | string | No | $null（グローバル） | ツールのインストール先パス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Maestro API | HTTP/JSON | DARCの最新バージョン情報 |
| Azure Artifacts | NuGet | microsoft.dotnet.darcパッケージ |
| tools.ps1 | PowerShell | 共通関数ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| グローバルツール | CLI | darc コマンドとして利用可能 |
| コンソール出力 | テキスト | インストール進捗、結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | darc.exe（実行可能ファイル） |
| 出力先 | %USERPROFILE%\.dotnet\tools（グローバル）または$toolpath指定先 |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. パラメータの受け取り
   └─ param()ブロックでデフォルト値を設定
2. tools.ps1の読み込み
   └─ 共通関数を利用可能にする
3. InstallDarcCli関数の定義
   └─ インストールロジックをカプセル化
4. dotnet CLIの初期化
   └─ InitializeDotNetCli関数を呼び出し
5. 既存DARCの確認とアンインストール
   └─ dotnet tool listで確認し、存在すれば削除
6. DARCバージョンの決定
   └─ 未指定の場合、Invoke-WebRequestでMaestro APIから取得
7. 新規DARCのインストール
   └─ dotnet tool install でAzure Artifactsからインストール
8. エラーハンドリング
   └─ try-catchでエラーを捕捉し、終了コード1で終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ受け取り]
    B --> C[tools.ps1読み込み]
    C --> D[InstallDarcCli関数呼び出し]
    D --> E[dotnet CLI初期化]
    E --> F[グローバルツール一覧取得]
    F --> G{DARC存在?}
    G -->|Yes| H[既存DARCアンインストール]
    G -->|No| I{darcVersion指定?}
    H --> I
    I -->|No| J[Maestro APIからバージョン取得]
    I -->|Yes| K[インストールメッセージ出力]
    J --> K
    K --> L{toolpath指定?}
    L -->|Yes| M[指定パスにインストール]
    L -->|No| N[グローバルインストール]
    M --> O{成功?}
    N --> O
    O -->|Yes| P[バッチ終了 exit 0]
    O -->|No| Q[エラー出力]
    Q --> R[バッチ終了 exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ネットワークエラー | Maestro APIへの接続失敗 | ネットワーク接続を確認、$darcVersionで直接指定 |
| 1 | インストールエラー | dotnet tool installの失敗 | NuGetフィードへの接続確認、認証情報確認 |
| 1 | 初期化エラー | dotnet SDK初期化の失敗 | SDKのインストール状況を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベル） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ネットワーク接続を確認
2. Maestro APIエンドポイントの可用性を確認（ブラウザでアクセス）
3. Azure Artifactsフィードへのアクセス権限を確認
4. $darcVersionで明示的にバージョンを指定して再試行
5. dotnet SDKのバージョンを確認（古いSDKでは動作しない可能性）
6. Write-Host出力で実際に実行されたコマンドを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 既存ツールのアンインストール後に新規インストール失敗した場合、手動再インストールが必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/実行 |
| 目標処理時間 | 1-5分（ネットワーク速度に依存） |
| メモリ使用量上限 | dotnet tool installプロセスに依存 |

## 排他制御

同一マシン上での同時実行は想定されていません。dotnet tool installは内部でロック機構を持つ場合があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | インストール開始時 | "Installing Darc CLI version $darcVersion..." |
| コマンドログ | インストール時 | 実行されるdotnet toolコマンド |
| 完了ログ | インストール完了時 | インストール成功メッセージ |
| 注意ログ | 初回インストール時 | "You may need to restart your command window..." |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによる出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 |
| インストール時間 | 5分超過 | 手動確認 |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- Linux/macOS版として `eng/common/darc-init.sh` が存在します
- DARCの使用方法については、公式ドキュメント（https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md）を参照してください
- NuGetソースとしてAzure Artifacts（dotnet-eng）が使用されます
- 実行されるコマンドはWrite-Hostで出力されるため、デバッグが容易です
