# バッチ設計書 54-init-tools-native.sh

## 概要

本ドキュメントは、Linux/macOS環境でネイティブビルドツール（CMake、Ninja等）を初期化・インストールするためのBashスクリプト `eng/common/init-tools-native.sh` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、.NET Runtimeのネイティブコード（CoreCLR、ネイティブライブラリ等）のビルドに必要なツールを global.json の設定に基づいて自動的にインストールするためのスクリプトです。ビルド環境の前提条件を自動的にセットアップし、開発者やCI/CDパイプラインでの環境構築を簡素化します。

**業務上の目的・背景**：.NET Runtimeはマネージドコードとネイティブコードの両方を含む大規模プロジェクトです。ネイティブコードのビルドには特定バージョンのCMake、Ninja、その他のツールが必要であり、これらのバージョン不一致がビルド失敗の原因となることがあります。このスクリプトにより、global.jsonで定義された正確なバージョンのツールを自動インストールし、ビルド環境の一貫性を保証します。

**バッチの実行タイミング**：ネイティブビルドの実行前、またはCI/CDパイプラインの環境セットアップフェーズで実行されます。通常、build.shやeng/build.shから間接的に呼び出されます。

**主要な処理内容**：
1. コマンドライン引数の解析（baseuri、installdirectory、clean、force等）
2. global.jsonファイルから native-tools セクションの読み取り
3. 定義された各ツールについて、対応するインストーラスクリプトを実行
4. インストール完了後、ツールのパスをPATH環境変数に追加（Azure Pipelines用の出力を含む）

**前後の処理との関連**：このスクリプトは `eng/common/pipeline-logging-functions.sh` と `eng/common/native/common-library.sh` に依存しています。インストールされたツールは、その後のネイティブビルド（CMakeプロジェクトのビルド）で使用されます。

**影響範囲**：ネイティブツールは `~/.netcoreeng/native/` または指定されたディレクトリにインストールされます。PATH環境変数が更新され、後続のビルドプロセスからツールが利用可能になります。

## バッチ種別

ツールインストール / 環境セットアップ / ネイティブビルド前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時（随時） |
| 実行時刻 | ビルド開始時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ビルドスクリプト / CI/CDパイプライン / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS OS | Bash実行環境が必要 |
| global.json | プロジェクトルートに存在し、native-toolsセクションが定義されていること |
| ネットワーク接続 | ツールアーカイブのダウンロードが必要な場合 |
| jq（推奨） | JSONパースの高速化のため推奨（なくても動作） |

### 実行可否判定

global.jsonにnative-toolsセクションが存在しない場合は、メッセージを出力して正常終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --baseuri | string | No | https://netcorenativeassets.blob.core.windows.net/resource-packages/external | ツールアーカイブのベースURL |
| --installdirectory | string | No | ~/.netcoreeng/native/ | ツールのインストール先ディレクトリ |
| --clean | switch | No | false | インストールせず、クリーンアップのみ実行 |
| --force | switch | No | false | クリーンアップ後にインストールを実行 |
| --donotabortonfailure | switch | No | false | 失敗しても中断しない |
| --donotdisplaywarnings | switch | No | false | 警告を表示しない |
| --downloadretries | int | No | 5 | ダウンロードのリトライ回数 |
| --retrywaittimeseconds | int | No | 30 | リトライ間隔（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| global.json | JSON | native-toolsセクションにツール名とバージョンを定義 |
| Azure Blob Storage | tar.gz | ツールアーカイブ |
| install-{tool}.sh | Bash | 各ツール固有のインストーラスクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ | ディレクトリ | ツールバイナリ |
| コンソール出力 | テキスト | インストール進捗、結果メッセージ |
| Azure Pipelines出力 | 特殊形式 | ##vso[task.prependpath]によるパス設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ツール固有（cmake、ninja等） |
| 出力先 | {install_directory}/bin/ |
| 文字コード | バイナリ |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ while loopで各オプションを処理
2. 依存スクリプトの読み込み
   └─ pipeline-logging-functions.sh、common-library.sh
3. global.jsonの読み取り
   └─ jqが利用可能ならjqを使用、なければBashで手動パース
4. native-toolsセクションの抽出
   └─ ツール名とバージョンのペアを配列に格納
5. インストールディレクトリの決定
   └─ 引数 > 環境変数 > デフォルト の優先順位
6. 各ツールのインストール実行
   └─ install-{tool}.sh を呼び出し
7. パス設定
   └─ Azure Pipelines用の##vso出力
8. 終了処理
   └─ 成功: exit 0、失敗: exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[依存スクリプト読み込み]
    C --> D[global.json読み取り]
    D --> E{native-tools存在?}
    E -->|No| F[メッセージ出力]
    F --> G[exit 0]
    E -->|Yes| H[ツールリスト抽出]
    H --> I[インストールディレクトリ決定]
    I --> J[ツールごとにループ]
    J --> K{インストーラ存在?}
    K -->|No| L{中断設定?}
    L -->|Yes| M[エラー exit 1]
    L -->|No| N[次のツールへ]
    K -->|Yes| O[インストーラ実行]
    O --> P{成功?}
    P -->|No| L
    P -->|Yes| N
    N --> Q{全ツール完了?}
    Q -->|No| J
    Q -->|Yes| R{clean モード?}
    R -->|Yes| G
    R -->|No| S[パス設定出力]
    S --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストールエラー | インストーラスクリプトが失敗 | ネットワーク接続確認、--forceで再実行 |
| 1 | インストーラ不在 | 対応するinstall-{tool}.shが存在しない | 対応ツールの確認、カスタムインストーラの作成 |
| 1 | ディレクトリエラー | インストールディレクトリが作成できない | 権限確認、ディスク容量確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | --downloadretriesで指定（デフォルト5回） |
| リトライ間隔 | --retrywaittimesecondsで指定（デフォルト30秒） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

1. ネットワーク接続を確認
2. Azure Blob Storageへのアクセス可能性を確認
3. --forceオプションで強制再インストールを試行
4. 手動でツールをインストールし、パスを設定
5. global.jsonのnative-toolsセクションを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ツール単位 |
| コミットタイミング | 各ツールのインストール完了時 |
| ロールバック条件 | 失敗したツールは部分的にインストールされる可能性あり（--cleanで対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1-5ツール/実行 |
| 目標処理時間 | 1-10分（ツール数とネットワーク速度に依存） |
| メモリ使用量上限 | tar展開時に一時的に増加 |

## 排他制御

同一マシン上での同時実行は想定されていません。同じインストールディレクトリへの同時書き込みは競合を引き起こす可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 各ツールインストール開始時 | インストーラコマンド |
| 進捗ログ | インストール中 | ダウンロード、展開の進捗 |
| 完了ログ | 全ツールインストール完了時 | パス情報 |
| エラーログ | エラー発生時 | Write-PipelineTelemetryErrorによる出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure DevOpsパイプライン |
| 処理時間 | 10分超過 | 手動確認 |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- Windows版として `eng/common/init-tools-native.ps1` が存在します
- jqがインストールされていると、global.jsonのパースが高速化されます
- 各ツールのインストーラは `eng/common/native/install-{tool}.sh` に存在する必要があります
- Azure Pipelines用の出力（##vso[task.prependpath]）により、後続タスクからツールが利用可能になります
