# バッチ設計書 56-init-os-and-arch.sh

## 概要

本ドキュメントは、実行環境のOS種別とCPUアーキテクチャを検出するためのシェルスクリプト `eng/common/native/init-os-and-arch.sh` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、ビルド環境のオペレーティングシステムとCPUアーキテクチャを自動的に検出し、変数として設定するためのスクリプトです。クロスプラットフォームビルドにおいて、ターゲット環境に応じた適切なビルド設定を選択するための基盤となる重要なコンポーネントです。

**業務上の目的・背景**：.NET Runtimeは多数のプラットフォーム（Linux、macOS、FreeBSD、Android、Solaris等）とアーキテクチャ（x64、arm64、arm、s390x、ppc64le、riscv64等）をサポートしています。各環境でのビルド設定は異なるため、実行環境を正確に検出することが不可欠です。このスクリプトにより、ビルドスクリプトは環境依存の条件分岐を統一的に行うことができ、保守性とポータビリティが向上します。

**バッチの実行タイミング**：他のビルドスクリプトから source コマンドで読み込まれ、スクリプト実行の初期段階で環境検出が行われます。直接実行されることは想定されていません。

**主要な処理内容**：
1. uname -s コマンドによるOS名の取得と正規化
2. Android環境の特別検出（getpropコマンド）
3. Solaris/illumos環境の識別
4. uname -m または isainfo -n によるCPUアーキテクチャの取得
5. 32ビット/64ビット環境の判定（特にARM環境）
6. 結果を $os と $arch 変数に設定

**前後の処理との関連**：このスクリプトは他のビルドスクリプト（build-commons.sh、init-compiler.sh等）から source コマンドで読み込まれます。設定された $os と $arch 変数は、後続のビルドロジックで条件分岐に使用されます。

**影響範囲**：スクリプト自体はファイルシステムや環境を変更しません。$os と $arch 変数を設定するのみです。これらの変数はビルドプロセス全体の構成に影響します。

## バッチ種別

環境検出 / ユーティリティ / 設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時（随時） |
| 実行時刻 | ビルドスクリプト実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 他スクリプトからのsource呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix系OS | Linux、macOS、FreeBSD、Solaris等 |
| uname コマンド | OS/アーキテクチャ検出に必要 |
| シェル環境 | sh互換シェル（bash、dash等） |

### 実行可否判定

サポートされていないOSまたはCPUが検出された場合、エラーメッセージを出力して exit 1 で終了します。

## 入力仕様

### 入力パラメータ

このスクリプトはコマンドライン引数を受け取りません。環境情報はシステムコマンドから取得します。

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| (なし) | - | - | - | 引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| uname -s | テキスト | OS名（Linux、Darwin等） |
| uname -m | テキスト | CPUアーキテクチャ |
| isainfo -n | テキスト | Solaris/illumos用アーキテクチャ |
| getprop | テキスト | Android環境検出用 |
| getconf LONG_BIT | テキスト | ビット幅検出（32/64） |
| /etc/os-release | ファイル | Tizenディストリビューション検出 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $os 変数 | シェル変数 | 検出されたOS名 |
| $arch 変数 | シェル変数 | 検出されたアーキテクチャ |
| stderr | テキスト | エラーメッセージ（サポート外の場合） |

### 出力変数の値一覧

#### $os の値

| 値 | 対応OS |
|---|--------|
| linux | Linux |
| osx | macOS (Darwin) |
| freebsd | FreeBSD |
| netbsd | NetBSD |
| openbsd | OpenBSD |
| sunos | SunOS |
| solaris | Oracle Solaris |
| illumos | illumos |
| android | Android |
| haiku | Haiku OS |

#### $arch の値

| 値 | 対応アーキテクチャ |
|---|------------------|
| x64 | AMD64/x86_64 |
| arm64 | AArch64 |
| arm | ARMv7/ARMv8（32ビット） |
| armv6 | ARMv6 |
| armel | ARM（Tizen用） |
| x86 | i386/i686（非推奨） |
| s390x | IBM System z |
| ppc64le | PowerPC 64-bit Little Endian |
| riscv64 | RISC-V 64-bit |
| loongarch64 | LoongArch 64-bit |

## 処理フロー

### 処理シーケンス

```
1. OS名の取得
   └─ uname -s を実行し、小文字に変換
2. Android環境の特別検出
   └─ getprop ro.product.system.model で検出
3. OS名の正規化
   └─ case文でOS名を標準化（darwin→osx等）
4. Solaris/illumos の識別
   └─ uname -o で判定
5. CPUアーキテクチャの取得
   └─ Solaris: isainfo -n、その他: uname -m
6. アーキテクチャの正規化
   └─ case文でアーキテクチャ名を標準化
7. 32ビット環境の検出（ARM64）
   └─ getconf LONG_BIT が64未満ならarm
8. Tizen環境の特別処理
   └─ /etc/os-release でTizenを検出しarmel設定
9. サポート外の場合はエラー終了
   └─ echo + exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[uname -s でOS取得]
    B --> C{Android?}
    C -->|Yes| D[os=android]
    C -->|No| E{OS判定}
    E -->|darwin| F[os=osx]
    E -->|linux,freebsd等| G[os=OSName]
    E -->|sunos| H{illumos?}
    H -->|Yes| I[os=illumos]
    H -->|No| J[os=solaris]
    E -->|その他| K[エラー exit 1]
    D --> L[CPU取得]
    F --> L
    G --> L
    I --> L
    J --> L
    L --> M{Solaris系?}
    M -->|Yes| N[isainfo -n]
    M -->|No| O[uname -m]
    N --> P{アーキテクチャ判定}
    O --> P
    P -->|arm64/aarch64| Q{64ビット?}
    Q -->|Yes| R[arch=arm64]
    Q -->|No| S[arch=arm]
    P -->|amd64/x86_64| T[arch=x64]
    P -->|armv7l/armv8l| U{Tizen?}
    U -->|Yes| V[arch=armel]
    U -->|No| S
    P -->|その他| W{サポート?}
    W -->|Yes| X[対応archを設定]
    W -->|No| Y[エラー/警告]
    R --> Z[スクリプト終了]
    S --> Z
    T --> Z
    V --> Z
    X --> Z
    Y --> Z
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | OS未サポート | 認識できないOSで実行 | サポート対象OSで実行 |
| 1 | CPU未サポート | 認識できないCPUアーキテクチャ | サポート対象マシンで実行 |
| (警告) | CPU警告 | x86（32ビット）で実行 | 64ビット環境を推奨 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージで検出されたOS/CPUを確認
2. サポート対象プラットフォームのドキュメントを確認
3. 必要に応じてスクリプトを修正（新規プラットフォーム対応）
4. クロスコンパイル環境の設定を検討

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限（シェル変数のみ） |

## 排他制御

排他制御は不要です。読み取り専用の環境検出のみを行います。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | サポート外検出時 | "Unsupported OS/CPU detected!" |
| 警告ログ | x86検出時 | "build might not succeed!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元スクリプト |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- sh互換として書かれているため、bash固有の機能は使用していません
- 新しいプラットフォームをサポートする場合は、case文にエントリを追加する必要があります
- x86（32ビット）は非推奨であり、警告メッセージが表示されます
- Raspberry Pi OS等、64ビットCPU上の32ビットOSを正しく検出します（getconf LONG_BIT使用）
- Tizen OSは特別な処理が必要であり、armelアーキテクチャとして識別されます
