# バッチ設計書 58-init-distro-rid.sh

## 概要

本ドキュメントは、LinuxディストリビューションのRuntime ID（RID）を初期化・判定するためのシェルスクリプト `eng/common/native/init-distro-rid.sh` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、ターゲットプラットフォームの非ポータブルRID（Runtime Identifier）を判定し、ポータブルビルドか非ポータブルビルドかを決定するための情報を提供するスクリプトです。RIDは.NETランタイムがプラットフォーム固有のアセットを識別するために使用する識別子であり、正確なRIDの設定はランタイムの正しい動作に不可欠です。

**業務上の目的・背景**：.NET Runtimeは多数のLinuxディストリビューション（Ubuntu、Fedora、Alpine、Debian等）をサポートしており、各ディストリビューションは異なるRIDで識別されます。ポータブルビルド（linux-x64等）は広い互換性を持ちますが、非ポータブルビルド（ubuntu.22.04-x64等）は特定のディストリビューション向けに最適化されます。このスクリプトにより、ビルド環境から適切なRIDを自動的に検出し、ビルド設定に反映できます。

**バッチの実行タイミング**：他のビルドスクリプトから source コマンドで読み込まれます。通常、build-commons.sh 等から呼び出されます。

**主要な処理内容**：
1. getNonPortableDistroRid関数：非ポータブルRIDの生成
2. /etc/os-release からディストリビューション情報を読み取り
3. FreeBSD、Android、Solaris、illumos、Haiku等の特別処理
4. initDistroRidGlobal関数：グローバル変数の設定
5. musl libc（Alpine Linux等）の検出
6. __DistroRid と __PortableTargetOS 変数のエクスポート

**前後の処理との関連**：このスクリプトは targetOs、targetArch、rootfsDir 変数が設定された状態で呼び出されることを前提としています。設定された __DistroRid と __PortableTargetOS 変数は、ビルドシステムでRID関連の設定に使用されます。

**影響範囲**：グローバル変数 __DistroRid と __PortableTargetOS を設定・エクスポートします。ファイルシステムへの変更は行いません。

## バッチ種別

環境検出 / RID判定 / ビルド前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時（随時） |
| 実行時刻 | ビルドスクリプト実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 他スクリプトからのsource呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Unix系OS | Linux、FreeBSD、Android、Solaris等 |
| /etc/os-release | Linux環境でのディストリビューション情報源（オプション） |
| rootfsDir | クロスコンパイル時のsysrootパス（オプション） |

### 実行可否判定

rootfsDir が指定されているが存在しない場合、エラーメッセージを出力して exit 1 で終了します。

## 入力仕様

### 入力パラメータ

関数の引数として以下を受け取ります。

#### getNonPortableDistroRid 関数

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| targetOs | string | Yes | - | ターゲットOS（linux、freebsd等） |
| targetArch | string | Yes | - | ターゲットアーキテクチャ（x64、arm64等） |
| rootfsDir | string | No | "" | クロスコンパイル用sysrootパス |

#### initDistroRidGlobal 関数

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| targetOs | string | Yes | - | ターゲットOS |
| targetArch | string | Yes | - | ターゲットアーキテクチャ |
| rootfsDir | string | No | "" | クロスコンパイル用sysrootパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/os-release | シェル変数形式 | ID、VERSION_ID等のディストリビューション情報 |
| /android_platform | シェル変数形式 | Android RID情報 |
| freebsd-version | コマンド | FreeBSDバージョン |
| getprop | コマンド | Android SDK バージョン |
| uname -v | コマンド | illumos/Solarisバージョン |
| uname -r | コマンド | Haikuリリース番号 |
| ldd --version | コマンド | musl libc検出 |
| strings | コマンド | musl libc検出（バックアップ） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| __DistroRid 環境変数 | 文字列 | 非ポータブルRID（例：ubuntu.22.04-x64） |
| __PortableTargetOS 環境変数 | 文字列 | ポータブルOS名（linux、linux-musl等） |
| 戻り値（関数） | 文字列 | getNonPortableDistroRidの戻り値 |

### RID形式の例

| プラットフォーム | RID例 |
|----------------|------|
| Ubuntu 22.04 x64 | ubuntu.22.04-x64 |
| Fedora 38 x64 | fedora.38-x64 |
| Alpine Linux arm64 | alpine-arm64（ローリングリリース） |
| FreeBSD 14 x64 | freebsd.14-x64 |
| Android 33 arm64 | android.33-arm64 |
| illumos x64 | illumos-x64 |
| Solaris 11 x64 | solaris.11-x64 |
| Haiku R1 x64 | haiku.r1-x64 |

## 処理フロー

### 処理シーケンス

```
1. getNonPortableDistroRid 関数
   1.1 Linux: /etc/os-release から ID と VERSION_ID を読み取り
   1.2 Linux: VERSION_ID がバージョン形式なら "{ID}.{VERSION_ID}-{arch}"
   1.3 Linux: ローリングリリースなら "{ID}-{arch}"
   1.4 Linux: android_platform があれば RID を読み取り
   1.5 FreeBSD: freebsd-version からメジャーバージョン取得
   1.6 Android: getprop ro.build.version.sdk からSDKバージョン取得
   1.7 illumos/Solaris: uname -v からバージョン取得
   1.8 Haiku: uname -r からリリース番号取得
   1.9 小文字に正規化して返却

2. initDistroRidGlobal 関数
   2.1 rootfsDir の存在確認（指定時）
   2.2 getNonPortableDistroRid を呼び出し __DistroRid を設定
   2.3 __PortableTargetOS の初期値を targetOs に設定
   2.4 musl libc の検出（ldd または strings コマンド）
   2.5 musl 検出時は __PortableTargetOS を "linux-musl" に設定
   2.6 __DistroRid と __PortableTargetOS をエクスポート
```

### フローチャート

```mermaid
flowchart TD
    A[関数呼び出し] --> B{targetOs?}
    B -->|linux| C{/etc/os-release存在?}
    C -->|Yes| D[ID, VERSION_ID読み取り]
    D --> E{VERSION_IDがバージョン形式?}
    E -->|Yes| F["RID = ID.VERSION_ID-arch"]
    E -->|No| G["RID = ID-arch"]
    C -->|No| H{android_platform存在?}
    H -->|Yes| I[RID読み取り]
    H -->|No| J[RID = 空]
    B -->|freebsd| K[freebsd-version実行]
    K --> L["RID = freebsd.major-arch"]
    B -->|android| M[getprop実行]
    M --> N["RID = android.sdk-arch"]
    B -->|illumos| O["RID = illumos-arch"]
    B -->|solaris| P[uname -v実行]
    P --> Q["RID = solaris.major-arch"]
    B -->|haiku| R[uname -r実行]
    R --> S["RID = haiku.rN-arch"]
    F --> T[小文字変換]
    G --> T
    I --> T
    J --> T
    L --> T
    N --> T
    O --> T
    Q --> T
    S --> T
    T --> U[RID返却]
```

```mermaid
flowchart TD
    A[initDistroRidGlobal] --> B{rootfsDir指定?}
    B -->|Yes| C{存在確認}
    C -->|No| D[エラー exit 1]
    C -->|Yes| E[getNonPortableDistroRid呼び出し]
    B -->|No| E
    E --> F[__DistroRid設定]
    F --> G[__PortableTargetOS = targetOs]
    G --> H{musl libc検出}
    H -->|ldd| I{musl含む?}
    H -->|strings| J{musl含む?}
    I -->|Yes| K[__PortableTargetOS = linux-musl]
    J -->|Yes| K
    I -->|No| L[変更なし]
    J -->|No| L
    K --> M[エクスポート]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | rootfsDirエラー | rootfsDirが指定されているが存在しない | 正しいパスを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. rootfsDirのパスが正しいか確認
2. /etc/os-releaseファイルが存在するか確認
3. クロスコンパイルの場合、sysrootが正しく構築されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限（シェル変数のみ） |

## 排他制御

排他制御は不要です。読み取り専用の環境検出のみを行います。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | rootfsDirエラー時 | "Error: rootfsDir has been passed, but the location is not valid." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | 呼び出し元スクリプト |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- sh互換として書かれているため、bash固有の機能は使用していません
- ローリングリリースディストリビューション（Arch Linux等）はVERSION_IDが設定されていないか、バージョン形式でない場合があります
- musl libc の検出は、ldd コマンドの出力または strings コマンドによるバイナリ解析で行われます
- クロスコンパイル時は rootfsDir 内の情報を使用してターゲット環境のRIDを判定します
- RIDは常に小文字に正規化されます
- __PortableTargetOS は linux または linux-musl のいずれかに設定され、ポータブルビルドの識別に使用されます
