# バッチ設計書 6-eng/common/build.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/common/build.ps1` - 共通ビルドスクリプト（Windows）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Arcadeビルドインフラストラクチャの共通ビルドスクリプト（Windows版）であり、MSBuildによるビルドを実行する。`eng/common/build.sh` のWindows版として、同等の機能をPowerShellで提供する。

**業務上の目的・背景**：Windows環境での.NET開発において、Visual StudioやMSBuildとの統合が重要である。このスクリプトはArcadeフレームワークのWindows版コンポーネントとして、すべてのビルドアクションを統一されたインターフェースで提供し、CI/CD環境（Azure DevOps等）との統合を実現する。

**バッチの実行タイミング**：`eng/build.ps1` から呼び出される。CI/CDパイプラインやローカルビルドで使用される。

**主要な処理内容**：
1. コマンドライン引数の解析（PowerShellパラメータバインディング）
2. Platform環境変数のクリア（一部PCでの問題回避）
3. ツールセットの初期化（.NET SDKのインストールと設定）
4. カスタムツールセットの読み込み（restore-toolset.ps1がある場合）
5. MSBuildによるビルドの実行

**前後の処理との関連**：`eng/build.ps1` から呼び出され、`eng/common/tools.ps1` を読み込んでSDK初期化を行う。カスタマイズ用に `eng/restore-toolset.ps1` を読み込む。

**影響範囲**：プロジェクト全体のビルドプロセス、NuGetパッケージの作成、テスト実行、成果物の公開に影響する。

## バッチ種別

ビルド実行 / ツールセット管理 / Arcadeインフラ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | eng/build.ps1 からの呼び出し / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境での実行が必要 |
| PowerShell | PowerShell 5.1以上が利用可能であること |
| .NET SDK | 自動的にインストールされる（tools.ps1による） |
| eng/common/tools.ps1 | 共通ツール関数が存在すること |

### 実行可否判定

スクリプトは常に実行可能。`-clean` オプション指定時はArtifactsディレクトリを削除して終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -configuration (-c) | string | No | Debug | ビルド構成（Debug, Release） |
| -platform | string | No | なし | プラットフォーム構成（x86, x64等） |
| -verbosity (-v) | string | No | minimal | MSBuild詳細度 |
| -binaryLog (-bl) | switch | No | false | バイナリログ出力 |
| -restore (-r) | switch | No | false | 依存関係の復元 |
| -build (-b) | switch | No | false | ビルドの実行 |
| -rebuild | switch | No | false | リビルドの実行 |
| -deploy | switch | No | false | デプロイの実行 |
| -deployDeps | switch | No | false | 依存関係のデプロイ |
| -test (-t) | switch | No | false | 単体テストの実行 |
| -integrationTest | switch | No | false | 統合テストの実行 |
| -performanceTest | switch | No | false | パフォーマンステストの実行 |
| -pack | switch | No | false | NuGetパッケージの作成 |
| -sign | switch | No | false | 成果物の署名 |
| -publish | switch | No | false | 成果物の公開 |
| -clean | switch | No | false | Artifactsディレクトリの削除 |
| -productBuild (-pb) | switch | No | false | 製品ビルドモード |
| -ci | switch | No | false | CI環境での実行 |
| -prepareMachine | switch | No | false | マシン準備モード |
| -projects | string | No | なし | ビルド対象プロジェクト |
| -msbuildEngine | string | No | なし | MSBuildエンジン指定（dotnet, vs） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/tools.ps1 | PowerShellスクリプト | SDK初期化、MSBuild関数の提供 |
| eng/restore-toolset.ps1 | PowerShellスクリプト | カスタムツールセット初期化（オプション） |
| Platform | 環境変数 | クリアされる（HP PC等での問題回避） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| $ArtifactsDir | ディレクトリ | ビルド成果物 |
| $LogDir/Build.binlog | バイナリ | MSBuildバイナリログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成とアクションに依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. Platform環境変数のクリア
   └─ HP PC等での'MCD'設定による問題を回避
2. tools.ps1 の読み込み
   └─ InitializeToolset等の関数を定義
3. クリーン処理（-clean時）
   └─ $ArtifactsDirを削除して終了
4. ヘルプ表示（-help時）
   └─ Print-Usage関数で使用方法を表示
5. CI環境設定
   └─ CI時はbinaryLog有効、nodeReuse無効
6. ネイティブツール初期化（-restore時）
   └─ InitializeNativeTools呼び出し
7. Build関数実行
   └─ ツールセット初期化、MSBuild呼び出し
8. エラーハンドリング
   └─ try-catchでエラーを捕捉
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Platform環境変数クリア]
    B --> C[tools.ps1読み込み]
    C --> D{-clean?}
    D -->|Yes| E[$ArtifactsDir削除]
    E --> F[終了 exit 0]
    D -->|No| G{-help?}
    G -->|Yes| H[Print-Usage]
    H --> F
    G -->|No| I{-ci?}
    I -->|Yes| J[binaryLog有効, nodeReuse無効]
    I -->|No| K{nativeToolsOnMachine?}
    J --> K
    K -->|Yes| L[NativeToolsOnMachine環境変数設定]
    K -->|No| M{-restore?}
    L --> M
    M -->|Yes| N[InitializeNativeTools]
    M -->|No| O[Build関数呼び出し]
    N --> O
    O --> P[InitializeToolset]
    P --> Q[InitializeCustomToolset]
    Q --> R[MSBuild実行]
    R --> S{エラー?}
    S -->|Yes| T[Write-PipelineTelemetryError]
    T --> U[ExitWithExitCode 1]
    S -->|No| V[ExitWithExitCode 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | MSBuildがエラー終了 | ログを確認して問題を修正 |
| 1 | 復元エラー | NuGetパッケージの復元に失敗 | ネットワーク接続とフィードを確認 |
| 1 | ツールセットエラー | ツールセットの初期化に失敗 | SDKのインストール状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. try-catchでエラーが捕捉され、ScriptStackTraceが出力される
2. Write-PipelineTelemetryErrorでCI/CDシステムにエラーが報告される
3. `-bl` オプションでバイナリログを有効にして詳細を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド実行 |
| 目標処理時間 | プロジェクトサイズに依存 |
| メモリ使用量上限 | プロジェクトサイズに依存 |

## 排他制御

nodeReuseパラメータにより、MSBuildノードの再利用を制御。CI環境ではデフォルトで無効にされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗 |
| バイナリログ | -bl指定時/CI | MSBuildの詳細ログ |
| テレメトリ | エラー時 | CI/CDパイプライン向けエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム |
| ビルド時間 | プロジェクトによる | CI/CDシステム |

## 備考

- Platform環境変数は一部のHP PC等で'MCD'に設定されていることがあり、ビルドの問題を引き起こすためクリアされる（issue #69参照）
- `-msbuildEngine` パラメータで `dotnet` または `vs`（Visual Studio）を指定可能
- `-excludePrereleaseVS` オプションでプレリリース版Visual Studioを除外可能
- `-nativeToolsOnMachine` オプションでマシンにインストール済みのネイティブツールを使用
- カスタムツールセット初期化用に `eng/restore-toolset.ps1` を読み込む仕組みがある
- `-fromVMR` オプションはVMR（Virtual Monolithic Repository）内でのビルドを示す
- Write-PipelineTelemetryError関数でAzure Pipelines形式のエラー出力が行われる
