# バッチ設計書 60-install-cmake.sh

## 概要

本ドキュメントは、CMakeビルドツールをダウンロード・インストールするためのBashスクリプト `eng/common/native/install-cmake.sh` の設計仕様を記載します。

### 本バッチの処理概要

このバッチは、指定されたバージョンのCMakeをAzure Blob Storageからダウンロードし、ローカル環境にインストールするためのスクリプトです。インストール完了後、シムスクリプトを生成してパスに追加する準備を行います。

**業務上の目的・背景**：.NET Runtimeのネイティブコンポーネント（CoreCLR等）はCMakeを使用してビルドされます。ビルド環境には特定バージョンのCMakeが必要であり、システムにインストールされているCMakeのバージョンが適合しない場合があります。このスクリプトにより、global.jsonで指定された正確なバージョンのCMakeを自動的にインストールし、ビルド環境の一貫性を保証します。init-tools-native.sh から呼び出され、CMakeのセットアップを担当します。

**バッチの実行タイミング**：init-tools-native.sh から呼び出されます。global.json に cmake が native-tools として定義されている場合に実行されます。

**主要な処理内容**：
1. コマンドライン引数の解析（baseuri、installpath、version、clean、force等）
2. OS検出とダウンロードURLの構築
3. クリーンモードの場合、既存インストールとシムを削除
4. CMakeが既にインストールされている場合のスキップ判定
5. common-library.sh の DownloadAndExtract 関数でダウンロード・展開
6. NewScriptShim 関数でシムスクリプトを生成

**前後の処理との関連**：このスクリプトは `eng/common/native/common-library.sh` に依存しています。init-tools-native.sh から呼び出され、global.json の native-tools セクションで指定されたバージョンをインストールします。

**影響範囲**：CMakeは指定されたインストールディレクトリ（{installpath}/cmake/{version}/）にインストールされます。シムスクリプト（cmake.sh）がインストールパスに生成されます。

## バッチ種別

ツールインストール / ネイティブビルド前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド実行時（随時） |
| 実行時刻 | init-tools-native.sh 実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | init-tools-native.sh からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS OS | Bash実行環境が必要 |
| curl または wget | ダウンロードに必要 |
| tar | アーカイブ展開に必要 |
| common-library.sh | 共通関数ライブラリが利用可能であること |

### 実行可否判定

- 既にインストール済みかつ force=false の場合はスキップ
- clean=true の場合はクリーンアップのみ実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --baseuri | string | No | - | ツールアーカイブのベースURL |
| --installpath | string | No | - | ツールのインストール先ディレクトリ |
| --version | string | No | - | インストールするCMakeのバージョン |
| --clean | switch | No | false | クリーンアップのみ実行 |
| --force | switch | No | false | 強制再インストール |
| --downloadretries | int | No | 5 | ダウンロードのリトライ回数 |
| --retrywaittimeseconds | int | No | 30 | リトライ間隔（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure Blob Storage | tar.gz | CMakeアーカイブ（cmake-{version}-{OS}-x86_64.tar.gz） |
| common-library.sh | Bash | 共通関数ライブラリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| インストールディレクトリ | ディレクトリ | CMakeバイナリと関連ファイル |
| シムスクリプト | Bashスクリプト | cmake.sh |
| コンソール出力 | テキスト | 進捗、結果メッセージ |

### ファイル配置

| 項目 | パス |
|-----|------|
| インストールディレクトリ | {install_path}/cmake/{version}/ |
| CMake本体 | {install_path}/cmake/{version}/cmake-{version}-{OS}-x86_64/bin/cmake |
| シムスクリプト | {install_path}/cmake.sh |

### URL構成

```
{base_uri}/{tool_folder}/cmake/cmake-{version}-{OS}-x86_64.tar.gz

例：
https://netcorenativeassets.blob.core.windows.net/resource-packages/external/linux/cmake/cmake-3.28.0-Linux-x86_64.tar.gz
```

## 処理フロー

### 処理シーケンス

```
1. common-library.sh の読み込み
   └─ 共通関数を利用可能にする
2. コマンドライン引数の解析
   └─ while loopで各オプションを処理
3. 変数の設定
   └─ tool_name, tool_os, tool_folder, tool_arch等
4. ダウンロードURL・インストールパスの構築
   └─ uri, tool_install_directory, tool_file_path, shim_path
5. クリーンモード判定
   └─ clean=trueならクリーンアップして終了
6. インストール済み判定
   └─ tool_file_path存在かつforce=falseならスキップ
7. DownloadAndExtract実行
   └─ アーカイブをダウンロードして展開
8. NewScriptShim実行
   └─ シムスクリプトを生成
9. 終了処理
   └─ 成功: exit 0、失敗: exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[common-library.sh読み込み]
    B --> C[引数解析]
    C --> D[変数設定]
    D --> E{clean=true?}
    E -->|Yes| F[インストールディレクトリ削除]
    F --> G[シムファイル削除]
    G --> H[一時ファイル削除]
    H --> I[exit 0]
    E -->|No| J{CMake存在 && force=false?}
    J -->|Yes| K[スキップメッセージ]
    K --> I
    J -->|No| L[DownloadAndExtract実行]
    L --> M{成功?}
    M -->|No| N[エラー出力]
    N --> O[exit 1]
    M -->|Yes| P[NewScriptShim実行]
    P --> Q{成功?}
    Q -->|No| R[エラー出力]
    R --> O
    Q -->|Yes| I
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ダウンロードエラー | DownloadAndExtract失敗 | ネットワーク確認、URL確認 |
| 1 | シム生成エラー | NewScriptShim失敗 | 権限確認、パス確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | --downloadretries引数（デフォルト5回） |
| リトライ間隔 | --retrywaittimeseconds引数（デフォルト30秒） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

1. Write-PipelineTelemetryError の出力を確認
2. ネットワーク接続を確認
3. Azure Blob Storageへのアクセス可能性を確認
4. --forceオプションで強制再インストールを試行
5. 手動でCMakeをインストールし、パスを設定

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | スクリプト全体 |
| コミットタイミング | 各ステップ完了時 |
| ロールバック条件 | 失敗時は部分的にインストールされる可能性あり（--cleanで対応） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 1-5分（ネットワーク速度とCMakeサイズに依存） |
| メモリ使用量上限 | tar展開時に一時的に増加 |

## 排他制御

同一インストールディレクトリへの同時実行は想定されていません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| クリーンログ | クリーン実行時 | "Cleaning {path}" |
| スキップログ | インストール済み時 | "{tool_name} ({version}) already exists, skipping install" |
| エラーログ | 失敗時 | Write-PipelineTelemetryErrorによる出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | init-tools-native.sh |
| 処理時間 | 5分超過 | 手動確認 |

## 備考

- このスクリプトはArcade SDKの標準コンポーネントであり、.NET系プロジェクト全体で共有されています
- CMakeはx86_64アーキテクチャ専用でダウンロードされます（tool_arch変数は固定）
- シムスクリプトは常に上書きされます（NewScriptShimにtrue引数）
- tool_osはGetCurrentOS関数で取得され、小文字に変換されてフォルダ名に使用されます
- Azure Blob Storageの構造は {base_uri}/{os}/cmake/{archive} です
- クリーンモードでは一時ファイルも削除されます（GetTempPathFileName使用）
