# バッチ設計書 61-install-dependencies.sh

## 概要

本ドキュメントは、Linux/macOS環境でビルドに必要なシステムパッケージをインストールするためのスクリプト `eng/common/native/install-dependencies.sh` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、.NETランタイムのビルドに必要な開発ツールとライブラリをLinuxおよびmacOSシステムにインストールする。OSのディストリビューションを自動検出し、適切なパッケージマネージャーを使用して依存関係をセットアップする。

**業務上の目的・背景**：.NETランタイムのビルドには、CMake、Clang/LLVM、各種開発ライブラリなど多数のツールが必要である。CI/CD環境や開発者のローカル環境でこれらの依存関係を一括でセットアップすることで、ビルド環境の構築を自動化し、環境差異によるビルドエラーを防止する。

**バッチの実行タイミング**：新しいCI/CDエージェントのセットアップ時、開発者のローカル環境構築時、またはビルド環境の初期化時に手動で実行される。定期実行ではなく、環境セットアップフェーズで随時実行される。

**主要な処理内容**：
1. 引数またはシステム検出によるOS種別の判定
2. Linuxの場合、/etc/os-releaseからディストリビューション情報を取得
3. ディストリビューションに応じたパッケージマネージャーでビルドツールをインストール
4. macOSの場合、Homebrewを使用して必要なツールをインストール

**前後の処理との関連**：本スクリプトは `init-os-and-arch.sh` を呼び出してOS種別を判定する。本スクリプトの実行後、ビルドスクリプト（build.sh等）が実行可能となる。

**影響範囲**：システムレベルのパッケージがインストールされるため、システム全体に影響する。root権限が必要な場合がある。

## バッチ種別

環境セットアップ / 依存関係インストール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（環境セットアップ時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | bash または sh が利用可能であること |
| パッケージマネージャー | apt/dnf/apk/brew のいずれかが利用可能であること |
| 管理者権限 | Linux環境ではroot権限またはsudo権限が必要 |
| ネットワーク接続 | パッケージリポジトリへのアクセスが可能であること |

### 実行可否判定

スクリプト冒頭で `set -e` が設定されており、エラー発生時は即座に終了する。OS種別が未サポートの場合はエラーメッセージを出力して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (os) | string | No | 自動検出 | ターゲットOS種別（linux, osx, maccatalyst, ios等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| /etc/os-release | テキストファイル | Linuxディストリビューション情報 |
| init-os-and-arch.sh | シェルスクリプト | OS・アーキテクチャ自動検出 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | インストール進捗メッセージ |
| システムパッケージ | バイナリ | インストールされたツール・ライブラリ |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。システムパッケージマネージャーを通じてソフトウェアをインストールする。

## 処理フロー

### 処理シーケンス

```
1. OS種別の判定
   └─ 引数が指定されていない場合、init-os-and-arch.shで自動検出
2. OS種別に応じた分岐処理
   └─ case文でlinux/osx/その他を判定
3. Linux: ディストリビューション検出
   └─ /etc/os-releaseを読み込んでID/ID_LIKEを取得
4. Linux: パッケージインストール
   └─ Debian系: apt、Fedora系: dnf/tdnf、Alpine: apkでインストール
5. macOS: Homebrewでインストール
   └─ brew bundleコマンドでパッケージをインストール
6. 未サポートOS: エラー終了
   └─ エラーメッセージを出力してexit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{OS引数指定?}
    B -->|あり| C[引数からOS取得]
    B -->|なし| D[init-os-and-arch.sh実行]
    C --> E{OS判定}
    D --> E
    E -->|linux| F{ディストリビューション判定}
    E -->|osx/ios等| G[Homebrew実行]
    E -->|その他| H[エラー終了]
    F -->|Debian系| I[apt install]
    F -->|Fedora系| J[dnf install]
    F -->|Alpine| K[apk add]
    F -->|その他| H
    I --> L[バッチ終了]
    J --> L
    K --> L
    G --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 未サポートOS | サポート外のLinuxディストリビューション | サポート対象のディストリビューションを使用する |
| 1 | 未サポートプラットフォーム | linux/osx以外のOS | サポート対象のOSを使用する |
| 非0 | パッケージインストール失敗 | ネットワークエラー、権限不足等 | ネットワーク接続・権限を確認する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認し、未サポートOS/ディストリビューションの場合は対応環境を使用する
2. パッケージインストール失敗の場合は、手動で個別にパッケージをインストールする
3. ネットワークエラーの場合は接続を確認後、再実行する

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。パッケージインストールは各パッケージマネージャーに依存する。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/環境セットアップ |
| 目標処理時間 | 5-15分（ネットワーク速度依存） |
| メモリ使用量上限 | パッケージマネージャー依存 |

## 排他制御

パッケージマネージャーの排他制御に依存する。同時に複数のパッケージ操作を行わないこと。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | Homebrew実行時 | xcodeバージョン情報 |
| エラーログ | 未サポートOS検出時 | "Unsupported distro"/"Unsupported platform"メッセージ |
| パッケージログ | インストール中 | 各パッケージマネージャーの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプラインログ |
| 実行時間 | 30分以上 | CI/CDパイプラインログ |

## 備考

- Debian系ディストリビューションではlocaledef によるen_US.UTF-8ロケールの設定も行われる
- macOSではHOMEBREW_NO_INSTALL_CLEANUPとHOMEBREW_NO_INSTALLED_DEPENDENTS_CHECKが設定され、余分な処理をスキップする
- Amazon Linux (amzn) は Fedora系とは別のブランチで処理されるが、dnfを使用する
