# バッチ設計書 62-install-tool.ps1

## 概要

本ドキュメントは、Windows環境でビルドツールをダウンロード・インストールするためのPowerShellスクリプト `eng/common/native/install-tool.ps1` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Azure Blob Storageからビルドに必要なネイティブツール（CMake等）をダウンロードし、指定されたインストールパスに展開する。また、ツール実行用のシムファイルを生成することで、PATHを変更せずにツールを利用可能にする。

**業務上の目的・背景**：.NETランタイムのビルドには特定バージョンのネイティブツールが必要であり、システムにインストールされたツールとは異なるバージョンを使用する場合がある。このスクリプトにより、プロジェクト固有のツールバージョンを管理し、再現可能なビルド環境を実現する。

**バッチの実行タイミング**：ビルド前の初期化フェーズで実行される。init-tools-native.ps1等の上位スクリプトから呼び出される。新しいツールバージョンが必要になった場合や、ツールが未インストールの場合に実行される。

**主要な処理内容**：
1. マシンアーキテクチャの検出とツールモニカーの構築
2. Azure Blob Storageからツールアーカイブのダウンロード
3. 指定ディレクトリへのアーカイブ展開
4. ツール実行用シムファイルの生成
5. クリーンアップモードでの既存インストールの削除

**前後の処理との関連**：CommonLibrary.psm1モジュールとpipeline-logging-functions.ps1を読み込む。ダウンロード・展開・シム生成の共通機能を利用する。

**影響範囲**：指定されたインストールディレクトリにツールがインストールされる。システム全体への影響はない。

## バッチ種別

ツールインストール / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルド初期化時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 上位スクリプトからの呼び出し/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell 5.1以降が利用可能であること |
| ネットワーク接続 | Azure Blob Storageへのアクセスが可能であること |
| CommonLibrary.psm1 | 共通ライブラリモジュールが存在すること |
| pipeline-logging-functions.ps1 | ログ関数スクリプトが存在すること |

### 実行可否判定

- `-Force`スイッチが指定されていない場合、既にツールがインストールされていればスキップ
- `-Clean`スイッチが指定されている場合、インストールは行わずクリーンアップのみ実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ToolName | string | Yes | - | インストールするツール名（例：cmake） |
| InstallPath | string | Yes | - | ツールのインストール先ベースディレクトリ |
| BaseUri | string | Yes | - | ツールアーカイブのダウンロード元URI |
| Version | string | Yes | - | インストールするツールのバージョン |
| CommonLibraryDirectory | string | No | $PSScriptRoot | 共通ライブラリの配置ディレクトリ |
| Force | switch | No | $False | 既存インストールを上書きするかどうか |
| Clean | switch | No | $False | クリーンアップモード（インストール削除のみ） |
| DownloadRetries | int | No | 5 | ダウンロード失敗時のリトライ回数 |
| RetryWaitTimeInSeconds | int | No | 30 | リトライ間の待機時間（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure Blob Storage | ZIP | ツールアーカイブファイル |
| CommonLibrary.psm1 | PowerShellモジュール | 共通関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $InstallPath\$ToolName\$Version | ディレクトリ | 展開されたツールファイル |
| $InstallPath\$ToolName.exe | EXE | シムファイル |
| 終了コード | int | 0:成功、1:失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| インストールディレクトリ | $InstallPath\$ToolName\$Version\ |
| シムファイル | $InstallPath\$ToolName.exe |
| ダウンロードURI形式 | $BaseUri/windows/$ToolName/$ToolName-$Version-$ToolOs-$Arch.zip |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ pipeline-logging-functions.ps1とCommonLibrary.psm1を読み込み
2. マシンアーキテクチャ検出
   └─ CommonLibrary\Get-MachineArchitectureでx32/x64を判定
3. ツールモニカー構築
   └─ "$ToolName-$Version-$ToolOs-$Arch"形式で識別子を作成
4. Cleanモードの処理（-Clean指定時）
   └─ インストールディレクトリ、シムファイル、一時ファイルを削除してexit 0
5. インストール判定
   └─ 既存インストールがあり、-Forceでなければスキップ
6. ダウンロードと展開
   └─ CommonLibrary\DownloadAndExtractでアーカイブを取得・展開
7. ツール実行ファイル検索
   └─ インストールディレクトリから$ToolName.exeを再帰検索
8. シム生成
   └─ CommonLibrary\New-ScriptShimでシムファイルを作成
9. 完了
   └─ exit 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[モジュール読み込み]
    B --> C[アーキテクチャ検出]
    C --> D{Cleanモード?}
    D -->|Yes| E[既存ファイル削除]
    E --> F[exit 0]
    D -->|No| G{既存インストールあり?}
    G -->|Yes & !Force| H[スキップ]
    G -->|No or Force| I[DownloadAndExtract]
    H --> J[ツールファイル検索]
    I --> K{ダウンロード成功?}
    K -->|No| L[エラー終了]
    K -->|Yes| J
    J --> M{ファイル発見?}
    M -->|複数| N[エラー終了]
    M -->|なし| O[エラー終了]
    M -->|1件| P[シム生成]
    P --> Q{シム生成成功?}
    Q -->|No| R[エラー終了]
    Q -->|Yes| S[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ダウンロード失敗 | ネットワークエラー、URI不正 | ネットワーク接続・URIを確認 |
| 1 | 展開失敗 | アーカイブ破損 | アーカイブを再ダウンロード |
| 1 | ファイル未発見 | インストール後にツールEXEが見つからない | アーカイブ内容を確認 |
| 1 | 複数ファイル発見 | 同名EXEが複数存在 | アーカイブ構造を確認 |
| 1 | シム生成失敗 | 書き込み権限なし | インストールパスの権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回（DownloadRetries） |
| リトライ間隔 | 30秒（RetryWaitTimeInSeconds） |
| リトライ対象エラー | ダウンロード失敗 |

### 障害時対応

1. Write-PipelineTelemetryErrorでエラーをCI/CDパイプラインに通知
2. 例外発生時はスタックトレースを出力して終了コード1で終了
3. 手動での再実行または-Cleanオプションでのリセット後に再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。部分的なインストールが残る可能性があり、-Cleanオプションでリセット可能。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ツール/回 |
| 目標処理時間 | 1-5分（ネットワーク速度依存） |
| メモリ使用量上限 | アーカイブサイズ依存 |

## 排他制御

同一インストールパスへの同時書き込みは未サポート。複数プロセスからの同時実行は避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | インストールスキップ時 | "$ToolName ($Version) already exists, skipping install" |
| 進捗ログ | クリーンアップ時 | "Cleaning $path"メッセージ |
| エラーログ | インストール失敗時 | "Installation failed"（カテゴリ：NativeToolsetBootstrapping） |
| エラーログ | シム生成失敗時 | "Generate shim failed"（カテゴリ：NativeToolsetBootstrapping） |
| 例外ログ | 例外発生時 | スタックトレースと例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン（Write-PipelineTelemetryError） |
| リトライ回数 | 5回超過 | CI/CDパイプラインログ |

## 備考

- アーキテクチャはx32/x64のみサポート、ARM等は未サポート
- ToolOsはwin32またはwin64が使用される
- シムファイルはツールの実行パスを間接参照するラッパー
- CommonLibrary.psm1のGet-TempPathFilename、DownloadAndExtract、New-ScriptShim関数に依存
