# バッチ設計書 63-SetupNugetSources.sh

## 概要

本ドキュメントは、Linux/macOS環境でNuGet.configに内部フィードを設定するためのシェルスクリプト `eng/common/SetupNugetSources.sh` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、内部パッケージソースへの依存が必要なコミットをビルドするために、NuGet.configファイルに内部フィード（dotnetX-internal、darc-int-*）を追加・有効化する。オプションで認証情報も設定できる。

**業務上の目的・背景**：.NETランタイムの開発では、公開前のパッケージやセキュリティ修正を含む内部パッケージを使用する場合がある。これらのパッケージはAzure DevOpsの内部フィードでホストされており、CI/CD環境でビルドを成功させるためには適切なフィード設定と認証情報が必要である。

**バッチの実行タイミング**：CI/CDパイプラインのビルド前フェーズで実行される。Azure PipelinesのBashタスクとして構成され、NuGetAuthenticate@1タスクの前に実行される必要がある。

**主要な処理内容**：
1. NuGet.configファイルの存在確認とパース
2. 無効化されたdarc-int-*フィードの有効化
3. dotnetX公開フィードに対応する内部フィード（dotnetX-internal、dotnetX-internal-transport）の追加
4. 認証情報（CredToken）が提供された場合、packageSourceCredentialsセクションへの追加

**前後の処理との関連**：本スクリプトはtools.shを読み込む。NuGetAuthenticate@1タスクの前に実行される必要がある。enable-internal-sources.ymlテンプレートから抽象化されて呼び出される。

**影響範囲**：指定されたNuGet.configファイルが変更される。リストア操作で使用されるパッケージソースに影響する。

## バッチ種別

環境設定 / NuGetパッケージソース設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | Azure Pipelinesタスク/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | bash が利用可能であること |
| NuGet.config | 指定パスにNuGet.configファイルが存在すること |
| packageSources | NuGet.configにpackageSourcesセクションが存在すること |
| tools.sh | eng/common/tools.shが存在すること |

### 実行可否判定

- NuGet.configファイルが存在しない場合はエラー終了
- packageSourcesセクションが存在しない場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (ConfigFile) | string | Yes | - | NuGet.configファイルのパス |
| $2 (CredToken) | string | No | - | 内部フィード用の認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | NuGetパッケージソース設定ファイル |
| tools.sh | シェルスクリプト | 共通関数（ExitWithExitCode等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| NuGet.config | XML | 更新されたパッケージソース設定 |
| NuGet.config.bak | XML | 編集前のバックアップファイル |
| 標準出力 | テキスト | 処理進捗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ（上書き） |
| バックアップ | NuGet.config.bak（sedによる自動作成） |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ tools.shを読み込み、シンボリックリンク解決
2. NuGet.config存在確認
   └─ ファイルが存在しない場合はエラー終了
3. OS判定
   └─ macOSの場合、sed用の改行文字を調整
4. packageSources存在確認
   └─ セクションが存在しない場合はエラー終了
5. 認証情報設定（CredToken指定時）
   └─ packageSourceCredentialsセクションを追加（未存在の場合）
6. darc-int-*フィードの有効化
   └─ disabledPackageSourcesから該当エントリを削除
7. dotnetXフィードに対応する内部フィードの追加
   └─ dotnet5〜dotnet10について、-internal/-internal-transportを追加
8. 認証情報の追加（CredToken指定時）
   └─ 各フィードにUsername/ClearTextPasswordを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.sh読み込み]
    B --> C{NuGet.config存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E{packageSourcesあり?}
    E -->|No| F[エラー終了]
    E -->|Yes| G{CredToken指定?}
    G -->|Yes| H[packageSourceCredentials追加]
    G -->|No| I[darc-int-*有効化]
    H --> I
    I --> J[dotnetXループ処理]
    J --> K{dotnetXフィードあり?}
    K -->|Yes| L[内部フィード追加/有効化]
    K -->|No| M[次のバージョンへ]
    L --> M
    M --> N{全バージョン完了?}
    N -->|No| J
    N -->|Yes| O{CredToken指定?}
    O -->|Yes| P[認証情報追加]
    O -->|No| Q[バッチ終了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ファイル未存在 | NuGet.configが見つからない | 正しいパスを指定する |
| 1 | セクション未存在 | packageSourcesセクションがない | NuGet.configにpackageSourcesを追加する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. NuGet.config.bakからバックアップを復元
2. NuGet.configの構文を確認
3. 手動でパッケージソースを追加

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。sedによる編集はバックアップファイルを作成するため、手動でのロールバックが可能。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/回 |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小（sedによるストリーム処理） |

## 排他制御

NuGet.configファイルへの同時書き込みは未サポート。ビルドパイプラインでは単一タスクとして実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | フィード有効化時 | "Enabling internal source '$PackageSourceName'." |
| 情報ログ | フィード追加時 | "Adding package source $SourceName" |
| 情報ログ | 既存フィード検出時 | "Package source $SourceName already present and enabled." |
| 情報ログ | 認証情報追加時 | "Inserting credential for feed: $FeedName" |
| 情報ログ | darc-int確認時 | "Checking for any darc-int disabled package sources..." |
| エラーログ | ファイル未存在時 | パイプラインテレメトリエラー |
| エラーログ | セクション未存在時 | パイプラインテレメトリエラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン（Write-PipelineTelemetryError） |

## 備考

- サポート対象のdotnetバージョンは5, 6, 7, 8, 9, 10
- 認証情報が提供された場合、フィードURIはv2形式（クレデンシャルプロバイダー用）を使用
- 認証情報がない場合、フィードURIはv3/index.json形式を使用
- macOSではsedの改行処理が異なるため、NL変数とTB変数を調整している
- Username固定値："dn-bot"
- darc-int-*フィードは自動的にdisabledPackageSourcesから削除される
