# バッチ設計書 64-SetupNugetSources.ps1

## 概要

本ドキュメントは、Windows環境でNuGet.configに内部フィードを設定するためのPowerShellスクリプト `eng/common/SetupNugetSources.ps1` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、内部パッケージソースへの依存が必要なコミットをビルドするために、NuGet.configファイルに内部フィード（dotnetX-internal、darc-int-*）を追加・有効化する。SetupNugetSources.shのWindows版であり、PowerShellを使用してXMLを直接操作する。

**業務上の目的・背景**：.NETランタイムのWindows環境でのビルドにおいて、公開前のパッケージやセキュリティ修正を含む内部パッケージへのアクセスが必要な場合がある。このスクリプトは内部Azure DevOpsフィードへの認証設定を自動化し、CI/CDビルドを成功させる。

**バッチの実行タイミング**：CI/CDパイプラインのビルド前フェーズで実行される。Azure PipelinesのPowerShellタスクとして構成され、NuGetAuthenticate@1タスクの前に実行される必要がある。

**主要な処理内容**：
1. NuGet.configファイルのXMLとしての読み込み
2. 無効化されたdarc-int-*フィードの有効化（disabledPackageSourcesからの削除）
3. dotnetX公開フィードに対応する内部フィード（dotnetX-internal、dotnetX-internal-transport）の追加
4. 認証情報（Password）が提供された場合、packageSourceCredentialsセクションへの追加

**前後の処理との関連**：本スクリプトはtools.ps1を読み込む。NuGetAuthenticate@1タスクの前に実行される必要がある。enable-internal-sources.ymlテンプレートから抽象化されて呼び出される。

**影響範囲**：指定されたNuGet.configファイルが変更される。リストア操作で使用されるパッケージソースに影響する。

## バッチ種別

環境設定 / NuGetパッケージソース設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | Azure Pipelinesタスク/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell 5.1以降が利用可能であること |
| NuGet.config | 指定パスにNuGet.configファイルが存在すること |
| packageSources | NuGet.configにpackageSourcesセクションが存在すること |
| tools.ps1 | eng/common/tools.ps1が存在すること |

### 実行可否判定

- NuGet.configファイルが存在しない場合はエラー終了
- packageSourcesセクションが存在しない場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ConfigFile | string | Yes | - | NuGet.configファイルのパス |
| Password | string | No | - | 内部フィード用の認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | NuGetパッケージソース設定ファイル |
| tools.ps1 | PowerShellスクリプト | 共通関数（ExitWithExitCode等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| NuGet.config | XML | 更新されたパッケージソース設定 |
| 標準出力 | テキスト | 処理進捗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同じ（上書き保存） |
| 文字コード | UTF-8 |
| 保存方法 | XmlDocument.Save() |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ ErrorActionPreference設定、StrictMode有効化、TLS1.2設定
2. tools.ps1読み込み
   └─ 共通関数のインポート
3. NuGet.config存在確認
   └─ ファイルが存在しない場合はエラー終了
4. XMLドキュメント読み込み
   └─ System.Xml.XmlDocumentとしてロード
5. packageSources取得
   └─ セクションが存在しない場合はエラー終了
6. 認証情報設定（Password指定時）
   └─ packageSourceCredentialsセクションを作成（未存在の場合）
7. darc-int-*フィードの有効化
   └─ disabledPackageSourcesから該当エントリを削除
8. dotnetXフィードに対応する内部フィードの追加
   └─ dotnet5〜dotnet10について、-internal/-internal-transportを追加
9. XMLドキュメント保存
   └─ XmlDocument.Save()で上書き保存
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[初期化設定]
    B --> C[tools.ps1読み込み]
    C --> D{NuGet.config存在?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[XMLドキュメント読み込み]
    F --> G{packageSourcesあり?}
    G -->|No| H[エラー終了]
    G -->|Yes| I{Password指定?}
    I -->|Yes| J[packageSourceCredentials作成]
    I -->|No| K[disabledSources取得]
    J --> K
    K --> L{disabledSourcesあり?}
    L -->|Yes| M[darc-int-*有効化]
    L -->|No| N[dotnetXループ処理]
    M --> N
    N --> O{dotnetXフィードあり?}
    O -->|Yes| P[AddOrEnablePackageSource]
    O -->|No| Q[次のバージョンへ]
    P --> Q
    Q --> R{全バージョン完了?}
    R -->|No| N
    R -->|Yes| S[XML保存]
    S --> T[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ファイル未存在 | NuGet.configが見つからない | 正しいパスを指定する |
| 1 | セクション未存在 | packageSourcesセクションがない | NuGet.configにpackageSourcesを追加する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. 元のNuGet.configを復元
2. NuGet.configのXML構文を確認
3. 手動でパッケージソースを追加

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。XML操作はメモリ上で行い、最後に一括保存する。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル/回 |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小（XMLドキュメントサイズ依存） |

## 排他制御

NuGet.configファイルへの同時書き込みは未サポート。ビルドパイプラインでは単一タスクとして実行すること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | フィード有効化時 | "Enabling internal source '$SourceName'." |
| 情報ログ | フィード追加時 | "Adding package source $SourceName" |
| 情報ログ | 既存フィード検出時 | "Package source $SourceName already present and enabled." |
| 情報ログ | 認証情報追加時 | "Inserting credential for feed: $source" |
| 情報ログ | darc-int確認時 | "Checking for any darc-int disabled package sources..." |
| エラーログ | ファイル未存在時 | パイプラインテレメトリエラー |
| エラーログ | セクション未存在時 | パイプラインテレメトリエラー |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン（Write-PipelineTelemetryError） |

## 備考

- サポート対象のdotnetバージョンは5, 6, 7, 8, 9, 10
- 認証情報が提供された場合、フィードURIはv2形式（クレデンシャルプロバイダー用）を使用
- 認証情報がない場合、フィードURIはv3/index.json形式を使用
- ClearTextPasswordを使用する理由：非Windows .NET SDKでは暗号化パスワードがサポートされていないため（Issue: NuGet/Home#5526）
- Username固定値："dn-bot"
- darc-int-*フィードはRemoveChild()でdisabledPackageSourcesから削除される
- XmlDocument.Save()で保存時、元のファイルエンコーディングが維持される
- Set-StrictMode -Version 2.0でstrictモードを有効化
- TLS1.2が必須（[Net.ServicePointManager]::SecurityProtocol設定）
