# バッチ設計書 65-internal-feed-operations.sh

## 概要

本ドキュメントは、Linux/macOS環境で内部Azure Artifactsフィードへの認証とArcade SDKのリストアを行うためのシェルスクリプト `eng/common/internal-feed-operations.sh` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Azure DevOps内部フィードからのパッケージリストアに必要なCredential Providerのセットアップと環境変数の設定を行う。また、MSBuildの既知の問題（Issue #4430）を回避するためのArcade SDKリストア機能も提供する。

**業務上の目的・背景**：内部ビルドでは、Azure Artifactsの内部フィードからプライベートパッケージを取得する必要がある。NuGet Credential Providerを使用してAzure DevOpsへの認証を行い、VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数を設定することで、CI/CDエージェントが内部フィードにアクセスできるようにする。

**バッチの実行タイミング**：CI/CDパイプラインの内部ビルドフェーズで実行される。内部フィードへのアクセスが必要な場合にのみ呼び出される。

**主要な処理内容**：
1. Credential Providerプラグインのインストール（setup操作）
2. NuGet.configからdarc-int-*フィードのエンドポイントを抽出
3. VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数の設定
4. Arcade SDKのリストア（install-restore操作）

**前後の処理との関連**：本スクリプトはtools.shを読み込む。SetupNugetSources.shによるフィード設定の後に実行されることが想定される。

**影響範囲**：Credential Providerがユーザーのホームディレクトリにインストールされる。Azure Pipelines環境変数が設定される。

## バッチ種別

認証設定 / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（内部ビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CI/CDパイプライン/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| シェル環境 | bash が利用可能であること |
| ネットワーク接続 | GitHub、Azure DevOpsへのアクセスが可能であること |
| NuGet.config | リポジトリルートにNuGet.configが存在すること（setup操作時） |
| tools.sh | eng/common/tools.shが存在すること |
| curl/wget | ダウンロードツールが利用可能であること |

### 実行可否判定

- --operation引数で操作種別を指定する必要がある
- 無効な操作が指定された場合はエラーメッセージを出力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --operation | string | Yes | - | 操作種別（setup / install-restore） |
| --authtoken | string | No（setup時必須） | - | Azure DevOps認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | パッケージソース設定（darc-int-*フィードの抽出元） |
| tools.sh | シェルスクリプト | 共通関数 |
| installcredprovider.sh | シェルスクリプト | GitHubからダウンロードされるCredential Providerインストーラー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ~/.nuget/plugins | ディレクトリ | Credential Providerプラグイン |
| VSS_NUGET_EXTERNAL_FEED_ENDPOINTS | 環境変数 | フィード認証情報JSON |
| NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLED | 環境変数 | セッションキャッシュ無効化フラグ |
| 標準出力 | テキスト | 処理進捗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| Credential Provider | $HOME/.nuget/plugins |
| 環境変数形式 | Azure Pipelines logging command形式 |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ --operation、--authtokenの値を取得
2. tools.sh読み込み
   └─ 共通関数のインポート
3. 操作分岐
   └─ setup / install-restore / その他で分岐

【setup操作】
4. Credential Providerダウンロード
   └─ GitHubからinstallcredprovider.shを取得
5. Credential Providerインストール
   └─ installcredprovider.shを実行
6. インストール確認
   └─ ~/.nuget/pluginsディレクトリの存在を確認
7. NuGet.config解析
   └─ darc-int-*フィードのエンドポイントを抽出
8. 環境変数設定
   └─ VSS_NUGET_EXTERNAL_FEED_ENDPOINTS、セッションキャッシュ無効化を設定

【install-restore操作】
4. dotnet SDKインストール
   └─ バージョン2.1.507をインストール
5. restore.proj作成
   └─ Arcade SDK参照プロジェクトを作成
6. Arcade SDKリストア
   └─ dotnet restoreを実行
7. クリーンアップ
   └─ 一時ファイルとdotnetディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[tools.sh読み込み]
    C --> D{operation判定}
    D -->|setup| E[CredProvider取得]
    D -->|install-restore| F[dotnet SDKインストール]
    D -->|その他| G[エラー出力]

    E --> H[CredProviderインストール]
    H --> I{インストール成功?}
    I -->|No| J[エラー終了]
    I -->|Yes| K[NuGet.config解析]
    K --> L{darc-int-*あり?}
    L -->|Yes| M[環境変数設定]
    L -->|No| N[内部エンドポイントなしメッセージ]
    M --> O[バッチ終了]
    N --> O

    F --> P[restore.proj作成]
    P --> Q[dotnet restore]
    Q --> R[クリーンアップ]
    R --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストール失敗 | Credential Providerインストールに失敗 | ネットワーク接続を確認、手動でインストール |
| 1 | NuGet.config未存在 | リポジトリルートにNuGet.configがない | NuGet.configを作成する |
| - | 無効操作 | 不明なoperation値が指定された | setup または install-restore を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Credential Providerを手動でインストール
2. 環境変数を手動で設定
3. ネットワーク接続を確認して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 1-3分（ネットワーク速度依存） |
| メモリ使用量上限 | 最小 |

## 排他制御

同一ユーザーでの同時実行は避けること（~/.nugetディレクトリへの書き込み競合の可能性）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | セットアップ開始時 | "Setting up Cred Provider NuGet plugin in the agent..." |
| 情報ログ | ダウンロード時 | "Getting 'installcredprovider.ps1' from..." |
| 情報ログ | インストール成功時 | "CredProvider plugin was installed correctly!" |
| 情報ログ | 内部エンドポイントなし時 | "No internal endpoints found in NuGet.config" |
| 情報ログ | Arcadeリストア時 | "Installing dotnet SDK version..." |
| エラーログ | インストール失敗時 | "CredProvider plugin was not installed correctly!" |
| エラーログ | NuGet.config未存在時 | "NuGet.config file not found in repo's root!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| Credential Provider存在 | ~/.nuget/plugins未存在 | CI/CDパイプラインログ |

## 備考

- Credential ProviderはGitHubのmicrosoft/artifacts-credproviderリポジトリからダウンロードされる
- install-restore操作はMSBuild Issue #4430のワークアラウンドとして存在
- dotnet SDKバージョン2.1.507は、Arcade SDKリストアに適したバージョンとして選択されている
- VSS_NUGET_EXTERNAL_FEED_ENDPOINTSは、Credential Providerが認証に使用するJSON形式の環境変数
- NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLEDをFalseに設定することで、エンドポイント更新時のキャッシュ問題を回避
- ##vso[task.setvariable]はAzure Pipelinesのログコマンド形式
