# バッチ設計書 66-internal-feed-operations.ps1

## 概要

本ドキュメントは、Windows環境で内部Azure Artifactsフィードへの認証とArcade SDKのリストアを行うためのPowerShellスクリプト `eng/common/internal-feed-operations.ps1` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Azure DevOps内部フィードからのパッケージリストアに必要なCredential Providerのセットアップと環境変数の設定を行う。internal-feed-operations.shのWindows版であり、PowerShellを使用してCredential Providerのインストールと設定を行う。

**業務上の目的・背景**：内部ビルドでは、Azure Artifactsの内部フィードからプライベートパッケージを取得する必要がある。NuGet Credential Providerを使用してAzure DevOpsへの認証を行い、VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数を設定することで、Windows CI/CDエージェントが内部フィードにアクセスできるようにする。

**バッチの実行タイミング**：CI/CDパイプラインの内部ビルドフェーズで実行される。内部フィードへのアクセスが必要な場合にのみ呼び出される。

**主要な処理内容**：
1. Credential Providerプラグインのインストール（setup操作）
2. NuGet.configからdarc-int-*フィードのエンドポイントを抽出（XPath使用）
3. VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数の設定（Azure Pipelines logging command使用）
4. Arcade SDKのリストア（install-restore操作）

**前後の処理との関連**：本スクリプトはtools.ps1を読み込む。SetupNugetSources.ps1によるフィード設定の後に実行されることが想定される。

**影響範囲**：Credential Providerがユーザープロファイルディレクトリにインストールされる。Azure Pipelines環境変数が設定される。

## バッチ種別

認証設定 / 環境セットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（内部ビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CI/CDパイプライン/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell 5.1以降が利用可能であること |
| ネットワーク接続 | GitHub、Azure DevOpsへのアクセスが可能であること |
| NuGet.config | リポジトリルートにNuGet.configが存在すること（setup操作時） |
| tools.ps1 | eng/common/tools.ps1が存在すること |

### 実行可否判定

- -Operation引数で操作種別を指定する必要がある
- 無効な操作が指定された場合はエラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Operation | string | Yes | - | 操作種別（setup / install-restore） |
| AuthToken | string | No | - | Azure DevOps認証トークン |
| CommitSha | string | No | - | コミットSHA（未使用） |
| RepoName | string | No | - | リポジトリ名（未使用） |
| IsFeedPrivate | switch | No | - | プライベートフィードフラグ（未使用） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| NuGet.config | XML | パッケージソース設定（darc-int-*フィードの抽出元） |
| tools.ps1 | PowerShellスクリプト | 共通関数 |
| installcredprovider.ps1 | PowerShellスクリプト | GitHubからダウンロードされるCredential Providerインストーラー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $env:USERPROFILE\.nuget\plugins\netcore | ディレクトリ | Credential Providerプラグイン |
| VSS_NUGET_EXTERNAL_FEED_ENDPOINTS | 環境変数 | フィード認証情報JSON |
| NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLED | 環境変数 | セッションキャッシュ無効化フラグ |
| 標準出力 | テキスト | 処理進捗メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| Credential Provider | $env:USERPROFILE\.nuget\plugins\netcore |
| 環境変数形式 | Azure Pipelines Write-LoggingCommand形式 |

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ ErrorActionPreference、StrictMode設定
2. tools.ps1読み込み
   └─ 共通関数のインポート
3. 操作分岐
   └─ setup / install-restore / その他で分岐

【setup操作】
4. Credential Providerダウンロード
   └─ Invoke-WebRequestでinstallcredprovider.ps1を取得
5. Credential Providerインストール
   └─ installcredprovider.ps1 -Forceを実行
6. インストール確認
   └─ $env:USERPROFILE\.nuget\plugins\netcoreディレクトリの存在を確認
7. NuGet.config解析
   └─ Select-XmlでXPathを使用してdarc-int-*フィードを抽出
8. 環境変数設定
   └─ Write-LoggingCommandでVSS_NUGET_EXTERNAL_FEED_ENDPOINTS等を設定

【install-restore操作】
4. dotnet SDKインストール
   └─ バージョン2.1.507をインストール
5. restore.proj作成
   └─ Arcade SDK参照プロジェクトを作成
6. Arcade SDKリストア
   └─ dotnet restoreを実行
7. クリーンアップ
   └─ 一時ファイルとdotnetディレクトリを削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[初期化設定]
    B --> C[tools.ps1読み込み]
    C --> D[Push-Location]
    D --> E{Operation判定}
    E -->|setup| F[CredProvider取得]
    E -->|install-restore| G[dotnet SDKインストール]
    E -->|その他| H[エラー終了]

    F --> I[installcredprovider.ps1 -Force]
    I --> J{pluginsディレクトリ存在?}
    J -->|No| K[エラー終了]
    J -->|Yes| L[NuGet.config XPath解析]
    L --> M{darc-int-*あり?}
    M -->|Yes| N[Write-LoggingCommand]
    M -->|No| O[内部エンドポイントなしメッセージ]
    N --> P[バッチ終了]
    O --> P

    G --> Q[restore.proj作成]
    Q --> R[dotnet restore]
    R --> S[クリーンアップ]
    S --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | インストール失敗 | Credential Providerインストールに失敗 | ネットワーク接続を確認、手動でインストール |
| 1 | NuGet.config未存在 | リポジトリルートにNuGet.configがない | NuGet.configを作成する |
| 1 | 無効操作 | 不明なOperation値が指定された | setup または install-restore を指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. Credential Providerを手動でインストール
2. 環境変数を手動で設定
3. ネットワーク接続を確認して再実行
4. 例外発生時はスタックトレースを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回/ビルド |
| 目標処理時間 | 1-3分（ネットワーク速度依存） |
| メモリ使用量上限 | 最小 |

## 排他制御

同一ユーザーでの同時実行は避けること（$env:USERPROFILE\.nugetディレクトリへの書き込み競合の可能性）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | セットアップ開始時 | "Setting up Cred Provider NuGet plugin in the agent..." |
| 情報ログ | ダウンロード時 | "Getting 'installcredprovider.ps1' from..." |
| 情報ログ | インストール成功時 | "CredProvider plugin was installed correctly!" |
| 情報ログ | 内部エンドポイントなし時 | "No internal endpoints found in NuGet.config" |
| 情報ログ | Arcadeリストア時 | "Installing dotnet SDK version..." |
| エラーログ | インストール失敗時 | "CredProvider plugin was not installed correctly!"（カテゴリ：Arcade） |
| エラーログ | NuGet.config未存在時 | "NuGet.config file not found in repo root!"（カテゴリ：Build） |
| エラーログ | 無効操作時 | "Unknown operation '$Operation'!"（カテゴリ：Arcade） |
| 例外ログ | 例外発生時 | スタックトレースと例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| Credential Provider存在 | netcoreディレクトリ未存在 | CI/CDパイプラインログ |

## 備考

- Credential ProviderはGitHubのmicrosoft/artifacts-credproviderリポジトリからダウンロードされる
- install-restore操作はMSBuild Issue #4430のワークアラウンドとして存在
- dotnet SDKバージョン2.1.507は、Arcade SDKリストアに適したバージョンとして選択されている
- Select-Xmlを使用してXPathでdarc-int-*フィードを効率的に抽出
- Write-LoggingCommandはAzure Pipelinesのログコマンドを出力する関数
- ConvertTo-Json -Compressで環境変数値をJSON形式に変換
- try-catch-finallyで例外処理を実装し、finallyでPop-Locationを実行
- installcredprovider.ps1は-Forceオプション付きで実行される
