# バッチ設計書 68-nuget-validation.ps1

## 概要

本ドキュメントは、リリース前にNuGetパッケージのメタデータを検証するためのPowerShellスクリプト `eng/common/post-build/nuget-validation.ps1` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、NuGetパッケージのメタデータ情報（ライセンス、著者、説明など）が正しく設定されているかを検証する。内部でnuget-verification.ps1を呼び出し、NuGet.VerifyMicrosoftPackageツールを使用して検証を実行する。

**業務上の目的・背景**：MicrosoftがNuGet.orgに公開するパッケージは、特定のメタデータ要件を満たす必要がある。これには適切なライセンス表示、著者情報、パッケージアイコン、プロジェクトURL等が含まれる。本スクリプトはリリース前の品質ゲートとして機能し、メタデータ不備を検出する。

**バッチの実行タイミング**：CI/CDパイプラインのポストビルドフェーズで実行される。パッケージ公開前の検証ステップとして構成される。

**主要な処理内容**：
1. CI環境変数の設定
2. tools.ps1の読み込み
3. nuget-verification.ps1への処理委譲
4. 検証結果のエラーハンドリング

**前後の処理との関連**：本スクリプトはtools.ps1を読み込み、nuget-verification.ps1を呼び出す。パッケージビルド完了後、公開前に実行される。

**影響範囲**：検証のみであり、パッケージには影響しない。検証結果に基づいてリリース可否が判断される。

## バッチ種別

検証 / NuGetパッケージ検証 / ポストビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell 5.1以降が利用可能であること |
| ネットワーク接続 | NuGet.orgへのアクセスが可能であること |
| NuGetパッケージ | 検証対象の.nupkgファイルが存在すること |
| nuget-verification.ps1 | 同ディレクトリにnuget-verification.ps1が存在すること |

### 実行可否判定

- PackagesPathに.nupkgファイルが存在しない場合も実行される（nuget-verification.ps1に委譲）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PackagesPath | string | Yes | - | NuGetパッケージ格納ディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGet | 検証対象パッケージファイル |
| tools.ps1 | PowerShellスクリプト | 共通関数 |
| nuget-verification.ps1 | PowerShellスクリプト | 実際の検証ロジック |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証進捗と結果 |
| 終了コード | int | 0:検証成功、1:検証失敗 |

### 出力ファイル仕様

本スクリプトはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ $ci = $true（CI環境フラグ）
   └─ $disableConfigureToolsetImport = $true
2. tools.ps1読み込み
   └─ 共通関数のインポート
3. nuget-verification.ps1呼び出し
   └─ ${PackagesPath}\*.nupkgを引数として渡す
4. 例外処理
   └─ 失敗時はスタックトレースを出力してエラー終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[CI環境変数設定]
    B --> C[tools.ps1読み込み]
    C --> D[nuget-verification.ps1呼び出し]
    D --> E{検証成功?}
    E -->|Yes| F[正常終了]
    E -->|No| G[例外捕捉]
    G --> H[スタックトレース出力]
    H --> I[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | パッケージメタデータが要件を満たさない | パッケージのnuspecを修正 |
| 1 | スクリプトエラー | nuget-verification.ps1実行エラー | エラーメッセージを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. スタックトレースを確認し、エラー原因を特定
2. パッケージのメタデータを確認・修正
3. 再ビルドして検証を再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パッケージ数依存 |
| 目標処理時間 | 1分未満（ツールダウンロード除く） |
| メモリ使用量上限 | 最小 |

## 排他制御

特に排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 例外発生時 | スタックトレース |
| エラーログ | 検証失敗時 | パイプラインテレメトリエラー（カテゴリ：NuGetValidation） |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン（Write-PipelineTelemetryError） |

## 備考

- 本スクリプトは薄いラッパーであり、実際の検証ロジックはnuget-verification.ps1に実装されている
- $ci = $trueを設定することで、tools.ps1内のCI固有の処理が有効になる
- $disableConfigureToolsetImport = $trueを設定することで、ツールセットのインポート処理をスキップする
- ポストビルドスクリプトはビルドと異なるエージェントで実行される可能性があるため、$ci変数を明示的に設定している
