# バッチ設計書 69-nuget-verification.ps1

## 概要

本ドキュメントは、MicrosoftのNuGetパッケージのメタデータを詳細に検証するためのPowerShellスクリプト `eng/common/post-build/nuget-verification.ps1` の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、NuGet.VerifyMicrosoftPackageツールをダウンロードして実行し、NuGetパッケージのメタデータがMicrosoftの公開基準を満たしているかを詳細に検証する。nuget.exeのダウンロード、検証ツールのインストール、パッケージ検証を一貫して実行する。

**業務上の目的・背景**：MicrosoftがNuGet.orgに公開するパッケージは、ライセンス情報、著者情報、説明文、アイコン、プロジェクトURL等の厳格なメタデータ要件を満たす必要がある。NuGet.VerifyMicrosoftPackageツールはNuGetGalleryプロジェクトで開発され、これらの要件を自動的に検証する。

**バッチの実行タイミング**：CI/CDパイプラインのポストビルドフェーズで、nuget-validation.ps1から呼び出される。または直接実行することも可能。

**主要な処理内容**：
1. nuget.exeのダウンロード（未存在の場合）
2. NuGet.VerifyMicrosoftPackageツールのインストール
3. 指定されたNuGetパッケージの検証実行
4. 検証結果の報告

**前後の処理との関連**：nuget-validation.ps1から呼び出される。パッケージビルド完了後、公開前に実行される。

**影響範囲**：検証のみであり、パッケージには影響しない。一時ディレクトリにツールがダウンロードされる。

## バッチ種別

検証 / NuGetパッケージ検証 / ポストビルド

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースビルド時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | nuget-validation.ps1/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | PowerShell 5.1以降が利用可能であること |
| ネットワーク接続 | NuGet.org、dist.nuget.orgへのアクセスが可能であること |
| NuGetパッケージ | 検証対象の.nupkgファイルが存在すること |

### 実行可否判定

- 追加引数（$args）として.nupkgファイルパスが必要
- --helpを指定するとツールのヘルプを表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| NuGetExePath | string | No | - | nuget.exeのパス（指定しない場合はダウンロード） |
| PackageSource | string | No | dotnet-publicフィード | 検証ツールのダウンロード元 |
| DownloadPath | string | No | %TEMP%\NuGet.VerifyMicrosoftPackage | ツールダウンロード先 |
| args | string[] | No | - | 検証ツールに渡す引数（.nupkgファイルパス等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGet | 検証対象パッケージファイル |
| nuget.exe | 実行ファイル | NuGetクライアント |
| NuGet.VerifyMicrosoftPackage | NuGetパッケージ | 検証ツール |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証進捗と結果 |
| 終了コード | int | 0:検証成功、非0:検証失敗 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ダウンロードディレクトリ | $env:TEMP\NuGet.VerifyMicrosoftPackage |
| nuget.exe | ダウンロードディレクトリ内 |
| 検証ツール | NuGet.VerifyMicrosoftPackage.*\tools\ |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ DownloadPath決定（デフォルト: %TEMP%\NuGet.VerifyMicrosoftPackage）
2. ダウンロードディレクトリ作成
   └─ 未存在の場合はNew-Item
3. nuget.exe取得
   └─ NuGetExePath指定あり：そのパスを使用
   └─ NuGetExePath指定なし：dist.nuget.orgからダウンロード
4. NuGet.VerifyMicrosoftPackageインストール
   └─ nuget installでプレリリース版含めて最新をインストール
5. 検証ツールパス解決
   └─ 最新バージョンのディレクトリを検索
6. 検証実行
   └─ NuGet.VerifyMicrosoftPackage.exeを引数付きで実行
7. 結果判定
   └─ LASTEXITCODEに基づいて成功/失敗を報告
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{DownloadPath指定?}
    B -->|No| C[%TEMP%使用]
    B -->|Yes| D[指定パス使用]
    C --> E{ディレクトリ存在?}
    D --> E
    E -->|No| F[ディレクトリ作成]
    E -->|Yes| G{NuGetExePath指定?}
    F --> G
    G -->|No| H{nuget.exe存在?}
    G -->|Yes| I[指定パス使用]
    H -->|No| J[nuget.exeダウンロード]
    H -->|Yes| K[既存を使用]
    J --> L[検証ツールインストール]
    K --> L
    I --> L
    L --> M{インストール成功?}
    M -->|No| N[エラー終了]
    M -->|Yes| O[最新ツールパス検索]
    O --> P[検証実行]
    P --> Q{LASTEXITCODE=0?}
    Q -->|Yes| R[成功メッセージ]
    Q -->|No| S[エラーメッセージ]
    R --> T[終了]
    S --> T
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ダウンロード失敗 | nuget.exeダウンロードエラー | ネットワーク接続確認 |
| 非0 | インストール失敗 | 検証ツールインストールエラー | パッケージソースURL確認 |
| 非0 | 検証失敗 | パッケージメタデータ不備 | nuspecファイル修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. パッケージのnuspecメタデータを確認・修正
3. 再ビルドして検証を再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | - |
| コミットタイミング | - |
| ロールバック条件 | - |

本スクリプトはトランザクション管理を行わない。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パッケージ数依存 |
| 目標処理時間 | 1-2分（初回ツールダウンロード含む） |
| メモリ使用量上限 | 最小 |

## 排他制御

同一DownloadPathへの同時書き込みは避けること。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 初期化時 | "Using download path: $DownloadPath" |
| 情報ログ | nuget.exeダウンロード時 | "Downloading nuget.exe from $nugetExeUrl..." |
| 情報ログ | nuget.exeパス使用時 | "Using nuget.exe path: $nuget" |
| 情報ログ | ツールインストール時 | "Downloading the latest version of $packageId..." |
| 情報ログ | ツールパス解決時 | "Using verification tool: $verify" |
| 情報ログ | 検証実行時 | "Executing the verify tool..." |
| 情報ログ | 成功時 | "The verify tool succeeded." |
| エラーログ | ダウンロード失敗時 | "nuget.exe failed to download." |
| エラーログ | インストール失敗時 | "nuget.exe failed to fetch the verify tool." |
| エラーログ | 検証失敗時 | "The verify tool found some problems." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |
| nuget.exeダウンロード | 失敗時 | 標準エラー出力 |

## 備考

- スクリプトはNuGetGalleryリポジトリから移植されたもの
  - 元リポジトリ: https://github.com/NuGet/NuGetGallery/blob/master/src/VerifyMicrosoftPackage/README.md
- nuget.exeバージョン: v4.9.4
- 検証ツールパッケージID: NuGet.VerifyMicrosoftPackage
- パッケージソースデフォルト: https://pkgs.dev.azure.com/dnceng/public/_packaging/dotnet-public/nuget/v3/index.json
- -Prereleaseオプションでプレリリース版も含めてインストール
- ツールディレクトリは LastWriteTime でソートして最新を選択
- 検証ツールパス: tools\NuGet.VerifyMicrosoftPackage.exe
- 区切り線（fence）は80文字の「=」で構成
- Invoke-WebRequestは-UseBasicParsingオプション付きで実行（HTMLパース不要のため高速）
